/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.authentication.AuthenticationPluginLoader;
import org.mariadb.jdbc.credential.Credential;
import org.mariadb.jdbc.credential.CredentialPlugin;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.com.read.ReadInitialHandShakePacket;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.send.SendClosePacket;
import org.mariadb.jdbc.internal.com.send.SendHandshakeResponsePacket;
import org.mariadb.jdbc.internal.com.send.SendSslConnectionRequestPacket;
import org.mariadb.jdbc.internal.com.send.authentication.OldPasswordPlugin;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.io.LruTraceCache;
import org.mariadb.jdbc.internal.io.input.DecompressPacketInputStream;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.input.StandardPacketInputStream;
import org.mariadb.jdbc.internal.io.output.CompressPacketOutputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.io.output.StandardPacketOutputStream;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.ServerPrepareStatementCache;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.constant.HaMode;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;
import org.mariadb.jdbc.tls.TlsSocketPlugin;
import org.mariadb.jdbc.tls.TlsSocketPluginLoader;
import org.mariadb.jdbc.util.Options;

public abstract class AbstractConnectProtocol
implements Protocol {
    private static final byte[] SESSION_QUERY = "SELECT @@max_allowed_packet,@@system_time_zone,@@time_zone,@@auto_increment_increment".getBytes(StandardCharsets.UTF_8);
    private static final byte[] IS_MASTER_QUERY = "select @@innodb_read_only".getBytes(StandardCharsets.UTF_8);
    protected static final String CHECK_GALERA_STATE_QUERY = "show status like 'wsrep_local_state'";
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectProtocol.class);
    protected final ReentrantLock lock;
    protected final UrlParser urlParser;
    protected final Options options;
    protected final LruTraceCache traceCache;
    private final String username;
    private final GlobalStateInfo globalInfo;
    public boolean hasWarnings = false;
    public Results activeStreamingResult = null;
    public short serverStatus;
    protected int autoIncrementIncrement;
    protected Socket socket;
    protected PacketOutputStream writer;
    protected boolean readOnly = false;
    protected PacketInputStream reader;
    protected FailoverProxy proxy;
    protected volatile boolean connected = false;
    protected boolean explicitClosed = false;
    protected String database;
    protected long serverThreadId;
    protected ServerPrepareStatementCache serverPrepareStatementCache;
    protected boolean eofDeprecated = false;
    protected long serverCapabilities;
    protected int socketTimeout;
    protected ExceptionFactory exceptionFactory;
    protected final List<String> galeraAllowedStates;
    private HostAddress currentHost;
    private boolean hostFailed;
    private String serverVersion;
    private boolean serverMariaDb;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private TimeZone timeZone;

    public AbstractConnectProtocol(UrlParser urlParser, GlobalStateInfo globalInfo, ReentrantLock lock, LruTraceCache traceCache) {
        urlParser.auroraPipelineQuirks();
        this.lock = lock;
        this.urlParser = urlParser;
        this.options = urlParser.getOptions();
        this.database = urlParser.getDatabase() == null ? "" : urlParser.getDatabase();
        this.username = urlParser.getUsername() == null ? "" : urlParser.getUsername();
        this.globalInfo = globalInfo;
        if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
            this.serverPrepareStatementCache = ServerPrepareStatementCache.newInstance(this.options.prepStmtCacheSize, this);
        }
        this.galeraAllowedStates = urlParser.getOptions().galeraAllowedState == null ? Collections.emptyList() : Arrays.asList(urlParser.getOptions().galeraAllowedState.split(","));
        this.traceCache = traceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeSocket(PacketInputStream packetInputStream, PacketOutputStream packetOutputStream, Socket socket) {
        try {
            try {
                long maxCurrentMillis = System.currentTimeMillis() + 10L;
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream is = socket.getInputStream();
                while (is.read() != -1 && System.currentTimeMillis() < maxCurrentMillis) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            packetOutputStream.close();
            packetInputStream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static Socket createSocket(String host, int port, Options options) throws SQLException {
        try {
            Socket socket = Utils.createSocket(options, host);
            socket.setTcpNoDelay(options.tcpNoDelay);
            if (options.connectTimeout > 0) {
                socket.setSoTimeout(options.connectTimeout);
            } else if (options.socketTimeout != null && options.socketTimeout > 0) {
                socket.setSoTimeout(options.socketTimeout);
            }
            if (options.tcpKeepAlive) {
                socket.setKeepAlive(true);
            }
            if (options.tcpRcvBuf != null) {
                socket.setReceiveBufferSize(options.tcpRcvBuf);
            }
            if (options.tcpSndBuf != null) {
                socket.setSendBufferSize(options.tcpSndBuf);
            }
            if (options.tcpAbortiveClose) {
                socket.setSoLinger(true, 0);
            }
            if (options.localSocketAddress != null) {
                InetSocketAddress localAddress = new InetSocketAddress(options.localSocketAddress, 0);
                socket.bind(localAddress);
            }
            if (!socket.isConnected()) {
                InetSocketAddress sockAddr = options.pipe == null && options.localSocket == null ? new InetSocketAddress(host, port) : null;
                socket.connect(sockAddr, options.connectTimeout);
            }
            return socket;
        }
        catch (IOException ioe) {
            throw ExceptionFactory.INSTANCE.create(String.format("Socket fail to connect to host:%s, port:%s. %s", host, port, ioe.getMessage()), "08000", ioe);
        }
    }

    private static long initializeClientCapabilities(Options options, long serverCapabilities, String database) {
        long capabilities = 12493568L;
        if (options.allowLocalInfile) {
            capabilities |= 0x80L;
        }
        if (!options.useAffectedRows) {
            capabilities |= 2L;
        }
        if (options.allowMultiQueries || options.rewriteBatchedStatements) {
            capabilities |= 0x10000L;
        }
        if ((serverCapabilities & 0x1000000L) != 0L) {
            capabilities |= 0x1000000L;
        }
        if (options.useBulkStmts && (serverCapabilities & 0x400000000L) != 0L) {
            capabilities |= 0x400000000L;
        }
        if (options.useCompression) {
            if ((serverCapabilities & 0x20L) == 0L) {
                options.useCompression = false;
            } else {
                capabilities |= 0x20L;
            }
        }
        if (options.interactiveClient) {
            capabilities |= 0x400L;
        }
        if (!database.isEmpty() && !options.createDatabaseIfNotExist) {
            capabilities |= 8L;
        }
        if (Boolean.TRUE.equals(options.useSsl)) {
            capabilities |= 0x800L;
        }
        return capabilities;
    }

    private static void enabledSslProtocolSuites(SSLSocket sslSocket, Options options) throws SQLException {
        if (options.enabledSslProtocolSuites != null) {
            String[] protocols;
            List<String> possibleProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
            for (String protocol : protocols = options.enabledSslProtocolSuites.split("[,;\\s]+")) {
                if (possibleProtocols.contains(protocol)) continue;
                throw new SQLException("Unsupported SSL protocol '" + protocol + "'. Supported protocols : " + possibleProtocols.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    private static void enabledSslCipherSuites(SSLSocket sslSocket, Options options) throws SQLException {
        if (options.enabledSslCipherSuites != null) {
            String[] ciphers;
            List<String> possibleCiphers = Arrays.asList(sslSocket.getSupportedCipherSuites());
            for (String cipher : ciphers = options.enabledSslCipherSuites.split("[,;\\s]+")) {
                if (possibleCiphers.contains(cipher)) continue;
                throw new SQLException("Unsupported SSL cipher '" + cipher + "'. Supported ciphers : " + possibleCiphers.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledCipherSuites(ciphers);
        }
    }

    @Override
    public void close() {
        boolean locked = false;
        if (this.lock != null) {
            locked = this.lock.tryLock();
        }
        this.connected = false;
        try {
            this.skip();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SendClosePacket.send(this.writer);
        AbstractConnectProtocol.closeSocket(this.reader, this.writer, this.socket);
        this.cleanMemory();
        if (locked) {
            this.lock.unlock();
        }
    }

    @Override
    public void abort() {
        if (logger.isDebugEnabled()) {
            logger.debug("aborting connection {}", (Object)this.serverThreadId);
        }
        this.explicitClosed = true;
        boolean lockStatus = false;
        if (this.lock != null) {
            lockStatus = this.lock.tryLock();
        }
        this.connected = false;
        this.abortActiveStream();
        if (!lockStatus) {
            this.forceAbort();
            try {
                this.socket.setSoTimeout(10);
                this.socket.setSoLinger(true, 0);
            }
            catch (IOException iOException) {}
        } else {
            SendClosePacket.send(this.writer);
        }
        AbstractConnectProtocol.closeSocket(this.reader, this.writer, this.socket);
        this.cleanMemory();
        if (lockStatus) {
            this.lock.unlock();
        }
    }

    private void forceAbort() {
        try (MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new GlobalStateInfo(), new ReentrantLock(), this.traceCache);){
            copiedProtocol.setHostAddress(this.getHostAddress());
            copiedProtocol.connect();
            copiedProtocol.executeQuery("KILL " + this.serverThreadId);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void abortActiveStream() {
        try {
            if (this.activeStreamingResult != null) {
                this.activeStreamingResult.abort();
                this.activeStreamingResult = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void skip() throws SQLException {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.loadFully(true, this);
            this.activeStreamingResult = null;
        }
    }

    private void cleanMemory() {
        if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
            this.serverPrepareStatementCache.clear();
        }
        if (this.options.enablePacketDebug) {
            this.traceCache.clearMemory();
        }
    }

    @Override
    public void setServerStatus(short serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Override
    public void removeHasMoreResults() {
        if (this.hasMoreResults()) {
            this.serverStatus = (short)(this.serverStatus ^ 8);
        }
    }

    @Override
    public void connect() throws SQLException {
        try {
            this.createConnection(this.currentHost, this.username);
        }
        catch (SQLException exception) {
            throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s. %s", this.currentHost, exception.getMessage() + this.getTraces()), "08000", exception);
        }
    }

    private void createConnection(HostAddress hostAddress, String username) throws SQLException {
        String host = hostAddress != null ? hostAddress.host : null;
        int port = hostAddress != null ? hostAddress.port : 3306;
        CredentialPlugin credentialPlugin = this.urlParser.getCredentialPlugin();
        Credential credential = credentialPlugin != null ? (Credential)credentialPlugin.initialize(this.options, username, hostAddress).get() : new Credential(username, this.urlParser.getPassword());
        this.socket = AbstractConnectProtocol.createSocket(host, port, this.options);
        this.assignStream(this.socket, this.options);
        try {
            ReadInitialHandShakePacket greetingPacket = new ReadInitialHandShakePacket(this.reader);
            this.serverThreadId = greetingPacket.getServerThreadId();
            this.serverVersion = greetingPacket.getServerVersion();
            this.serverMariaDb = greetingPacket.isServerMariaDb();
            this.serverCapabilities = greetingPacket.getServerCapabilities();
            this.reader.setServerThreadId(this.serverThreadId, null);
            this.writer.setServerThreadId(this.serverThreadId, null);
            this.parseVersion(greetingPacket.getServerVersion());
            byte exchangeCharset = this.decideLanguage(greetingPacket.getServerLanguage() & 0xFF);
            long clientCapabilities = AbstractConnectProtocol.initializeClientCapabilities(this.options, this.serverCapabilities, this.database);
            this.exceptionFactory = ExceptionFactory.of(this.serverThreadId, this.options);
            this.sslWrapper(host, this.socket, this.options, greetingPacket.getServerCapabilities(), clientCapabilities, exchangeCharset, this.serverThreadId);
            String authenticationPluginType = greetingPacket.getAuthenticationPluginType();
            if (credentialPlugin != null && credentialPlugin.defaultAuthenticationPluginType() != null) {
                authenticationPluginType = credentialPlugin.defaultAuthenticationPluginType();
            }
            this.authenticationHandler(exchangeCharset, clientCapabilities, authenticationPluginType, greetingPacket.getSeed(), this.options, this.database, credential, host);
            this.compressionHandler(this.options);
        }
        catch (IOException ioException) {
            this.destroySocket();
            if (host == null) {
                throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to socket : %s", ioException.getMessage()), "08000", ioException);
            }
            throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s:%s : %s", host, this.socket.getPort(), ioException.getMessage()), "08000", ioException);
        }
        catch (SQLException sqlException) {
            this.destroySocket();
            throw sqlException;
        }
        this.connected = true;
        this.reader.setServerThreadId(this.serverThreadId, this.isMasterConnection());
        this.writer.setServerThreadId(this.serverThreadId, this.isMasterConnection());
        if ((this.serverCapabilities & 0x1000000L) != 0L) {
            this.eofDeprecated = true;
        }
        this.postConnectionQueries();
        if (this.isMasterConnection() && !this.galeraAllowedStates.isEmpty()) {
            this.galeraStateValidation();
        }
        this.activeStreamingResult = null;
        this.hostFailed = false;
    }

    public void destroySocket() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sslWrapper(String host, Socket socket, Options options, long serverCapabilities, long clientCapabilities, byte exchangeCharset, long serverThreadId) throws SQLException, IOException {
        if (Boolean.TRUE.equals(options.useSsl)) {
            if ((serverCapabilities & 0x800L) == 0L) {
                throw this.exceptionFactory.create("Trying to connect with ssl, but ssl not enabled in the server", "08000");
            }
            SendSslConnectionRequestPacket.send(this.writer, clientCapabilities |= 0x800L, exchangeCharset);
            TlsSocketPlugin socketPlugin = TlsSocketPluginLoader.get(options.tlsSocketType);
            SSLSocketFactory sslSocketFactory = socketPlugin.getSocketFactory(options);
            SSLSocket sslSocket = socketPlugin.createSocket(socket, sslSocketFactory);
            AbstractConnectProtocol.enabledSslProtocolSuites(sslSocket, options);
            AbstractConnectProtocol.enabledSslCipherSuites(sslSocket, options);
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
            if (!options.disableSslHostnameVerification && !options.trustServerCertificate) {
                SSLSession session = sslSocket.getSession();
                try {
                    socketPlugin.verify(host, session, options, serverThreadId);
                }
                catch (SSLException ex) {
                    throw this.exceptionFactory.create("SSL hostname verification failed : " + ex.getMessage() + "\nThis verification can be disabled using the option \"disableSslHostnameVerification\" but won't prevent man-in-the-middle attacks anymore", "08006");
                }
            }
            this.assignStream(sslSocket, options);
        }
    }

    private void authenticationHandler(byte exchangeCharset, long clientCapabilities, String authenticationPluginType, byte[] seed, Options options, String database, Credential credential, String host) throws SQLException, IOException {
        SendHandshakeResponsePacket.send(this.writer, credential, host, database, clientCapabilities, this.serverCapabilities, exchangeCharset, (byte)(Boolean.TRUE.equals(options.useSsl) ? 2 : 1), options, authenticationPluginType, seed);
        this.writer.permitTrace(false);
        Buffer buffer = this.reader.getPacket(false);
        AtomicInteger sequence = new AtomicInteger(this.reader.getLastPacketSeq());
        block5: while (true) {
            switch (buffer.getByteAt(0) & 0xFF) {
                case 254: {
                    AuthenticationPlugin authenticationPlugin;
                    sequence.set(this.reader.getLastPacketSeq());
                    if ((this.serverCapabilities & 0x80000L) != 0L) {
                        String plugin;
                        buffer.readByte();
                        if (buffer.remaining() > 0) {
                            plugin = buffer.readStringNullEnd(StandardCharsets.US_ASCII);
                            seed = buffer.readRawBytes(buffer.remaining());
                        } else {
                            plugin = "mysql_old_password";
                            seed = Utils.copyWithLength(seed, 8);
                        }
                        authenticationPlugin = AuthenticationPluginLoader.get(plugin);
                    } else {
                        authenticationPlugin = new OldPasswordPlugin();
                        seed = Utils.copyWithLength(seed, 8);
                    }
                    if (authenticationPlugin.mustUseSsl() && options.useSsl == null) {
                        throw this.exceptionFactory.create("Connector use a plugin that require SSL without enabling ssl. For compatibility, this can still be disabled explicitly forcing 'useSsl=false' in connection string.plugin is = " + authenticationPlugin.type(), "08004", 1251);
                    }
                    authenticationPlugin.initialize(credential.getPassword(), seed, options);
                    buffer = authenticationPlugin.process(this.writer, this.reader, sequence);
                    continue block5;
                }
                case 255: {
                    ErrorPacket errorPacket = new ErrorPacket(buffer);
                    if (credential.getPassword() != null && !credential.getPassword().isEmpty() && options.passwordCharacterEncoding == null && errorPacket.getErrorCode() == 1045 && "28000".equals(errorPacket.getSqlState())) {
                        throw this.exceptionFactory.create(String.format("%s\nCurrent charset is %s. If password has been set using other charset, consider using option 'passwordCharacterEncoding'", errorPacket.getMessage(), Charset.defaultCharset().displayName()), errorPacket.getSqlState(), errorPacket.getErrorCode());
                    }
                    throw this.exceptionFactory.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
                }
                case 0: {
                    buffer.skipByte();
                    buffer.skipLengthEncodedNumeric();
                    buffer.skipLengthEncodedNumeric();
                    this.serverStatus = buffer.readShort();
                    break block5;
                }
                default: {
                    throw this.exceptionFactory.create("unexpected data during authentication (header=" + (buffer.getByteAt(0) & 0xFF), "08000");
                }
            }
            break;
        }
        this.writer.permitTrace(true);
    }

    private void compressionHandler(Options options) {
        if (options.useCompression) {
            this.writer = new CompressPacketOutputStream(this.writer.getOutputStream(), options.maxQuerySizeToLog, this.serverThreadId);
            this.reader = new DecompressPacketInputStream(((StandardPacketInputStream)this.reader).getInputStream(), options.maxQuerySizeToLog, this.serverThreadId);
            if (options.enablePacketDebug) {
                this.writer.setTraceCache(this.traceCache);
                this.reader.setTraceCache(this.traceCache);
            }
        }
    }

    private void assignStream(Socket socket, Options options) throws SQLException {
        try {
            this.writer = new StandardPacketOutputStream(socket.getOutputStream(), options, this.serverThreadId);
            this.reader = new StandardPacketInputStream(socket.getInputStream(), options, this.serverThreadId);
            if (options.enablePacketDebug) {
                this.writer.setTraceCache(this.traceCache);
                this.reader.setTraceCache(this.traceCache);
            }
        }
        catch (IOException ioe) {
            this.destroySocket();
            throw ExceptionFactory.INSTANCE.create("Socket error: " + ioe.getMessage(), "08000", ioe);
        }
    }

    private void galeraStateValidation() throws SQLException {
        SelectResultSet rs;
        try {
            Results results = new Results();
            this.executeQuery(true, results, CHECK_GALERA_STATE_QUERY);
            results.commandEnd();
            rs = results.getResultSet();
        }
        catch (SQLException sqle) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create("fail to validate Galera state");
        }
        if (rs == null || !rs.next()) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create("fail to validate Galera state");
        }
        if (!this.galeraAllowedStates.contains(rs.getString(2))) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(String.format("fail to validate Galera state (State is %s)", rs.getString(2)));
        }
    }

    private void postConnectionQueries() throws SQLException {
        try {
            Integer timeout = this.options.connectTimeout > 0 ? this.options.connectTimeout : this.options.socketTimeout;
            if (this.options.usePipelineAuth.booleanValue() && (timeout == null || timeout == 0 || timeout > 500)) {
                this.socket.setSoTimeout(500);
            }
            boolean mustLoadAdditionalInfo = true;
            if (this.globalInfo != null && this.globalInfo.isAutocommit() == this.options.autocommit) {
                mustLoadAdditionalInfo = false;
            }
            if (mustLoadAdditionalInfo) {
                TreeMap<String, String> serverData = new TreeMap<String, String>();
                if (this.options.usePipelineAuth.booleanValue() && !this.options.createDatabaseIfNotExist) {
                    try {
                        this.sendPipelineAdditionalData();
                        this.readPipelineAdditionalData(serverData);
                    }
                    catch (SQLException sqle) {
                        if (sqle.getSQLState() != null && sqle.getSQLState().startsWith("08")) {
                            throw sqle;
                        }
                        this.additionalData(serverData);
                    }
                } else {
                    this.additionalData(serverData);
                }
                this.writer.setMaxAllowedPacket(Integer.parseInt((String)serverData.get("max_allowed_packet")));
                this.autoIncrementIncrement = Integer.parseInt((String)serverData.get("auto_increment_increment"));
                this.loadCalendar((String)serverData.get("time_zone"), (String)serverData.get("system_time_zone"));
            } else {
                this.writer.setMaxAllowedPacket((int)this.globalInfo.getMaxAllowedPacket());
                this.autoIncrementIncrement = this.globalInfo.getAutoIncrementIncrement();
                this.loadCalendar(this.globalInfo.getTimeZone(), this.globalInfo.getSystemTimeZone());
            }
            this.reader.setServerThreadId(this.serverThreadId, this.isMasterConnection());
            this.writer.setServerThreadId(this.serverThreadId, this.isMasterConnection());
            this.activeStreamingResult = null;
            this.hostFailed = false;
            this.socketTimeout = this.options.socketTimeout == null ? 0 : this.options.socketTimeout;
            this.socket.setSoTimeout(this.socketTimeout);
        }
        catch (SocketTimeoutException timeoutException) {
            this.destroySocket();
            String msg = "Socket error during post connection queries: " + timeoutException.getMessage();
            if (this.options.usePipelineAuth.booleanValue()) {
                msg = msg + "\nServer might not support pipelining, try disabling with option `usePipelineAuth` and `useBatchMultiSend`";
            }
            throw this.exceptionFactory.create(msg, "08000", timeoutException);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.create("Socket error during post connection queries: " + ioException.getMessage(), "08000", ioException);
        }
        catch (SQLException sqlException) {
            this.destroySocket();
            throw sqlException;
        }
    }

    private void sendPipelineAdditionalData() throws IOException {
        this.sendSessionInfos();
        this.sendRequestSessionVariables();
        this.sendPipelineCheckMaster();
    }

    private void sendSessionInfos() throws IOException {
        StringBuilder sessionOption = new StringBuilder("autocommit=").append(this.options.autocommit ? "1" : "0");
        if ((this.serverCapabilities & 0x800000L) != 0L && this.options.rewriteBatchedStatements) {
            sessionOption.append(", session_track_system_variables='auto_increment_increment' ");
        }
        if (this.options.jdbcCompliantTruncation) {
            sessionOption.append(", sql_mode = concat(@@sql_mode,',STRICT_TRANS_TABLES')");
        }
        if (this.options.sessionVariables != null && !this.options.sessionVariables.isEmpty()) {
            sessionOption.append(",").append(Utils.parseSessionVariables(this.options.sessionVariables));
        }
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("set " + sessionOption.toString());
        this.writer.flush();
    }

    private void sendRequestSessionVariables() throws IOException {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write(SESSION_QUERY);
        this.writer.flush();
    }

    private void readRequestSessionVariables(Map<String, String> serverData) throws SQLException {
        Results results = new Results();
        this.getResult(results);
        results.commandEnd();
        SelectResultSet resultSet = results.getResultSet();
        if (resultSet == null) {
            throw this.exceptionFactory.create("Error reading SessionVariables results. Socket is connected ? " + this.socket.isConnected(), "08000");
        }
        resultSet.next();
        serverData.put("max_allowed_packet", resultSet.getString(1));
        serverData.put("system_time_zone", resultSet.getString(2));
        serverData.put("time_zone", resultSet.getString(3));
        serverData.put("auto_increment_increment", resultSet.getString(4));
    }

    private void sendCreateDatabaseIfNotExist(String quotedDb) throws IOException {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("CREATE DATABASE IF NOT EXISTS " + quotedDb);
        this.writer.flush();
    }

    private void sendUseDatabaseIfNotExist(String quotedDb) throws IOException {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("USE " + quotedDb);
        this.writer.flush();
    }

    private void readPipelineAdditionalData(Map<String, String> serverData) throws SQLException {
        boolean canTrySessionWithShow;
        SQLException resultingException;
        block10: {
            block9: {
                resultingException = null;
                try {
                    this.getResult(new Results());
                }
                catch (SQLException sqlException) {
                    resultingException = sqlException;
                }
                canTrySessionWithShow = false;
                try {
                    this.readRequestSessionVariables(serverData);
                }
                catch (SQLException sqlException) {
                    if (resultingException != null && resultingException.getSQLState() != null && !resultingException.getSQLState().startsWith("08") && sqlException.getSQLState() != null && sqlException.getSQLState().startsWith("08")) {
                        throw new SQLException(resultingException.getMessage(), "08000", resultingException.getErrorCode(), resultingException);
                    }
                    if (resultingException != null) break block9;
                    resultingException = this.exceptionFactory.create("could not load system variables", "08000", sqlException);
                    canTrySessionWithShow = true;
                }
            }
            try {
                this.readPipelineCheckMaster();
            }
            catch (SQLException sqlException) {
                canTrySessionWithShow = false;
                if (resultingException != null) break block10;
                throw this.exceptionFactory.create("could not identified if server is master", "08000", sqlException);
            }
        }
        if (canTrySessionWithShow) {
            this.requestSessionDataWithShow(serverData);
            this.connected = true;
            return;
        }
        if (resultingException != null) {
            throw resultingException;
        }
        this.connected = true;
    }

    private void requestSessionDataWithShow(Map<String, String> serverData) throws SQLException {
        try {
            Results results = new Results();
            this.executeQuery(true, results, "SHOW VARIABLES WHERE Variable_name in ('max_allowed_packet','system_time_zone','time_zone','auto_increment_increment')");
            results.commandEnd();
            SelectResultSet resultSet = results.getResultSet();
            if (resultSet != null) {
                while (resultSet.next()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("server data {} = {}", (Object)resultSet.getString(1), (Object)resultSet.getString(2));
                    }
                    serverData.put(resultSet.getString(1), resultSet.getString(2));
                }
                if (serverData.size() < 4) {
                    throw this.exceptionFactory.create("could not load system variables. socket connected: " + this.socket.isConnected(), "08000");
                }
            }
        }
        catch (SQLException sqlException) {
            throw this.exceptionFactory.create("could not load system variables", "08000", sqlException);
        }
    }

    private void additionalData(Map<String, String> serverData) throws IOException, SQLException {
        this.sendSessionInfos();
        this.getResult(new Results());
        try {
            this.sendRequestSessionVariables();
            this.readRequestSessionVariables(serverData);
        }
        catch (SQLException sqlException) {
            this.requestSessionDataWithShow(serverData);
        }
        this.sendPipelineCheckMaster();
        this.readPipelineCheckMaster();
        if (this.options.createDatabaseIfNotExist && !this.database.isEmpty()) {
            String quotedDb = MariaDbConnection.quoteIdentifier(this.database);
            this.sendCreateDatabaseIfNotExist(quotedDb);
            this.getResult(new Results());
            this.sendUseDatabaseIfNotExist(quotedDb);
            this.getResult(new Results());
        }
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private void loadCalendar(String srvTimeZone, String srvSystemTimeZone) throws SQLException {
        if (this.options.useLegacyDatetimeCode) {
            this.timeZone = null;
        } else {
            String tz = this.options.serverTimezone;
            if (tz == null && "SYSTEM".equals(tz = srvTimeZone)) {
                tz = srvSystemTimeZone;
            }
            if (tz != null && tz.length() >= 2 && (tz.startsWith("+") || tz.startsWith("-")) && Character.isDigit(tz.charAt(1))) {
                tz = "GMT" + tz;
            }
            try {
                this.timeZone = Utils.getTimeZone(tz);
                if (this.timeZone.equals(TimeZone.getDefault())) {
                    this.timeZone = null;
                }
            }
            catch (SQLException e) {
                if (this.options.serverTimezone != null) {
                    throw this.exceptionFactory.create("The server time_zone '" + tz + "' defined in the 'serverTimezone' parameter cannot be parsed by java TimeZone implementation. See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", "01S00");
                }
                throw this.exceptionFactory.create("The server time_zone '" + tz + "' cannot be parsed. The server time zone must defined in the jdbc url string with the 'serverTimezone' parameter (or server time zone must be defined explicitly with sessionVariables=time_zone='Canada/Atlantic' for example).  See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", "01S00");
            }
        }
    }

    @Override
    public boolean checkIfMaster() throws SQLException {
        return this.isMasterConnection();
    }

    private byte decideLanguage(int serverLanguage) {
        if (serverLanguage == 45 || serverLanguage == 46 || serverLanguage >= 224 && serverLanguage <= 247) {
            return (byte)serverLanguage;
        }
        if (this.getMajorServerVersion() == 5 && this.getMinorServerVersion() <= 1) {
            return 33;
        }
        if (serverLanguage == 33) {
            return 45;
        }
        if (serverLanguage == 83) {
            return 46;
        }
        if (serverLanguage >= 192 && serverLanguage <= 215) {
            return (byte)(serverLanguage + 32);
        }
        return -32;
    }

    @Override
    public void readEofPacket() throws SQLException, IOException {
        Buffer buffer = this.reader.getPacket(true);
        switch (buffer.getByteAt(0)) {
            case -2: {
                buffer.skipByte();
                this.hasWarnings = buffer.readShort() > 0;
                this.serverStatus = buffer.readShort();
                break;
            }
            case -1: {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw this.exceptionFactory.create("Could not connect: " + ep.getMessage(), ep.getSqlState(), ep.getErrorCode());
            }
            default: {
                throw this.exceptionFactory.create("Unexpected packet type " + buffer.getByteAt(0) + " instead of EOF", "08000");
            }
        }
    }

    @Override
    public void skipEofPacket() throws SQLException, IOException {
        Buffer buffer = this.reader.getPacket(true);
        switch (buffer.getByteAt(0)) {
            case -2: {
                break;
            }
            case -1: {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw this.exceptionFactory.create("Could not connect: " + ep.getMessage(), ep.getSqlState(), ep.getErrorCode());
            }
            default: {
                throw this.exceptionFactory.create("Unexpected packet type " + buffer.getByteAt(0) + " instead of EOF");
            }
        }
    }

    @Override
    public void setHostFailedWithoutProxy() {
        this.hostFailed = true;
        this.close();
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public boolean isMasterConnection() {
        return this.currentHost == null || "master".equals(this.currentHost.type);
    }

    private void sendPipelineCheckMaster() throws IOException {
        if (this.urlParser.getHaMode() == HaMode.AURORA) {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(IS_MASTER_QUERY);
            this.writer.flush();
        }
    }

    public void readPipelineCheckMaster() throws SQLException {
    }

    @Override
    public boolean mustBeMasterConnection() {
        return true;
    }

    @Override
    public boolean noBackslashEscapes() {
        return (this.serverStatus & 0x200) != 0;
    }

    @Override
    public void connectWithoutProxy() throws SQLException {
        if (!this.isClosed()) {
            this.close();
        }
        List<HostAddress> hostAddresses = this.urlParser.getHostAddresses();
        LinkedList<HostAddress> hosts = new LinkedList<HostAddress>(hostAddresses);
        if (this.urlParser.getHaMode().equals((Object)HaMode.LOADBALANCE)) {
            Collections.shuffle(hosts);
        }
        if (hosts.isEmpty()) {
            if (this.options.pipe != null || this.options.localSocket != null) {
                try {
                    this.createConnection(null, this.username);
                    return;
                }
                catch (SQLException exception) {
                    throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to named pipe '%s' : %s%s", this.options.pipe, exception.getMessage(), this.getTraces()), "08000", exception);
                }
            }
            throw ExceptionFactory.INSTANCE.create("No host is defined and pipe option is not set. Check if connection string respect format (jdbc:(mysql|mariadb):[replication:|loadbalance:|sequential:|aurora:]//<hostDescription>[,<hostDescription>...]/[database][?<key1>=<value1>[&<key2>=<value2>]])", "08000");
        }
        while (!hosts.isEmpty()) {
            this.currentHost = hosts.poll();
            try {
                this.createConnection(this.currentHost, this.username);
                return;
            }
            catch (SQLException e) {
                if (!hosts.isEmpty()) continue;
                if (e.getSQLState() != null) {
                    throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s : %s%s", HostAddress.toString(hostAddresses), e.getMessage(), this.getTraces()), e.getSQLState(), e.getErrorCode(), e);
                }
                throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s. %s%s", this.currentHost, e.getMessage(), this.getTraces()), "08000", e);
            }
        }
    }

    @Override
    public boolean shouldReconnectWithoutProxy() {
        return (this.serverStatus & 1) == 0 && this.hostFailed && this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.currentHost;
    }

    @Override
    public void setHostAddress(HostAddress host) {
        this.currentHost = host;
        this.readOnly = "replica".equals(this.currentHost.type);
    }

    @Override
    public String getHost() {
        return this.currentHost == null ? null : this.currentHost.host;
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public int getPort() {
        return this.currentHost == null ? 3306 : this.currentHost.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    private void parseVersion(String serverVersion) {
        int length = serverVersion.length();
        int type = 0;
        int val = 0;
        for (int offset = 0; offset < length; ++offset) {
            char car = serverVersion.charAt(offset);
            if (car < '0' || car > '9') {
                switch (type) {
                    case 0: {
                        this.majorVersion = val;
                        break;
                    }
                    case 1: {
                        this.minorVersion = val;
                        break;
                    }
                    case 2: {
                        this.patchVersion = val;
                        return;
                    }
                }
                ++type;
                val = 0;
                continue;
            }
            val = val * 10 + car - 48;
        }
        if (type == 2) {
            this.patchVersion = val;
        }
    }

    @Override
    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    @Override
    public int getPatchServerVersion() {
        return this.patchVersion;
    }

    @Override
    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        return this.patchVersion >= patch;
    }

    @Override
    public boolean getPinGlobalTxToPhysicalConnection() {
        return this.options.pinGlobalTxToPhysicalConnection;
    }

    @Override
    public boolean hasWarnings() {
        this.lock.lock();
        try {
            boolean bl = this.hasWarnings;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.lock.lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getServerThreadId() {
        return this.serverThreadId;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setHasWarnings(boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
    }

    @Override
    public Results getActiveStreamingResult() {
        return this.activeStreamingResult;
    }

    @Override
    public void setActiveStreamingResult(Results activeStreamingResult) {
        this.activeStreamingResult = activeStreamingResult;
    }

    @Override
    public void removeActiveStreamingResult() {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.removeFetchSize();
            this.activeStreamingResult = null;
        }
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public boolean hasMoreResults() {
        return (this.serverStatus & 8) != 0;
    }

    @Override
    public ServerPrepareStatementCache prepareStatementCache() {
        return this.serverPrepareStatementCache;
    }

    @Override
    public abstract void executeQuery(String var1) throws SQLException;

    @Override
    public void changeSocketTcpNoDelay(boolean setTcpNoDelay) {
        try {
            this.socket.setTcpNoDelay(setTcpNoDelay);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void changeSocketSoTimeout(int setSoTimeout) throws SocketException {
        this.socketTimeout = setSoTimeout;
        this.socket.setSoTimeout(this.socketTimeout);
    }

    @Override
    public boolean isServerMariaDb() {
        return this.serverMariaDb;
    }

    @Override
    public PacketInputStream getReader() {
        return this.reader;
    }

    @Override
    public boolean isEofDeprecated() {
        return this.eofDeprecated;
    }

    @Override
    public boolean sessionStateAware() {
        return (this.serverCapabilities & 0x800000L) != 0L;
    }

    @Override
    public String getTraces() {
        if (this.options.enablePacketDebug) {
            return this.traceCache.printStack();
        }
        return "";
    }
}

