/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ReadInitialHandShakePacket;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.pid.PidFactory;

public class SendHandshakeResponsePacket {
    private static final Supplier<String> pidRequest = PidFactory.getInstance();
    private static final byte[] _CLIENT_NAME = "_client_name".getBytes();
    private static final byte[] _CLIENT_VERSION = "_client_version".getBytes();
    private static final byte[] _SERVER_HOST = "_server_host".getBytes();
    private static final byte[] _OS = "_os".getBytes();
    private static final byte[] _PID = "_pid".getBytes();
    private static final byte[] _THREAD = "_thread".getBytes();
    private static final byte[] _JAVA_VENDOR = "_java_vendor".getBytes();
    private static final byte[] _JAVA_VERSION = "_java_version".getBytes();

    public static void send(PacketOutputStream pos, String username, String password, HostAddress currentHost, String database, long clientCapabilities, long serverCapabilities, byte serverLanguage, byte packetSeq, Options options, ReadInitialHandShakePacket greetingPacket) throws IOException {
        byte[] authData;
        pos.startPacket(packetSeq);
        switch (greetingPacket.getPluginName()) {
            case "": 
            case "mysql_native_password": {
                pos.permitTrace(false);
                try {
                    authData = Utils.encryptPassword(password, greetingPacket.getSeed(), options.passwordCharacterEncoding);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Unknown algorithm SHA-1. Cannot encrypt password", e);
                }
            }
            case "mysql_clear_password": {
                pos.permitTrace(false);
                if (options.passwordCharacterEncoding != null && !options.passwordCharacterEncoding.isEmpty()) {
                    authData = password.getBytes(options.passwordCharacterEncoding);
                    break;
                }
                authData = password.getBytes();
                break;
            }
            default: {
                authData = new byte[]{};
            }
        }
        pos.writeInt((int)clientCapabilities);
        pos.writeInt(0x40000000);
        pos.write(serverLanguage);
        pos.writeBytes((byte)0, 19);
        pos.writeInt((int)(clientCapabilities >> 32));
        if (username == null || username.isEmpty()) {
            pos.write(System.getProperty("user.name").getBytes());
        } else {
            pos.write(username.getBytes());
        }
        pos.write(0);
        if ((serverCapabilities & 0x200000L) != 0L) {
            pos.writeFieldLength(authData.length);
            pos.write(authData);
        } else if ((serverCapabilities & 0x8000L) != 0L) {
            pos.write((byte)authData.length);
            pos.write(authData);
        } else {
            pos.write(authData);
            pos.write(0);
        }
        if ((serverCapabilities & 8L) != 0L) {
            pos.write(database);
            pos.write(0);
        }
        if ((serverCapabilities & 0x80000L) != 0L) {
            pos.write(greetingPacket.getPluginName());
            pos.write(0);
        }
        if ((serverCapabilities & 0x100000L) != 0L) {
            SendHandshakeResponsePacket.writeConnectAttributes(pos, options.connectionAttributes, currentHost);
        }
        pos.flush();
        pos.permitTrace(true);
    }

    private static void writeConnectAttributes(PacketOutputStream pos, String connectionAttributes, HostAddress currentHost) throws IOException {
        Buffer buffer = new Buffer(new byte[200]);
        buffer.writeStringSmallLength(_CLIENT_NAME);
        buffer.writeStringLength("MariaDB Connector/J");
        buffer.writeStringSmallLength(_CLIENT_VERSION);
        buffer.writeStringLength("2.4.1");
        buffer.writeStringSmallLength(_SERVER_HOST);
        buffer.writeStringLength(currentHost != null ? currentHost.host : "");
        buffer.writeStringSmallLength(_OS);
        buffer.writeStringLength(System.getProperty("os.name"));
        String pid = pidRequest.get();
        if (pid != null) {
            buffer.writeStringSmallLength(_PID);
            buffer.writeStringLength(pid);
        }
        buffer.writeStringSmallLength(_THREAD);
        buffer.writeStringLength(Long.toString(Thread.currentThread().getId()));
        buffer.writeStringLength(_JAVA_VENDOR);
        buffer.writeStringLength(System.getProperty("java.vendor"));
        buffer.writeStringSmallLength(_JAVA_VERSION);
        buffer.writeStringLength(System.getProperty("java.version"));
        if (connectionAttributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(connectionAttributes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int separator = token.indexOf(":");
                if (separator != -1) {
                    buffer.writeStringLength(token.substring(0, separator));
                    buffer.writeStringLength(token.substring(separator + 1));
                    continue;
                }
                buffer.writeStringLength(token);
                buffer.writeStringLength("");
            }
        }
        pos.writeFieldLength(buffer.position);
        pos.write(buffer.buf, 0, buffer.position);
    }
}

