/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;

public class ComQuery {
    public static void sendSubCmd(PacketOutputStream writer, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters) throws IOException {
        writer.write(3);
        if (clientPrepareResult.isRewriteType()) {
            writer.write(clientPrepareResult.getQueryParts().get(0));
            writer.write(clientPrepareResult.getQueryParts().get(1));
            for (int i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                parameters[i].writeTo(writer);
                writer.write(clientPrepareResult.getQueryParts().get(i + 2));
            }
            writer.write(clientPrepareResult.getQueryParts().get(clientPrepareResult.getParamCount() + 2));
        } else {
            writer.write(clientPrepareResult.getQueryParts().get(0));
            for (int i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                parameters[i].writeTo(writer);
                writer.write(clientPrepareResult.getQueryParts().get(i + 1));
            }
        }
    }

    public static int sendRewriteCmd(PacketOutputStream pos, List<byte[]> queryParts, ParameterHolder[] parameters, int currentIndex, int paramCount, List<ParameterHolder[]> parameterList, boolean rewriteValues) throws IOException {
        pos.startPacket(0);
        pos.write(3);
        byte[] firstPart = queryParts.get(0);
        byte[] secondPart = queryParts.get(1);
        if (!rewriteValues) {
            int i;
            pos.write(firstPart, 0, firstPart.length);
            pos.write(secondPart, 0, secondPart.length);
            int staticLength = 1;
            for (i = 0; i < queryParts.size(); ++i) {
                staticLength += queryParts.get(i).length;
            }
            for (i = 0; i < paramCount; ++i) {
                parameters[i].writeTo(pos);
                pos.write(queryParts.get(i + 2));
            }
            pos.write(queryParts.get(paramCount + 2));
            while (currentIndex < parameterList.size()) {
                parameters = parameterList.get(currentIndex);
                int parameterLength = 0;
                boolean knownParameterSize = true;
                for (ParameterHolder parameter : parameters) {
                    long paramSize = parameter.getApproximateTextProtocolLength();
                    if (paramSize == -1L) {
                        knownParameterSize = false;
                        break;
                    }
                    parameterLength = (int)((long)parameterLength + paramSize);
                }
                if (knownParameterSize) {
                    if (pos.checkRemainingSize(staticLength + parameterLength)) {
                        pos.write(59);
                        pos.write(firstPart, 0, firstPart.length);
                        pos.write(secondPart, 0, secondPart.length);
                        for (int i2 = 0; i2 < paramCount; ++i2) {
                            parameters[i2].writeTo(pos);
                            pos.write(queryParts.get(i2 + 2));
                        }
                        pos.write(queryParts.get(paramCount + 2));
                        ++currentIndex;
                        continue;
                    }
                } else {
                    pos.write(59);
                    pos.write(firstPart, 0, firstPart.length);
                    pos.write(secondPart, 0, secondPart.length);
                    for (int i3 = 0; i3 < paramCount; ++i3) {
                        parameters[i3].writeTo(pos);
                        pos.write(queryParts.get(i3 + 2));
                    }
                    pos.write(queryParts.get(paramCount + 2));
                    ++currentIndex;
                }
                break;
            }
        } else {
            pos.write(firstPart, 0, firstPart.length);
            pos.write(secondPart, 0, secondPart.length);
            int lastPartLength = queryParts.get(paramCount + 2).length;
            int intermediatePartLength = queryParts.get(1).length;
            for (int i = 0; i < paramCount; ++i) {
                parameters[i].writeTo(pos);
                pos.write(queryParts.get(i + 2));
                intermediatePartLength += queryParts.get(i + 2).length;
            }
            while (currentIndex < parameterList.size()) {
                parameters = parameterList.get(currentIndex);
                int parameterLength = 0;
                boolean knownParameterSize = true;
                for (ParameterHolder parameter : parameters) {
                    long paramSize = parameter.getApproximateTextProtocolLength();
                    if (paramSize == -1L) {
                        knownParameterSize = false;
                        break;
                    }
                    parameterLength = (int)((long)parameterLength + paramSize);
                }
                if (knownParameterSize) {
                    if (!pos.checkRemainingSize(1 + parameterLength + intermediatePartLength + lastPartLength)) break;
                    pos.write(44);
                    pos.write(secondPart, 0, secondPart.length);
                    for (int i = 0; i < paramCount; ++i) {
                        parameters[i].writeTo(pos);
                        byte[] addPart = queryParts.get(i + 2);
                        pos.write(addPart, 0, addPart.length);
                    }
                    ++currentIndex;
                    continue;
                }
                pos.write(44);
                pos.write(secondPart, 0, secondPart.length);
                for (int i = 0; i < paramCount; ++i) {
                    parameters[i].writeTo(pos);
                    pos.write(queryParts.get(i + 2));
                }
                ++currentIndex;
                break;
            }
            pos.write(queryParts.get(paramCount + 2));
        }
        pos.flush();
        return currentIndex;
    }

    public static int sendMultiple(PacketOutputStream writer, String firstQuery, List<String> queries, int currentIndex) throws IOException {
        byte[] sqlByte;
        writer.startPacket(0);
        writer.write(3);
        writer.write(firstQuery.getBytes("UTF-8"));
        while (currentIndex < queries.size() && writer.checkRemainingSize((sqlByte = queries.get(currentIndex).getBytes("UTF-8")).length + 1)) {
            writer.write(59);
            writer.write(sqlByte);
            ++currentIndex;
        }
        writer.flush();
        return currentIndex;
    }

    public static void sendDirect(PacketOutputStream pos, byte[] sqlBytes) throws IOException, SQLException {
        pos.startPacket(0);
        pos.write(3);
        pos.write(sqlBytes);
        pos.flush();
    }
}

