/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import org.mariadb.jdbc.internal.protocol.AuroraProtocol;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.PidFactory;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public class SendHandshakeResponsePacket {
    public static void send(PacketOutputStream pos, String username, String password, String database, long clientCapabilities, long serverCapabilities, byte serverLanguage, byte[] seed, byte packetSeq, String plugin, Options options, HaMode haMode) throws IOException {
        byte[] authData;
        pos.startPacket(packetSeq);
        switch (plugin) {
            case "": 
            case "mysql_native_password": {
                pos.permitTrace(false);
                try {
                    authData = Utils.encryptPassword(password, seed, options.passwordCharacterEncoding);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Could not use SHA-1, failing", e);
                }
            }
            case "mysql_clear_password": {
                pos.permitTrace(false);
                if (options.passwordCharacterEncoding != null && !options.passwordCharacterEncoding.isEmpty()) {
                    authData = password.getBytes(options.passwordCharacterEncoding);
                    break;
                }
                authData = password.getBytes();
                break;
            }
            default: {
                authData = new byte[]{};
            }
        }
        pos.writeInt((int)clientCapabilities);
        pos.writeInt(0x40000000);
        pos.write(serverLanguage);
        pos.writeBytes((byte)0, 19);
        pos.writeInt((int)(clientCapabilities >> 32));
        if (username == null || "".equals(username)) {
            username = System.getProperty("user.name");
        }
        pos.write(username.getBytes());
        pos.write(0);
        if ((serverCapabilities & 0x200000L) != 0L) {
            pos.writeFieldLength(authData.length);
            pos.write(authData);
        } else if ((serverCapabilities & 0x8000L) != 0L) {
            pos.write((byte)authData.length);
            pos.write(authData);
        } else {
            pos.write(authData);
            pos.write(0);
        }
        if ((serverCapabilities & 8L) != 0L) {
            pos.write(database);
            pos.write(0);
        }
        if ((serverCapabilities & 0x80000L) != 0L) {
            pos.write(plugin);
            pos.write(0);
        }
        if ((serverCapabilities & 0x100000L) != 0L) {
            SendHandshakeResponsePacket.writeConnectAttributes(pos, options.connectionAttributes);
        }
        if ((serverCapabilities & 0x400000000L) != 0L) {
            SendHandshakeResponsePacket.writeAdditionalQueries(pos, serverCapabilities, options, haMode, database);
        }
        pos.flush();
        pos.permitTrace(true);
    }

    private static void writeAdditionalQueries(PacketOutputStream pos, long serverCapabilities, Options options, HaMode haMode, String database) throws IOException {
        Buffer buffer = new Buffer(new byte[200]);
        StringBuilder sessionOption = new StringBuilder("set autocommit=1");
        if ((serverCapabilities & 0x800000L) != 0L) {
            sessionOption.append(", session_track_schema=1");
            if (options.rewriteBatchedStatements) {
                sessionOption.append(", session_track_system_variables='auto_increment_increment' ");
            }
        }
        if (options.jdbcCompliantTruncation) {
            sessionOption.append(", sql_mode = concat(@@sql_mode,',STRICT_TRANS_TABLES')");
        }
        if (options.sessionVariables != null) {
            sessionOption.append("," + options.sessionVariables);
        }
        buffer.writeBytes((byte)3, sessionOption.toString().getBytes(StandardCharsets.UTF_8));
        buffer.writeBytes((byte)3, AbstractConnectProtocol.SESSION_QUERY);
        if (haMode == HaMode.AURORA) {
            buffer.writeBytes((byte)3, AuroraProtocol.IS_MASTER_QUERY);
        }
        if (options.createDatabaseIfNotExist) {
            String quotedDb = MariaDbConnection.quoteIdentifier(database);
            buffer.writeBytes((byte)3, ("CREATE DATABASE IF NOT EXISTS " + quotedDb).getBytes(StandardCharsets.UTF_8));
            buffer.writeBytes((byte)3, ("USE " + quotedDb).getBytes(StandardCharsets.UTF_8));
        }
        pos.write(buffer.position + 1);
        pos.write(-2);
        pos.write(buffer.buf, 0, buffer.position);
    }

    private static void writeConnectAttributes(PacketOutputStream pos, String connectionAttributes) throws IOException {
        Buffer buffer = new Buffer(new byte[200]);
        buffer.writeStringLength("_client_name");
        buffer.writeStringLength("MariaDB connector/J");
        buffer.writeStringLength("_client_version");
        buffer.writeStringLength("2.0.0-RC");
        buffer.writeStringLength("_os");
        buffer.writeStringLength(System.getProperty("os.name"));
        String pid = PidFactory.getInstance().getPid();
        if (pid != null) {
            buffer.writeStringLength("_pid");
            buffer.writeStringLength(pid);
        }
        buffer.writeStringLength("_thread");
        buffer.writeStringLength(Long.toString(Thread.currentThread().getId()));
        buffer.writeStringLength("_java_vendor");
        buffer.writeStringLength(System.getProperty("java.vendor"));
        buffer.writeStringLength("_java_version");
        buffer.writeStringLength(System.getProperty("java.version"));
        if (connectionAttributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(connectionAttributes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int separator = token.indexOf(":");
                if (separator != -1) {
                    buffer.writeStringLength(token.substring(0, separator));
                    buffer.writeStringLength(token.substring(separator + 1));
                    continue;
                }
                buffer.writeStringLength(token);
                buffer.writeStringLength("");
            }
        }
        pos.writeFieldLength(buffer.position);
        pos.write(buffer.buf, 0, buffer.position);
    }
}

