/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset.rowprotocol;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import org.mariadb.jdbc.internal.util.Options;

public abstract class RowProtocol {
    public static final int BIT_LAST_FIELD_NOT_NULL = 0;
    public static final int BIT_LAST_FIELD_NULL = 1;
    public static final int BIT_LAST_ZERO_DATE = 2;
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    public static final Pattern isIntegerRegex = Pattern.compile("^-?\\d+\\.[0-9]+$");
    public int lastValueNull;
    protected static final int NULL_LENGTH = -1;
    protected final int maxFieldSize;
    public byte[] buf;
    public int pos;
    public int length;
    protected int index;
    protected final Options options;

    public RowProtocol(int maxFieldSize, Options options) {
        this.maxFieldSize = maxFieldSize;
        this.options = options;
    }

    public void resetRow(byte[] buf) {
        this.buf = buf;
        this.index = -1;
    }

    public abstract void setPosition(int var1);

    public int getLengthMaxFieldSize() {
        return this.maxFieldSize != 0 && this.maxFieldSize < this.length ? this.maxFieldSize : this.length;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public abstract String getInternalString(ColumnInformation var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract int getInternalInt(ColumnInformation var1) throws SQLException;

    public abstract long getInternalLong(ColumnInformation var1) throws SQLException;

    public abstract float getInternalFloat(ColumnInformation var1) throws SQLException;

    public abstract double getInternalDouble(ColumnInformation var1) throws SQLException;

    public abstract BigDecimal getInternalBigDecimal(ColumnInformation var1) throws SQLException;

    public abstract Date getInternalDate(ColumnInformation var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Time getInternalTime(ColumnInformation var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Timestamp getInternalTimestamp(ColumnInformation var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Object getInternalObject(ColumnInformation var1, int var2, TimeZone var3) throws SQLException;

    public abstract boolean getInternalBoolean(ColumnInformation var1) throws SQLException;

    public abstract byte getInternalByte(ColumnInformation var1) throws SQLException;

    public abstract short getInternalShort(ColumnInformation var1) throws SQLException;

    public abstract String getInternalTimeString(ColumnInformation var1);

    public abstract BigInteger getInternalBigInteger(ColumnInformation var1) throws SQLException;

    public abstract boolean isBinaryEncoded();

    public boolean lastValueWasNull() {
        return (this.lastValueNull & 1) != 0;
    }

    protected String zeroFillingIfNeeded(String value, ColumnInformation columnInformation) {
        if (columnInformation.isZeroFill()) {
            StringBuilder zeroAppendStr = new StringBuilder();
            long zeroToAdd = columnInformation.getDisplaySize() - value.length();
            while (zeroToAdd-- > 0L) {
                zeroAppendStr.append("0");
            }
            return zeroAppendStr.append(value).toString();
        }
        return value;
    }

    protected int getInternalTinyInt(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = this.buf[this.pos];
        if (!columnInfo.isSigned()) {
            value = this.buf[this.pos] & 0xFF;
        }
        return value;
    }

    protected long parseBit() {
        if (this.length == 1) {
            return this.buf[this.pos];
        }
        long val = 0L;
        int ind = 0;
        do {
            val += (long)(this.buf[this.pos + ind] & 0xFF) << 8 * (this.length - ++ind);
        } while (ind < this.length);
        return val;
    }

    protected int getInternalSmallInt(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8);
        if (!columnInfo.isSigned()) {
            return value & 0xFFFF;
        }
        return (short)value;
    }

    protected long getInternalMediumInt(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        long value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
        if (!columnInfo.isSigned()) {
            value &= 0xFFFFFFFFL;
        }
        return value;
    }

    protected void rangeCheck(Object className, long minValue, long maxValue, BigDecimal value, ColumnInformation columnInfo) throws SQLException {
        if (value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    protected void rangeCheck(Object className, long minValue, long maxValue, long value, ColumnInformation columnInfo) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    protected int extractNanos(String timestring) throws SQLException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new SQLException("cannot parse sub-second part in timestamp string '" + timestring + "'");
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    public boolean wasNull() {
        return (this.lastValueNull & 1) != 0 || (this.lastValueNull & 2) != 0;
    }
}

