/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset.rowprotocol;

import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;

public class BinaryRowProtocol
extends RowProtocol {
    private final ColumnInformation[] columnInformation;
    private final int columnInformationLength;

    public BinaryRowProtocol(ColumnInformation[] columnInformation, int columnInformationLength, int maxFieldSize) {
        super(maxFieldSize);
        this.columnInformation = columnInformation;
        this.columnInformationLength = columnInformationLength;
    }

    @Override
    public boolean setPosition(int newIndex) {
        if (this.index != newIndex) {
            if (this.index == -1 || this.index > newIndex) {
                this.index = 0;
                this.pos = 1 + (this.columnInformationLength + 9) / 8;
            } else {
                ++this.index;
                if (this.length != -1) {
                    this.pos += this.length;
                }
            }
            if ((this.buf[1 + (newIndex + 2) / 8] & 1 << (newIndex + 2) % 8) != 0) {
                this.length = -1;
                this.index = newIndex;
                return true;
            }
            while (this.index <= newIndex) {
                if ((this.buf[1 + (this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                    int type;
                    if (this.index != newIndex) {
                        block0 : switch (this.columnInformation[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                this.pos += 8;
                                break;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                this.pos += 4;
                                break;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                this.pos += 2;
                                break;
                            }
                            case TINYINT: {
                                ++this.pos;
                                break;
                            }
                            default: {
                                type = this.buf[this.pos++] & 0xFF;
                                switch (type) {
                                    case 251: {
                                        break block0;
                                    }
                                    case 252: {
                                        this.pos += 2 + (0xFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8));
                                        break block0;
                                    }
                                    case 253: {
                                        this.pos += 3 + (0xFFFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16));
                                        break block0;
                                    }
                                    case 254: {
                                        this.pos = (int)((long)this.pos + (8L + ((long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56))));
                                        break block0;
                                    }
                                }
                                this.pos += type;
                                break;
                            }
                        }
                    } else {
                        block12 : switch (this.columnInformation[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                this.length = 8;
                                break;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                this.length = 4;
                                break;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                this.length = 2;
                                break;
                            }
                            case TINYINT: {
                                this.length = 1;
                                break;
                            }
                            default: {
                                type = this.buf[this.pos++] & 0xFF;
                                switch (type) {
                                    case 251: {
                                        this.length = -1;
                                        return true;
                                    }
                                    case 252: {
                                        this.length = 0xFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8);
                                        break block12;
                                    }
                                    case 253: {
                                        this.length = 0xFFFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16);
                                        break block12;
                                    }
                                    case 254: {
                                        this.length = (int)((long)(this.buf[this.pos++] & 0xFF) + ((long)(this.buf[this.pos++] & 0xFF) << 8) + ((long)(this.buf[this.pos++] & 0xFF) << 16) + ((long)(this.buf[this.pos++] & 0xFF) << 24) + ((long)(this.buf[this.pos++] & 0xFF) << 32) + ((long)(this.buf[this.pos++] & 0xFF) << 40) + ((long)(this.buf[this.pos++] & 0xFF) << 48) + ((long)(this.buf[this.pos++] & 0xFF) << 56));
                                        break block12;
                                    }
                                }
                                this.length = type;
                            }
                        }
                        return false;
                    }
                }
                ++this.index;
            }
        }
        return this.length == -1;
    }
}

