/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.mariadb.jdbc.AbstractPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.Results;
import org.mariadb.jdbc.internal.queryresults.ResultsRewrite;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbClientPreparedStatement
extends AbstractPrepareStatement
implements Cloneable {
    private static Logger logger = LoggerFactory.getLogger(MariaDbClientPreparedStatement.class);
    private String sqlQuery;
    private ClientPrepareResult prepareResult;
    private ParameterHolder[] parameters;
    private List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MariaDbClientPreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType) throws SQLException {
        super(connection, resultSetScrollType);
        String key;
        this.sqlQuery = sql;
        this.useFractionalSeconds = this.options.useFractionalSeconds;
        if (this.options.cachePrepStmts) {
            key = this.protocol.getDatabase() + "-" + this.sqlQuery;
            this.prepareResult = (ClientPrepareResult)connection.getClientPrepareStatementCache().get(key);
        }
        if (this.prepareResult == null) {
            this.prepareResult = this.options.rewriteBatchedStatements ? ClientPrepareResult.rewritableParts(this.sqlQuery, connection.noBackslashEscapes) : ClientPrepareResult.parameterParts(this.sqlQuery, connection.noBackslashEscapes);
            if (this.options.cachePrepStmts && sql.length() < 1024) {
                key = this.protocol.getDatabase() + "-" + this.sqlQuery;
                connection.getClientPrepareStatementCache().put(key, this.prepareResult);
            }
        }
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public MariaDbClientPreparedStatement clone() throws CloneNotSupportedException {
        MariaDbClientPreparedStatement clone = (MariaDbClientPreparedStatement)super.clone();
        clone.sqlQuery = this.sqlQuery;
        clone.prepareResult = this.prepareResult;
        clone.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.executeInternal()) {
            return this.results.getResultSet();
        }
        return MariaSelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.executeInternal()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal() throws SQLException {
        this.executing = true;
        QueryException exception = null;
        for (int i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            logger.error("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            Results internalResult = new Results(this, this.getFetchSize(), false, 1, false, this.resultSetScrollType);
            this.protocol.executeQuery(this.protocol.isMasterConnection(), internalResult, this.prepareResult, this.parameters);
            internalResult.commandEnd();
            this.results = internalResult;
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        ParameterHolder[] holder = new ParameterHolder[this.prepareResult.getParamCount()];
        for (int i = 0; i < holder.length; ++i) {
            holder[i] = this.parameters[i];
            if (holder[i] != null) continue;
            logger.error("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.parameterList.add(holder);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new int[0];
        }
        Results internalResults = this.options.rewriteBatchedStatements && this.prepareResult.isQueryMultiValuesRewritable() ? new ResultsRewrite(this, 0, true, size, false, this.resultSetScrollType) : new Results(this, 0, true, size, false, this.resultSetScrollType);
        this.lock.lock();
        try {
            QueryException exception = null;
            this.executeQueryProlog();
            try {
                this.executeInternalBatch(internalResults, size);
            }
            catch (QueryException e) {
                exception = e;
            }
            finally {
                if (this.options.rewriteBatchedStatements && this.prepareResult.isQueryMultiValuesRewritable()) {
                    ((ResultsRewrite)internalResults).setAutoIncrement(this.connection.getAutoIncrementIncrement());
                }
                internalResults.commandEnd();
                this.results = internalResults;
                this.executing = false;
                this.executeQueryEpilog(exception);
            }
        }
        catch (SQLException sqle) {
            int[] ret;
            if (internalResults.getCmdInformation() == null) {
                ret = new int[size];
                Arrays.fill(ret, -3);
            } else {
                ret = internalResults.getCmdInformation().getUpdateCounts();
            }
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), ret, (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
        return this.results.getCmdInformation().getUpdateCounts();
    }

    private void executeInternalBatch(Results results, int size) throws QueryException {
        if (this.options.rewriteBatchedStatements) {
            if (this.prepareResult.isQueryMultiValuesRewritable()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), results, this.prepareResult, this.parameterList, true);
                return;
            }
            if (this.prepareResult.isQueryMultipleRewritable()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), results, this.prepareResult, this.parameterList, false);
                return;
            }
        }
        if (this.options.useBatchMultiSend) {
            this.protocol.executeBatchMulti(this.protocol.isMasterConnection(), results, this.prepareResult, this.parameterList);
        } else {
            QueryException exception = null;
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), results, this.prepareResult, this.parameterList.get(batchQueriesCount));
                    continue;
                }
                catch (QueryException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.setParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.prepareResult.getParamCount() + 1) {
            logger.error("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.setParametersData();
        }
        return this.parameterMetaData;
    }

    private void setParametersData() throws SQLException {
        MariaDbServerPreparedStatement ssps = new MariaDbServerPreparedStatement(this.connection, this.sqlQuery, 1004, true);
        this.resultSetMetaData = ssps.getMetaData();
        this.parameterMetaData = ssps.getParameterMetaData();
        ssps.close();
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    protected int getParameterCount() {
        return this.prepareResult.getParamCount();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sqlQuery + "'");
        sb.append(", parameters : [");
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterHolder holder = this.parameters[i];
            if (holder == null) {
                sb.append("null");
            } else {
                sb.append(holder.toString());
            }
            if (i == this.parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    protected ClientPrepareResult getPrepareResult() {
        return this.prepareResult;
    }

    protected void initializeFallbackClient(MariaDbServerPreparedStatement serverPreparedStatement) throws SQLException {
        if (serverPreparedStatement.currentParameterHolder.size() == this.prepareResult.getParamCount()) {
            this.parameters = serverPreparedStatement.currentParameterHolder.values().toArray(new ParameterHolder[0]);
        } else {
            Iterator<ParameterHolder> paramsIterator = serverPreparedStatement.currentParameterHolder.values().iterator();
            for (int i = 0; i < this.prepareResult.getParamCount() && paramsIterator.hasNext(); ++i) {
                this.parameters[i] = paramsIterator.next();
            }
        }
        this.parameterList = serverPreparedStatement.queryParameters;
        this.resultSetMetaData = serverPreparedStatement.metadata;
        this.parameterMetaData = serverPreparedStatement.parameterMetaData;
        this.batchQueries = serverPreparedStatement.batchQueries;
        if (serverPreparedStatement.queryTimeout != 0) {
            this.setQueryTimeout(serverPreparedStatement.queryTimeout);
        }
        if (serverPreparedStatement.getFetchSize() != 0) {
            this.setFetchSize(serverPreparedStatement.getFetchSize());
        }
        if (serverPreparedStatement.maxRows != 0) {
            this.setMaxRows(serverPreparedStatement.maxRows);
        }
        if (serverPreparedStatement.isCloseOnCompletion()) {
            this.closeOnCompletion();
        }
    }
}

