/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class MultiFixedIntExecutionResult
implements MultiExecutionResult {
    private MariaDbStatement statement = null;
    private boolean moreResultAvailable;
    private int fetchSize;
    private boolean selectPossible;
    private boolean canHaveCallableResultset;
    public Deque<ExecutionResult> cachedExecutionResults;
    private MariaSelectResultSet resultSet = null;
    private long[] insertId;
    private int[] affectedRows;
    private int currentStat = 0;

    public MultiFixedIntExecutionResult(MariaDbStatement statement, int size, int fetchSize, boolean selectPossible) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = false;
        this.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
        this.affectedRows = new int[size];
        this.insertId = new long[size];
        Arrays.fill(this.affectedRows, -3);
        Arrays.fill(this.insertId, -3L);
    }

    @Override
    public void addResultSet(MariaSelectResultSet result, boolean moreResultAvailable) {
        this.resultSet = result;
        this.insertId[this.currentStat] = -2L;
        this.affectedRows[this.currentStat++] = -1;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public void addStats(long affectedRows, long insertId, boolean moreResultAvailable) {
        this.insertId[this.currentStat] = insertId;
        this.affectedRows[this.currentStat++] = (int)affectedRows;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public long[] getInsertIds() {
        return this.insertId;
    }

    @Override
    public int[] getAffectedRows() {
        return this.affectedRows;
    }

    @Override
    public boolean hasMoreThanOneAffectedRows() {
        return this.affectedRows.length > 0 && this.affectedRows[0] > 1;
    }

    @Override
    public int getFirstAffectedRows() {
        return this.affectedRows[0];
    }

    @Override
    public void addStatsError(boolean moreResultAvailable) {
        this.affectedRows[this.currentStat++] = -3;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public void fixStatsError(int sendCommand) {
        while (this.affectedRows.length < sendCommand) {
            this.affectedRows[this.currentStat++] = -3;
        }
    }

    @Override
    public int[] updateResultsForRewrite(int waitedSize, boolean hasException) {
        return null;
    }

    @Override
    public int[] updateResultsMultiple(int waitedSize, boolean hasException) {
        return null;
    }

    @Override
    public MariaSelectResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public MariaDbStatement getStatement() {
        return this.statement;
    }

    @Override
    public boolean hasMoreResultAvailable() {
        return this.moreResultAvailable;
    }

    protected void setMoreResultAvailable(boolean moreResultAvailable) {
        this.moreResultAvailable = moreResultAvailable;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
    }

    @Override
    public boolean isSelectPossible() {
        return this.selectPossible;
    }

    @Override
    public boolean isCanHaveCallableResultset() {
        return this.canHaveCallableResultset;
    }

    @Override
    public Deque<ExecutionResult> getCachedExecutionResults() {
        return this.cachedExecutionResults;
    }

    public void addResult(ExecutionResult executionResult) {
        this.cachedExecutionResults.add(executionResult);
    }

    @Override
    public boolean isSingleExecutionResult() {
        return false;
    }

    public int getCurrentStat() {
        return this.currentStat;
    }
}

