/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiFixedIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiVariableIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbClientPreparedStatement
extends AbstractMariaDbPrepareStatement
implements Cloneable {
    private static Logger logger = LoggerFactory.getLogger(MariaDbClientPreparedStatement.class);
    private String sqlQuery;
    private ClientPrepareResult prepareResult;
    private ParameterHolder[] parameters;
    private List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MariaDbClientPreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType) throws SQLException {
        super(connection, resultSetScrollType);
        String key;
        this.sqlQuery = sql;
        this.useFractionalSeconds = this.options.useFractionalSeconds;
        if (this.options.cachePrepStmts) {
            key = this.protocol.getDatabase() + "-" + this.sqlQuery;
            this.prepareResult = (ClientPrepareResult)connection.getClientPrepareStatementCache().get(key);
        }
        if (this.prepareResult == null) {
            this.prepareResult = this.options.rewriteBatchedStatements ? ClientPrepareResult.createRewritableParts(this.sqlQuery, connection.noBackslashEscapes) : ClientPrepareResult.createParameterParts(this.sqlQuery, connection.noBackslashEscapes);
            if (this.options.cachePrepStmts && sql.length() < 1024) {
                key = this.protocol.getDatabase() + "-" + this.sqlQuery;
                connection.getClientPrepareStatementCache().put(key, this.prepareResult);
            }
        }
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public MariaDbClientPreparedStatement clone() throws CloneNotSupportedException {
        MariaDbClientPreparedStatement clone = (MariaDbClientPreparedStatement)super.clone();
        clone.sqlQuery = this.sqlQuery;
        clone.prepareResult = this.prepareResult;
        clone.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.executeInternal()) {
            return this.executionResult.getResultSet();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.executeInternal()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal() throws SQLException {
        this.executing = true;
        QueryException exception = null;
        for (int i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            logger.error("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            ExecutionResult executionResultTmp = this.options.allowMultiQueries || this.options.rewriteBatchedStatements ? new MultiVariableIntExecutionResult(this, this.getFetchSize(), 0, true) : new SingleExecutionResult((MariaDbStatement)this, this.getFetchSize(), true, false, true);
            this.protocol.executeQuery(this.protocol.isMasterConnection(), executionResultTmp, this.prepareResult, this.parameters, this.resultSetScrollType);
            this.executionResult = executionResultTmp;
            boolean bl = this.executionResult.getResultSet() != null;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        ParameterHolder[] holder = new ParameterHolder[this.prepareResult.getParamCount()];
        for (int i = 0; i < holder.length; ++i) {
            holder[i] = this.parameters[i];
            if (holder[i] != null) continue;
            logger.error("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.parameterList.add(holder);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] affectedRows;
        block15: {
            this.checkClose();
            int size = this.parameterList.size();
            if (size == 0) {
                return new int[0];
            }
            affectedRows = null;
            MultiExecutionResult internalExecutionResult = this.options.allowMultiQueries || this.options.rewriteBatchedStatements ? new MultiVariableIntExecutionResult(this, size, 0, false) : new MultiFixedIntExecutionResult(this, size, 0, false);
            this.lock.lock();
            try {
                QueryException exception = null;
                this.executeQueryProlog();
                try {
                    affectedRows = this.executeInternalBatch(internalExecutionResult, size);
                    this.executionResult = internalExecutionResult;
                    this.executing = false;
                }
                catch (QueryException e) {
                    try {
                        internalExecutionResult.fixStatsError(size);
                        if (this.options.rewriteBatchedStatements) {
                            if (this.prepareResult.isQueryMultiValuesRewritable()) {
                                affectedRows = internalExecutionResult.updateResultsForRewrite(size, true);
                            } else if (this.prepareResult.isQueryMultipleRewritable()) {
                                affectedRows = internalExecutionResult.updateResultsMultiple(size, true);
                            }
                        } else {
                            affectedRows = internalExecutionResult.getAffectedRows();
                        }
                        exception = e;
                        this.executionResult = internalExecutionResult;
                        this.executing = false;
                    }
                    catch (Throwable throwable) {
                        this.executionResult = internalExecutionResult;
                        this.executing = false;
                        this.executeQueryEpilog(exception);
                        throw throwable;
                    }
                    this.executeQueryEpilog(exception);
                    break block15;
                }
                this.executeQueryEpilog(exception);
            }
            catch (SQLException sqle) {
                throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), affectedRows, (Throwable)sqle);
            }
            finally {
                this.lock.unlock();
                this.clearBatch();
            }
        }
        return affectedRows;
    }

    private int[] executeInternalBatch(MultiExecutionResult internalExecutionResult, int size) throws QueryException {
        if (this.options.rewriteBatchedStatements) {
            if (this.prepareResult.isQueryMultiValuesRewritable()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList, this.resultSetScrollType, true);
                return internalExecutionResult.updateResultsForRewrite(size, false);
            }
            if (this.prepareResult.isQueryMultipleRewritable()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList, this.resultSetScrollType, false);
                return internalExecutionResult.updateResultsMultiple(size, false);
            }
        }
        if (this.options.useBatchMultiSend) {
            this.protocol.executeBatchMulti(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList, this.resultSetScrollType);
        } else {
            QueryException exception = null;
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList.get(batchQueriesCount), this.resultSetScrollType);
                    continue;
                }
                catch (QueryException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        return internalExecutionResult.getAffectedRows();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.executionResult != null && this.executionResult.getResultSet() == null) {
            int autoIncrementIncrement = this.connection.getAutoIncrementIncrement();
            if (this.executionResult.hasMoreThanOneAffectedRows()) {
                long[] data;
                if (this.executionResult.isSingleExecutionResult()) {
                    int updateCount = this.executionResult.getFirstAffectedRows();
                    data = new long[updateCount];
                    for (int i = 0; i < updateCount; ++i) {
                        data[i] = ((SingleExecutionResult)this.executionResult).getInsertId() + (long)(i * autoIncrementIncrement);
                    }
                } else if (this.options.rewriteBatchedStatements && this.prepareResult.isQueryMultiValuesRewritable()) {
                    MultiVariableIntExecutionResult multiExecution = (MultiVariableIntExecutionResult)this.executionResult;
                    data = multiExecution.getInsertIdsForRewrite(autoIncrementIncrement);
                } else {
                    MultiExecutionResult multiExecution = (MultiExecutionResult)this.executionResult;
                    int size = 0;
                    int affectedRowsLength = multiExecution.getAffectedRows().length;
                    for (int i = 0; i < affectedRowsLength; ++i) {
                        int affectedRows = multiExecution.getAffectedRows()[i];
                        if (affectedRows >= 0) {
                            size += multiExecution.getAffectedRows()[i];
                            continue;
                        }
                        ++size;
                    }
                    data = new long[size < 0 ? 0 : size];
                    int insertIdCounter = 0;
                    for (int affectedRowsCounter = 0; affectedRowsCounter < affectedRowsLength; ++affectedRowsCounter) {
                        int affectedRows = multiExecution.getAffectedRows()[affectedRowsCounter];
                        if (affectedRows > 0) {
                            for (int i = 0; i < affectedRows; ++i) {
                                data[insertIdCounter++] = multiExecution.getInsertIds()[affectedRowsCounter] + (long)(i * autoIncrementIncrement);
                            }
                            continue;
                        }
                        data[insertIdCounter++] = multiExecution.getInsertIds()[affectedRowsCounter];
                    }
                }
                return MariaSelectResultSet.createGeneratedData(data, this.connection.getProtocol(), true);
            }
            return MariaSelectResultSet.createGeneratedData(this.executionResult.getInsertIds(), this.connection.getProtocol(), true);
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.setParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.prepareResult.getParamCount() + 1) {
            logger.error("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.setParametersData();
        }
        return this.parameterMetaData;
    }

    private void setParametersData() throws SQLException {
        MariaDbServerPreparedStatement ssps = new MariaDbServerPreparedStatement(this.connection, this.sqlQuery, 1004, true);
        this.resultSetMetaData = ssps.getMetaData();
        this.parameterMetaData = ssps.getParameterMetaData();
        ssps.close();
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    protected int getParameterCount() {
        return this.prepareResult.getParamCount();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sqlQuery + "'");
        sb.append(", parameters : [");
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterHolder holder = this.parameters[i];
            if (holder == null) {
                sb.append("null");
            } else {
                sb.append(holder.toString());
            }
            if (i == this.parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    protected ClientPrepareResult getPrepareResult() {
        return this.prepareResult;
    }

    protected void initializeFallbackClient(MariaDbServerPreparedStatement serverPreparedStatement) throws SQLException {
        if (serverPreparedStatement.currentParameterHolder.size() == this.prepareResult.getParamCount()) {
            this.parameters = serverPreparedStatement.currentParameterHolder.values().toArray(new ParameterHolder[0]);
        } else {
            Iterator<ParameterHolder> paramsIterator = serverPreparedStatement.currentParameterHolder.values().iterator();
            for (int i = 0; i < this.prepareResult.getParamCount() && paramsIterator.hasNext(); ++i) {
                this.parameters[i] = paramsIterator.next();
            }
        }
        this.parameterList = serverPreparedStatement.queryParameters;
        this.resultSetMetaData = serverPreparedStatement.metadata;
        this.parameterMetaData = serverPreparedStatement.parameterMetaData;
        this.batchQueries = serverPreparedStatement.batchQueries;
        if (serverPreparedStatement.queryTimeout != 0) {
            this.setQueryTimeout(serverPreparedStatement.queryTimeout);
        }
        if (serverPreparedStatement.getFetchSize() != 0) {
            this.setFetchSize(serverPreparedStatement.getFetchSize());
        }
        if (serverPreparedStatement.maxRows != 0) {
            this.setMaxRows(serverPreparedStatement.maxRows);
        }
        if (serverPreparedStatement.isCloseOnCompletion()) {
            this.closeOnCompletion();
        }
    }
}

