/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.mariadb.jdbc.AbstractCallableProcedureStatement;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.CallableParameterMetaData;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.packet.dao.parameters.NullParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.dao.CloneableCallableStatement;

public class MariaDbProcedureStatement
extends AbstractCallableProcedureStatement
implements CloneableCallableStatement {
    private MariaSelectResultSet outputResultSet = null;

    public MariaDbProcedureStatement(String query, MariaDbConnection connection, String procedureName, String database, String arguments) throws SQLException {
        super(connection, query, 1003);
        this.parameterMetadata = new CallableParameterMetaData(connection, database, procedureName, false);
        this.setParamsAccordingToSetArguments();
        this.setParametersVariables();
    }

    private void setParamsAccordingToSetArguments() throws SQLException {
        this.params = new ArrayList(this.parameterCount);
        for (int index = 0; index < this.parameterCount; ++index) {
            this.params.add(new CallParameter());
        }
    }

    private void setInputOutputParameterMap() {
        if (this.outputParameterMapper == null) {
            this.outputParameterMapper = new int[this.params.size()];
            int currentOutputMapper = 1;
            for (int index = 0; index < this.params.size(); ++index) {
                this.outputParameterMapper[index] = ((CallParameter)this.params.get((int)index)).isOutput ? currentOutputMapper++ : -1;
            }
        }
    }

    @Override
    protected MariaSelectResultSet getResult() throws SQLException {
        if (this.outputResultSet == null) {
            if (!this.hasOutParameters) {
                throw new SQLException("No output result. registerOutParameter() must be call before executing command  !");
            }
            throw new SQLException("No output result.");
        }
        return this.outputResultSet;
    }

    @Override
    public MariaDbProcedureStatement clone() throws CloneNotSupportedException {
        MariaDbProcedureStatement clone = (MariaDbProcedureStatement)super.clone();
        clone.outputResultSet = null;
        return clone;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.validAllParameters();
        this.connection.lock.lock();
        try {
            super.executeInternal(0, this.hasOutParameters);
            this.retrieveOutputResult();
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    private void retrieveOutputResult() throws SQLException {
        if (this.hasOutParameters) {
            this.outputResultSet = (MariaSelectResultSet)super.retrieveCallableResult();
            if (this.outputResultSet != null) {
                this.outputResultSet.next();
            }
        } else {
            this.outputResultSet = null;
        }
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        ((CallParameter)this.params.get((int)(parameterIndex - 1))).isInput = true;
        super.setParameter(parameterIndex, holder);
    }

    @Override
    public boolean execute() throws SQLException {
        this.connection.lock.lock();
        try {
            this.validAllParameters();
            super.executeInternal(0, this.hasOutParameters);
            this.retrieveOutputResult();
            boolean bl = this.executionResult != null && this.executionResult.getResultSet() != null;
            return bl;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    private void validAllParameters() throws SQLException {
        this.setInputOutputParameterMap();
        for (int index = 0; index < this.params.size(); ++index) {
            if (((CallParameter)this.params.get((int)index)).isInput) continue;
            super.setParameter(index + 1, new NullParameter());
        }
        this.validParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!this.hasInOutParameters) {
            return super.executeBatch();
        }
        throw new SQLException("executeBatch not permit for procedure with output parameter");
    }
}

