/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.lang.reflect.Field;
import java.lang.reflect.ReflectPermission;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class StringParameter
implements ParameterHolder,
Cloneable {
    private String string;
    private boolean noBackslashEscapes;
    private byte[] escapedArray = null;
    private int position;
    private static Field charsFieldValue;

    public StringParameter(String string, boolean noBackslashEscapes) throws SQLException {
        this.string = string;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        if (this.escapedArray == null) {
            this.escapeUtf8();
        }
        os.write(this.escapedArray, 0, this.position);
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        if (this.escapedArray == null) {
            this.escapeUtf8();
        }
        os.buffer.put(this.escapedArray, 0, this.position);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        if (this.escapedArray == null) {
            this.escapeUtf8();
        }
        return this.position;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeStringLength(this.string);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.VARCHAR;
    }

    @Override
    public String toString() {
        if (this.string != null) {
            if (this.string.length() < 1024) {
                return "'" + this.string + "'";
            }
            return "'" + this.string.substring(0, 1024) + "...'";
        }
        if (this.position > 1024) {
            return new String(this.escapedArray, 0, 1024) + "...'";
        }
        return new String(this.escapedArray, 0, this.position);
    }

    private void escapeUtf8() {
        char[] chars;
        if (charsFieldValue != null) {
            try {
                chars = (char[])charsFieldValue.get(this.string);
            }
            catch (IllegalAccessException e) {
                chars = this.string.toCharArray();
            }
        } else {
            chars = this.string.toCharArray();
        }
        this.string = null;
        int charsLength = chars.length;
        int charsOffset = 0;
        this.position = 0;
        this.escapedArray = new byte[charsLength * 3 + 2];
        this.escapedArray[this.position++] = 39;
        if (this.noBackslashEscapes) {
            while (charsOffset < charsLength && chars[charsOffset] < '\u0080') {
                if (chars[charsOffset] == '\'') {
                    this.escapedArray[this.position++] = 39;
                }
                this.escapedArray[this.position++] = (byte)chars[charsOffset++];
            }
        } else {
            while (charsOffset < charsLength && chars[charsOffset] < '\u0080') {
                if (chars[charsOffset] == '\'' || chars[charsOffset] == '\\' || chars[charsOffset] == '\"' || chars[charsOffset] == '\u0000') {
                    this.escapedArray[this.position++] = 92;
                }
                this.escapedArray[this.position++] = (byte)chars[charsOffset++];
            }
        }
        while (charsOffset < charsLength) {
            char currChar;
            if ((currChar = chars[charsOffset++]) < '\u0080') {
                if (currChar == '\'') {
                    this.escapedArray[this.position++] = this.noBackslashEscapes ? 39 : 92;
                } else if (!(this.noBackslashEscapes || currChar != '\\' && currChar != '\"' && currChar != '\u0000')) {
                    this.escapedArray[this.position++] = 92;
                }
                this.escapedArray[this.position++] = (byte)currChar;
                continue;
            }
            if (currChar < '\u0800') {
                this.escapedArray[this.position++] = (byte)(0xC0 | currChar >> 6);
                this.escapedArray[this.position++] = (byte)(0x80 | currChar & 0x3F);
                continue;
            }
            if (currChar >= '\ud800' && currChar < '\ue000') {
                if (currChar >= '\ud800' && currChar < '\udc00') {
                    if (charsOffset + 1 > charsLength) {
                        this.escapedArray[this.position++] = 99;
                        break;
                    }
                    char nextChar = chars[charsOffset];
                    if (nextChar >= '\udc00' && nextChar < '\ue000') {
                        int surrogatePairs = (currChar << 10) + nextChar + -56613888;
                        this.escapedArray[this.position++] = (byte)(0xF0 | surrogatePairs >> 18);
                        this.escapedArray[this.position++] = (byte)(0x80 | surrogatePairs >> 12 & 0x3F);
                        this.escapedArray[this.position++] = (byte)(0x80 | surrogatePairs >> 6 & 0x3F);
                        this.escapedArray[this.position++] = (byte)(0x80 | surrogatePairs & 0x3F);
                        ++charsOffset;
                        continue;
                    }
                    this.escapedArray[this.position++] = 99;
                    continue;
                }
                this.escapedArray[this.position++] = 99;
                continue;
            }
            this.escapedArray[this.position++] = (byte)(0xE0 | currChar >> 12);
            this.escapedArray[this.position++] = (byte)(0x80 | currChar >> 6 & 0x3F);
            this.escapedArray[this.position++] = (byte)(0x80 | currChar & 0x3F);
        }
        this.escapedArray[this.position++] = 39;
    }

    @Override
    public boolean isLongData() {
        return false;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    static {
        RuntimePermission runtimePermission = new RuntimePermission("accessDeclaredMembers");
        ReflectPermission accessPermission = new ReflectPermission("suppressAccessChecks");
        boolean securityException = false;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                if (runtimePermission != null) {
                    securityManager.checkPermission(runtimePermission);
                }
                if (accessPermission != null) {
                    securityManager.checkPermission(accessPermission);
                }
            }
            catch (SecurityException exception) {
                securityException = true;
            }
        }
        if (!securityException) {
            try {
                charsFieldValue = String.class.getDeclaredField("value");
                charsFieldValue.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                charsFieldValue = null;
            }
        } else {
            charsFieldValue = null;
        }
    }
}

