/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.dao;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;

public class ClientPrepareResult
implements PrepareResult {
    private String sql;
    private List<byte[]> queryParts;
    private boolean rewritableValuesQuery = true;
    private boolean rewritableMultipleQuery = true;
    private int paramCount;

    private ClientPrepareResult(String sql, List<byte[]> queryParts, boolean rewritableValuesQuery, boolean rewritableMultipleQuery, boolean isRewritePart) {
        this.sql = sql;
        this.queryParts = queryParts;
        this.rewritableValuesQuery = rewritableValuesQuery;
        this.rewritableMultipleQuery = rewritableMultipleQuery;
        this.paramCount = queryParts.size() - (isRewritePart ? 3 : 1);
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public List<byte[]> getQueryParts() {
        return this.queryParts;
    }

    public boolean isRewritableValuesQuery() {
        return this.rewritableValuesQuery;
    }

    public boolean isRewritableMultipleQuery() {
        return this.rewritableMultipleQuery;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public static ClientPrepareResult createParameterParts(String queryString, boolean noBackslashEscapes) {
        try {
            boolean reWritablePrepare = false;
            boolean multipleQueriesPrepare = true;
            ArrayList<byte[]> partList = new ArrayList<byte[]>();
            LexState state = LexState.Normal;
            char lastChar = '\u0000';
            boolean endingSemicolon = false;
            boolean singleQuotes = false;
            int lastParameterPosition = 0;
            char[] query = queryString.toCharArray();
            int queryLength = query.length;
            for (int i = 0; i < queryLength; ++i) {
                if (state == LexState.Escape) {
                    state = LexState.String;
                }
                char car = query[i];
                switch (car) {
                    case '*': {
                        if (state != LexState.Normal || lastChar != '/') break;
                        state = LexState.SlashStarComment;
                        break;
                    }
                    case '/': {
                        if (state == LexState.SlashStarComment && lastChar == '*') {
                            state = LexState.Normal;
                            break;
                        }
                        if (state != LexState.Normal || lastChar != '/') break;
                        state = LexState.EOLComment;
                        break;
                    }
                    case '#': {
                        if (state != LexState.Normal) break;
                        state = LexState.EOLComment;
                        break;
                    }
                    case '-': {
                        if (state != LexState.Normal || lastChar != '-') break;
                        state = LexState.EOLComment;
                        multipleQueriesPrepare = false;
                        break;
                    }
                    case '\n': {
                        if (state != LexState.EOLComment) break;
                        multipleQueriesPrepare = true;
                        state = LexState.Normal;
                        break;
                    }
                    case '\"': {
                        if (state == LexState.Normal) {
                            state = LexState.String;
                            singleQuotes = false;
                            break;
                        }
                        if (state != LexState.String || singleQuotes) break;
                        state = LexState.Normal;
                        break;
                    }
                    case '\'': {
                        if (state == LexState.Normal) {
                            state = LexState.String;
                            singleQuotes = true;
                            break;
                        }
                        if (state != LexState.String || !singleQuotes) break;
                        state = LexState.Normal;
                        break;
                    }
                    case '\\': {
                        if (noBackslashEscapes || state != LexState.String) break;
                        state = LexState.Escape;
                        break;
                    }
                    case ';': {
                        if (state != LexState.Normal) break;
                        endingSemicolon = true;
                        multipleQueriesPrepare = false;
                        break;
                    }
                    case '?': {
                        if (state != LexState.Normal) break;
                        partList.add(queryString.substring(lastParameterPosition, i).getBytes("UTF-8"));
                        lastParameterPosition = i + 1;
                        break;
                    }
                    case '`': {
                        if (state == LexState.Backtick) {
                            state = LexState.Normal;
                            break;
                        }
                        if (state != LexState.Normal) break;
                        state = LexState.Backtick;
                        break;
                    }
                    default: {
                        if (state != LexState.Normal || !endingSemicolon || (byte)car < 40) break;
                        endingSemicolon = false;
                        multipleQueriesPrepare = true;
                    }
                }
                lastChar = car;
            }
            if (lastParameterPosition == 0) {
                partList.add(queryString.getBytes("UTF-8"));
            } else {
                partList.add(queryString.substring(lastParameterPosition, queryLength).getBytes("UTF-8"));
            }
            return new ClientPrepareResult(queryString, partList, reWritablePrepare, multipleQueriesPrepare, false);
        }
        catch (UnsupportedEncodingException u) {
            return null;
        }
    }

    public static boolean isRewritableBatch(String queryString, boolean noBackslashEscapes) {
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean singleQuotes = false;
        boolean endingSemicolon = false;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            if (state == LexState.Escape) {
                state = LexState.String;
            }
            char car = query[i];
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case ';': {
                    if (state != LexState.Normal) break;
                    endingSemicolon = true;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                default: {
                    if (state != LexState.Normal || !endingSemicolon || (byte)car < 40) break;
                    endingSemicolon = false;
                }
            }
            lastChar = car;
        }
        return state != LexState.EOLComment && !endingSemicolon;
    }

    public static ClientPrepareResult createRewritableParts(String queryString, boolean noBackslashEscapes) {
        try {
            boolean reWritablePrepare = true;
            boolean multipleQueriesPrepare = true;
            ArrayList<byte[]> partList = new ArrayList<byte[]>();
            LexState state = LexState.Normal;
            char lastChar = '\u0000';
            StringBuilder sb = new StringBuilder();
            String preValuePart1 = null;
            String preValuePart2 = null;
            String postValuePart = null;
            boolean singleQuotes = false;
            int isInParenthesis = 0;
            boolean skipChar = false;
            boolean isFirstChar = true;
            boolean isInsert = false;
            boolean semicolon = false;
            boolean hasParam = false;
            char[] query = queryString.toCharArray();
            int queryLength = query.length;
            for (int i = 0; i < queryLength; ++i) {
                if (state == LexState.Escape) {
                    sb.append(query[i]);
                    state = LexState.String;
                    continue;
                }
                char car = query[i];
                switch (car) {
                    case '*': {
                        if (state != LexState.Normal || lastChar != '/') break;
                        state = LexState.SlashStarComment;
                        break;
                    }
                    case '/': {
                        if (state == LexState.SlashStarComment && lastChar == '*') {
                            state = LexState.Normal;
                            break;
                        }
                        if (state != LexState.Normal || lastChar != '/') break;
                        state = LexState.EOLComment;
                        break;
                    }
                    case '#': {
                        if (state != LexState.Normal) break;
                        state = LexState.EOLComment;
                        break;
                    }
                    case '-': {
                        if (state != LexState.Normal || lastChar != '-') break;
                        state = LexState.EOLComment;
                        multipleQueriesPrepare = false;
                        break;
                    }
                    case '\n': {
                        if (state != LexState.EOLComment) break;
                        state = LexState.Normal;
                        break;
                    }
                    case '\"': {
                        if (state == LexState.Normal) {
                            state = LexState.String;
                            singleQuotes = false;
                            break;
                        }
                        if (state != LexState.String || singleQuotes) break;
                        state = LexState.Normal;
                        break;
                    }
                    case ';': {
                        if (state != LexState.Normal) break;
                        semicolon = true;
                        multipleQueriesPrepare = false;
                        break;
                    }
                    case '\'': {
                        if (state == LexState.Normal) {
                            state = LexState.String;
                            singleQuotes = true;
                            break;
                        }
                        if (state != LexState.String || !singleQuotes) break;
                        state = LexState.Normal;
                        break;
                    }
                    case '\\': {
                        if (noBackslashEscapes || state != LexState.String) break;
                        state = LexState.Escape;
                        break;
                    }
                    case '?': {
                        if (state != LexState.Normal) break;
                        hasParam = true;
                        if (preValuePart1 == null) {
                            preValuePart1 = sb.toString();
                            sb.setLength(0);
                        }
                        if (preValuePart2 == null) {
                            preValuePart2 = sb.toString();
                            sb.setLength(0);
                        } else {
                            if (postValuePart != null) {
                                reWritablePrepare = false;
                                sb.insert(0, postValuePart);
                                postValuePart = null;
                            }
                            partList.add(sb.toString().getBytes("UTF-8"));
                            sb.setLength(0);
                        }
                        skipChar = true;
                        break;
                    }
                    case '`': {
                        if (state == LexState.Backtick) {
                            state = LexState.Normal;
                            break;
                        }
                        if (state != LexState.Normal) break;
                        state = LexState.Backtick;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (state != LexState.Normal || postValuePart != null || queryLength <= i + 6 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'c' && query[i + 4] != 'C' || query[i + 5] != 't' && query[i + 5] != 'T') break;
                        reWritablePrepare = false;
                        break;
                    }
                    case 'V': 
                    case 'v': {
                        if (state != LexState.Normal || preValuePart1 != null || lastChar != ')' && (byte)lastChar > 40 || queryLength <= i + 7 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'e' && query[i + 4] != 'E' || query[i + 5] != 's' && query[i + 5] != 'S' || query[i + 6] != '(' && (byte)query[i + 6] > 40) break;
                        sb.append(car);
                        sb.append(query[i + 1]);
                        sb.append(query[i + 2]);
                        sb.append(query[i + 3]);
                        sb.append(query[i + 4]);
                        sb.append(query[i + 5]);
                        i += 5;
                        preValuePart1 = sb.toString();
                        sb.setLength(0);
                        skipChar = true;
                        break;
                    }
                    case '(': {
                        if (state != LexState.Normal) break;
                        ++isInParenthesis;
                        break;
                    }
                    case ')': {
                        if (state != LexState.Normal || --isInParenthesis != 0 || preValuePart2 == null || postValuePart != null) break;
                        sb.append(car);
                        postValuePart = sb.toString();
                        sb.setLength(0);
                        skipChar = true;
                        break;
                    }
                    default: {
                        if (state == LexState.Normal && isFirstChar && (byte)car >= 40) {
                            if (car == 'I' || car == 'i') {
                                isInsert = true;
                            }
                            isFirstChar = false;
                        }
                        if (state != LexState.Normal || !semicolon || (byte)car < 40) break;
                        reWritablePrepare = false;
                        multipleQueriesPrepare = true;
                    }
                }
                lastChar = car;
                if (skipChar) {
                    skipChar = false;
                    continue;
                }
                sb.append(car);
            }
            partList.add(0, preValuePart1 == null ? new byte[]{} : preValuePart1.getBytes("UTF-8"));
            if (!hasParam) {
                partList.add(1, sb.toString().getBytes("UTF-8"));
                sb.setLength(0);
            } else {
                partList.add(1, preValuePart2 == null ? new byte[]{} : preValuePart2.getBytes("UTF-8"));
            }
            if (!isInsert) {
                reWritablePrepare = false;
            }
            if (hasParam) {
                partList.add(postValuePart == null ? new byte[]{} : postValuePart.getBytes("UTF-8"));
            }
            partList.add(sb.toString().getBytes("UTF-8"));
            return new ClientPrepareResult(queryString, partList, reWritablePrepare, multipleQueriesPrepare, true);
        }
        catch (UnsupportedEncodingException u) {
            return null;
        }
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        Parameter,
        EOLComment,
        Backtick;

    }
}

