/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.ServerPrepareStatementCache;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public interface Protocol {
    public ServerPrepareResult prepare(String var1, boolean var2) throws QueryException;

    public boolean getAutocommit();

    public boolean noBackslashEscapes();

    public void connect() throws QueryException;

    public UrlParser getUrlParser();

    public boolean inTransaction();

    public FailoverProxy getProxy();

    public void setProxy(FailoverProxy var1);

    public Options getOptions();

    public boolean hasMoreResults();

    public void close();

    public void closeExplicit();

    public boolean isClosed();

    public void setCatalog(String var1) throws QueryException;

    public String getServerVersion();

    public boolean isConnected();

    public boolean getReadonly();

    public void setReadonly(boolean var1) throws QueryException;

    public boolean isMasterConnection();

    public boolean mustBeMasterConnection();

    public HostAddress getHostAddress();

    public void setHostAddress(HostAddress var1);

    public String getHost();

    public int getPort();

    public void rollback() throws QueryException;

    public String getDatabase();

    public String getUsername();

    public String getPassword();

    public boolean ping() throws QueryException;

    public void executeQuery(String var1) throws QueryException;

    public void executeQuery(boolean var1, ExecutionResult var2, String var3, int var4) throws QueryException;

    public void executeQuery(boolean var1, ExecutionResult var2, ClientPrepareResult var3, ParameterHolder[] var4, int var5) throws QueryException;

    public void executeBatchMulti(boolean var1, ExecutionResult var2, ClientPrepareResult var3, List<ParameterHolder[]> var4, int var5) throws QueryException;

    public void executeBatch(boolean var1, ExecutionResult var2, List<String> var3, int var4) throws QueryException;

    public void executeBatchMultiple(boolean var1, ExecutionResult var2, List<String> var3, int var4) throws QueryException;

    public void executeBatchRewrite(boolean var1, ExecutionResult var2, ClientPrepareResult var3, List<ParameterHolder[]> var4, int var5, boolean var6) throws QueryException;

    public void executePreparedQuery(boolean var1, ServerPrepareResult var2, ExecutionResult var3, ParameterHolder[] var4, int var5) throws QueryException;

    public ServerPrepareResult prepareAndExecutes(boolean var1, ServerPrepareResult var2, ExecutionResult var3, String var4, List<ParameterHolder[]> var5, int var6) throws QueryException;

    public ServerPrepareResult prepareAndExecute(boolean var1, ServerPrepareResult var2, ExecutionResult var3, String var4, ParameterHolder[] var5, int var6) throws QueryException;

    public ExecutionResult getResult(ExecutionResult var1, int var2, boolean var3, boolean var4) throws QueryException;

    public void cancelCurrentQuery() throws QueryException, IOException;

    public void skip() throws SQLException, QueryException;

    public boolean checkIfMaster() throws QueryException;

    public boolean hasWarnings();

    public int getDataTypeMappingFlags();

    public void setInternalMaxRows(int var1);

    public int getMaxRows();

    public void setMaxRows(int var1) throws QueryException;

    public int getMajorServerVersion();

    public int getMinorServerVersion();

    public boolean versionGreaterOrEqual(int var1, int var2, int var3);

    public void setLocalInfileInputStream(InputStream var1);

    public int getTimeout() throws SocketException;

    public void setTimeout(int var1) throws SocketException;

    public boolean getPinGlobalTxToPhysicalConnection();

    public long getServerThreadId();

    public void setTransactionIsolation(int var1) throws QueryException;

    public int getTransactionIsolationLevel();

    public boolean isExplicitClosed();

    public void connectWithoutProxy() throws QueryException;

    public boolean shouldReconnectWithoutProxy();

    public void setHostFailedWithoutProxy();

    public void releasePrepareStatement(ServerPrepareResult var1) throws QueryException;

    public boolean forceReleasePrepareStatement(int var1) throws QueryException;

    public void forceReleaseWaitingPrepareStatement() throws QueryException;

    public ServerPrepareStatementCache prepareStatementCache();

    public String getServerData(String var1);

    public Calendar getCalendar();

    public void prolog(ExecutionResult var1, int var2, boolean var3, MariaDbConnection var4, Statement var5) throws SQLException;

    public void prologProxy(ServerPrepareResult var1, ExecutionResult var2, int var3, boolean var4, MariaDbConnection var5, Statement var6) throws SQLException;

    public MariaSelectResultSet getActiveStreamingResult();

    public void setActiveStreamingResult(MariaSelectResultSet var1);

    public ReentrantLock getLock();

    public void getMoreResults(ExecutionResult var1) throws QueryException;

    public void setMoreResults(boolean var1, boolean var2);

    public void setHasWarnings(boolean var1);

    public boolean hasServerComMultiCapability();

    public void releaseWriterBuffer();

    public ByteBuffer getWriter();

    public ServerPrepareResult addPrepareInCache(String var1, ServerPrepareResult var2);

    public void readEofPacket() throws QueryException, IOException;

    public void skipEofPacket() throws QueryException, IOException;

    public ReadPacketFetcher getPacketFetcher();

    public void changeSocketTcpNoDelay(boolean var1) throws SocketException;
}

