/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;

public class TimestampParameter
implements ParameterHolder,
Cloneable {
    private Timestamp ts;
    private Calendar calendar;
    private boolean fractionalSeconds;
    private Options options;

    public TimestampParameter(Timestamp ts, Calendar cal, boolean fractionalSeconds, Options options) {
        this.ts = ts;
        this.calendar = cal;
        this.fractionalSeconds = fractionalSeconds;
        this.options = options;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        os.write(39);
        os.write(this.dateToByte());
        ParameterWriter.formatMicroseconds(os, this.ts.getNanos() / 1000, this.fractionalSeconds);
        os.write(39);
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        os.buffer.put((byte)39);
        os.writeUnsafe(this.dateToByte());
        ParameterWriter.formatMicrosecondsUnsafe(os, this.ts.getNanos() / 1000, this.fractionalSeconds);
        os.buffer.put((byte)39);
    }

    private byte[] dateToByte() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.calendar != null) {
            sdf.setCalendar(this.calendar);
        }
        return sdf.format(this.ts).getBytes();
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return 27L;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        if (this.options.useLegacyDatetimeCode) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(this.ts.getTime());
        writeBuffer.writeTimestampLength(this.calendar, this.ts, this.fractionalSeconds);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.DATETIME;
    }

    @Override
    public String toString() {
        return "'" + this.ts.toString() + "'";
    }

    @Override
    public boolean isLongData() {
        return false;
    }

    @Override
    public boolean isNullData() {
        return false;
    }
}

