/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class MariaDbStatement
implements Statement,
Cloneable {
    private static final DynamicSizedSchedulerInterface timeoutScheduler = SchedulerServiceProviderHolder.getScheduler(0);
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected Future<?> timerTaskFuture;
    protected boolean isRewriteable = true;
    protected int rewriteOffset = -1;
    protected ResultSet batchResultSet = null;
    protected volatile boolean closed = false;
    boolean isTimedout;
    volatile boolean executing;
    private List<String> batchQueries;
    Deque<ExecutionResult> cachedExecutionResults;
    private boolean warningsCleared;
    protected int queryTimeout;
    private int fetchSize;
    protected int maxRows;
    protected final ReentrantLock lock;
    protected ExecutionResult executionResult = null;
    protected int resultSetScrollType;

    public MariaDbStatement(MariaDbConnection connection, int resultSetScrollType) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.resultSetScrollType = resultSetScrollType;
        this.lock = this.connection.lock;
        this.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
    }

    public MariaDbStatement clone() throws CloneNotSupportedException {
        MariaDbStatement clone = (MariaDbStatement)super.clone();
        clone.connection = this.connection;
        clone.protocol = this.protocol;
        clone.timerTaskFuture = null;
        clone.batchQueries = new ArrayList<String>();
        clone.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
        clone.executionResult = null;
        clone.closed = false;
        clone.warningsCleared = true;
        clone.fetchSize = 0;
        clone.maxRows = 0;
        clone.isRewriteable = true;
        return clone;
    }

    public static void unloadDriver() {
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    protected void setTimerTask() {
        assert (this.timerTaskFuture == null);
        this.timerTaskFuture = timeoutScheduler.addThreadAndSchedule(new Runnable(){

            @Override
            public void run() {
                try {
                    MariaDbStatement.this.isTimedout = true;
                    MariaDbStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, this.queryTimeout, TimeUnit.SECONDS);
    }

    protected void executeQueryProlog() throws SQLException {
        if (this.closed) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.protocol.prolog(this.executionResult, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        this.cachedExecutionResults.clear();
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    protected void cacheMoreResults(ExecutionResult execResult, int fetchSize, boolean canHaveCallableResult) throws SQLException {
        if (fetchSize != 0) {
            return;
        }
        if (execResult.hasMoreResultAvailable()) {
            try {
                while (this.protocol.hasMoreResults()) {
                    SingleExecutionResult executionResult = new SingleExecutionResult(this, 0, true, canHaveCallableResult);
                    this.protocol.getMoreResults(executionResult);
                    this.cachedExecutionResults.add(executionResult);
                }
            }
            catch (QueryException e) {
                throw ExceptionMapper.createException(e, this.connection, this);
            }
        }
    }

    protected void stopTimeoutTask() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }

    protected void executeQueryEpilog(QueryException queryException) throws SQLException {
        this.stopTimeoutTask();
        if (this.isTimedout) {
            this.isTimedout = false;
            queryException = new QueryException("Query timed out", 1317, "JZ0002", queryException);
        }
        if (queryException == null) {
            return;
        }
        if (queryException.getSqlState() != null && queryException.getSqlState().startsWith("08")) {
            this.close();
        }
        ExceptionMapper.throwException(queryException, this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(String sql, int fetchSize) throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            SingleExecutionResult internalExecutionResult = new SingleExecutionResult(this, fetchSize, true, false);
            this.protocol.executeQuery(internalExecutionResult, sql, this.resultSetScrollType);
            this.cacheMoreResults(internalExecutionResult, fetchSize, false);
            this.executionResult = internalExecutionResult;
            boolean bl = this.executionResult.getResult() != null;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return this.executionResult.getResult();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            boolean hasMoreResult = false;
            if (this.executionResult != null) {
                hasMoreResult = this.executionResult.hasMoreResultAvailable();
                if (this.executionResult.getFetchSize() > 0) {
                    this.executionResult.close();
                }
                this.executionResult = null;
            }
            this.cachedExecutionResults.clear();
            if (hasMoreResult) {
                this.connection.lock.lock();
                try {
                    this.skipMoreResults();
                }
                finally {
                    this.protocol = null;
                    this.connection.lock.unlock();
                }
            } else {
                this.protocol = null;
            }
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ResultSet retrieveCallableResult() throws SQLException {
        if (this.executionResult != null && this.executionResult.getResult() != null && this.executionResult.getResult().isCallableResult()) {
            MariaSelectResultSet resultSet = this.executionResult.getResult();
            this.getMoreResults();
            return resultSet;
        }
        for (ExecutionResult batchExecutionResult : this.cachedExecutionResults) {
            if (batchExecutionResult.getResult() == null || batchExecutionResult.getResult() == null || !batchExecutionResult.getResult().isCallableResult()) continue;
            MariaSelectResultSet resultSet = batchExecutionResult.getResult();
            this.cachedExecutionResults.remove(batchExecutionResult);
            return resultSet;
        }
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows cannot be negative : asked for " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClose();
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.executionResult != null && this.executionResult.getResult() == null) {
            int autoIncrementIncrement = this.connection.getAutoIncrementIncrement();
            if (this.executionResult.hasMoreThanOneAffectedRows()) {
                long[] data;
                if (this.executionResult instanceof SingleExecutionResult) {
                    int updateCount = this.executionResult.getFirstAffectedRows();
                    data = new long[updateCount];
                    for (int i = 0; i < updateCount; ++i) {
                        data[i] = ((SingleExecutionResult)this.executionResult).getInsertId() + (long)(i * autoIncrementIncrement);
                    }
                } else {
                    MultiIntExecutionResult multiExecution = (MultiIntExecutionResult)this.executionResult;
                    int size = 0;
                    int affectedRowslength = multiExecution.getAffectedRows().length;
                    for (int i = 0; i < affectedRowslength; ++i) {
                        size += multiExecution.getAffectedRows()[i];
                    }
                    data = new long[size];
                    for (int affectedRows = 0; affectedRows < affectedRowslength; ++affectedRows) {
                        for (int i = 0; i < affectedRows; ++i) {
                            data[i] = multiExecution.getInsertIds()[affectedRows] + (long)(i * autoIncrementIncrement);
                        }
                    }
                }
                return MariaSelectResultSet.createGeneratedData(data, this.connection.getProtocol(), true);
            }
            return MariaSelectResultSet.createGeneratedData(this.executionResult.getInsertIds(), this.connection.getProtocol(), true);
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        if (this.executionResult != null) {
            return this.executionResult.getResult();
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.executionResult == null || this.executionResult.getResult() != null) {
            return -1;
        }
        if (this.executionResult instanceof SingleExecutionResult) {
            return (int)((SingleExecutionResult)this.executionResult).getAffectedRows();
        }
        return ((MultiIntExecutionResult)this.executionResult).getAffectedRows()[0];
    }

    protected void skipMoreResults() throws SQLException {
        try {
            this.protocol.skip();
            this.warningsCleared = false;
            this.connection.reenableWarnings();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.executionResult != null) {
            if (this.executionResult.getFetchSize() == 0) {
                this.executionResult = this.cachedExecutionResults.poll();
                return this.executionResult != null && this.executionResult.getResult() != null;
            }
            this.checkClose();
            this.lock.lock();
            try {
                this.executionResult.close();
                SingleExecutionResult internalExecutionResult = new SingleExecutionResult(this, this.fetchSize, true, false);
                if (internalExecutionResult.hasMoreResultAvailable()) {
                    this.protocol.getMoreResults(internalExecutionResult);
                    this.executionResult = internalExecutionResult;
                    boolean bl = this.executionResult.getResult() != null;
                    return bl;
                }
                this.executionResult = null;
                boolean bl = false;
                return bl;
            }
            catch (QueryException queryException) {
                ExceptionMapper.throwException(queryException, this.connection, this);
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        if (rows == Integer.MIN_VALUE) {
            this.fetchSize = 1;
            return;
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        String sqlQuery = sql;
        if (this.isRewriteable && (this.protocol.getOptions().rewriteBatchedStatements || this.protocol.getOptions().allowMultiQueries)) {
            int sqlRewriteOffset = this.isRewritable(sql, this.connection.noBackslashEscapes);
            if (this.rewriteOffset == -1) {
                this.rewriteOffset = sqlRewriteOffset;
            } else {
                this.isRewriteable = this.isRewriteable && this.rewriteOffset == sqlRewriteOffset;
            }
        }
        this.batchQueries.add(sqlQuery);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
        this.isRewriteable = true;
        this.rewriteOffset = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        if (this.batchQueries == null || this.batchQueries.size() == 0) {
            return new int[0];
        }
        MultiIntExecutionResult internalExecutionResult = new MultiIntExecutionResult((Statement)this, this.batchQueries.size(), 0, false);
        this.lock.lock();
        try {
            this.cachedExecutionResults.clear();
            QueryException exception = null;
            this.executing = true;
            this.executeQueryProlog();
            try {
                if (this.isRewriteable && (this.getProtocol().getOptions().allowMultiQueries || this.getProtocol().getOptions().rewriteBatchedStatements)) {
                    boolean rewrittenBatch = this.isRewriteable && this.getProtocol().getOptions().rewriteBatchedStatements;
                    this.protocol.executeQueriesRewrite(internalExecutionResult, this.batchQueries, this.resultSetScrollType, rewrittenBatch, rewrittenBatch && this.rewriteOffset != -1 ? this.rewriteOffset : 0);
                    this.cacheMoreResults(internalExecutionResult, 0, false);
                    if (rewrittenBatch) {
                        internalExecutionResult.updateResultsForRewrite();
                    } else {
                        internalExecutionResult.updateResultsMultiple(this.cachedExecutionResults);
                    }
                } else {
                    this.protocol.executeQueries(internalExecutionResult, this.batchQueries, this.resultSetScrollType);
                    this.cacheMoreResults(internalExecutionResult, 0, false);
                }
            }
            catch (QueryException e) {
                exception = e;
            }
            finally {
                this.executionResult = internalExecutionResult;
                this.executing = false;
                this.executeQueryEpilog(exception);
            }
            int[] nArray = internalExecutionResult.getAffectedRows();
            return nArray;
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), internalExecutionResult.getAffectedRows(), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot do an operation on a closed statement");
        }
    }

    private int isRewritable(String queryString, boolean noBackslashEscapes) {
        this.isRewriteable = true;
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean singleQuotes = false;
        int valueIndex = -1;
        boolean isFirstChar = true;
        boolean isInsert = false;
        boolean semicolon = false;
        char[] query = queryString.toCharArray();
        for (int i = 0; i < query.length; ++i) {
            if (state == LexState.Escape) {
                state = LexState.String;
                continue;
            }
            char car = query[i];
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case ';': {
                    if (state != LexState.Normal) break;
                    semicolon = true;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                case 'S': 
                case 's': {
                    if (state != LexState.Normal || valueIndex != -1 || query.length <= i + 6 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'c' && query[i + 4] != 'C' || query[i + 5] != 't' && query[i + 5] != 'T') break;
                    this.isRewriteable = false;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (state != LexState.Normal || valueIndex != -1 || lastChar != ')' && (byte)lastChar > 40 || query.length <= i + 7 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'e' && query[i + 4] != 'E' || query[i + 5] != 's' && query[i + 5] != 'S' || query[i + 6] != '(' && (byte)query[i + 6] > 40) break;
                    valueIndex = i + 6;
                    i += 6;
                    break;
                }
                default: {
                    if (!(state != LexState.Normal || !isFirstChar || lastChar != '\u0000' && (byte)lastChar < 40 || car != 'I' && car != 'i')) {
                        isInsert = true;
                        isFirstChar = false;
                    }
                    if (state != LexState.Normal || !semicolon || (byte)lastChar < 40) break;
                    this.isRewriteable = false;
                }
            }
            lastChar = car;
        }
        if (semicolon || !isInsert || valueIndex == -1) {
            this.isRewriteable = false;
        }
        return valueIndex;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        Parameter,
        EOLComment,
        Backtick;

    }
}

