/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareStatementCacheKey;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class PrepareStatementCache
extends LinkedHashMap<PrepareStatementCacheKey, PrepareResult> {
    private int maxSize;
    private Protocol protocol;

    private PrepareStatementCache(int size, Protocol protocol) {
        super(size, 0.75f, true);
        this.maxSize = size;
        this.protocol = protocol;
    }

    public static PrepareStatementCache newInstance(int size, Protocol protocol) {
        return new PrepareStatementCache(size, protocol);
    }

    public PrepareResult putIfNone(PrepareStatementCacheKey key, PrepareResult value) {
        this.put(key, value);
        return value;
    }

    @Override
    protected synchronized boolean removeEldestEntry(Map.Entry<PrepareStatementCacheKey, PrepareResult> eldest) {
        if (this.size() > this.maxSize) {
            if (eldest.getValue().setClosedIfUnused()) {
                try {
                    this.protocol.forceReleasePrepareStatement(eldest.getValue().getStatementId());
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }
}

