/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.util.buffer.Reader;

public class ErrorPacket
extends AbstractResultPacket {
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final byte[] sqlState;
    private final String message;

    public ErrorPacket(ByteBuffer byteBuffer) {
        Reader reader = new Reader(byteBuffer);
        reader.readByte();
        this.errorNumber = reader.readShort();
        this.sqlStateMarker = reader.readByte();
        if (this.sqlStateMarker == 35) {
            this.sqlState = reader.readRawBytes(5);
            this.message = reader.readString(StandardCharsets.UTF_8);
        } else {
            byte bytes;
            byte[] msgBuf = new byte[reader.getRemainingSize() + 1];
            msgBuf[0] = this.sqlStateMarker;
            int cnt = 1;
            while (reader.getRemainingSize() > 0 && (bytes = reader.readByte()) != 0) {
                msgBuf[cnt++] = bytes;
            }
            this.message = new String(msgBuf, StandardCharsets.UTF_8);
            this.sqlState = "HY000".getBytes();
        }
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public AbstractResultPacket.ResultType getResultType() {
        return AbstractResultPacket.ResultType.ERROR;
    }

    public byte getPacketSeq() {
        return 0;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }

    public byte getSqlStateMarker() {
        return this.sqlStateMarker;
    }
}

