/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.nio.ByteBuffer;

public abstract class AbstractResultPacket {
    public abstract ResultType getResultType();

    public static long getLengthEncodedBinary(ByteBuffer byteBuffer) {
        int type = byteBuffer.get() & 0xFF;
        switch (type) {
            case 252: {
                return 0xFFFFL & (long)byteBuffer.getShort();
            }
            case 253: {
                return 0xFFFFFF & AbstractResultPacket.read24bitword(byteBuffer);
            }
            case 254: {
                return byteBuffer.getLong();
            }
            case 255: {
                return -1L;
            }
        }
        return type;
    }

    public static int read24bitword(ByteBuffer byteBuffer) {
        byte[] tmpArr = new byte[3];
        byteBuffer.get(tmpArr);
        return (tmpArr[0] & 0xFF) + ((tmpArr[1] & 0xFF) << 8) + ((tmpArr[2] & 0xFF) << 16);
    }

    public static enum ResultType {
        OK,
        ERROR,
        EOF,
        RESULTSET,
        LOCALINFILE,
        FIELD;

    }
}

