/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mariadb.jdbc.internal.util.buffer.ReadUtil;

public final class RawPacket {
    private final ByteBuffer byteBuffer;
    private final int packetSeq;

    public RawPacket(ByteBuffer byteBuffer, int packetSeq) {
        this.byteBuffer = byteBuffer;
        this.packetSeq = packetSeq;
    }

    public static RawPacket nextReusablePacket(InputStream is, byte[] headerBuffer, byte[] reusableBuffer) throws IOException {
        ReadUtil.readFully(is, headerBuffer, 0, 4);
        int length = (headerBuffer[0] & 0xFF) + ((headerBuffer[1] & 0xFF) << 8) + ((headerBuffer[2] & 0xFF) << 16);
        byte packetSeq = headerBuffer[3];
        byte[] rawBytes = length < 1024 ? reusableBuffer : new byte[length];
        ReadUtil.readFully(is, rawBytes, 0, length);
        RawPacket raw = new RawPacket(ByteBuffer.wrap(rawBytes, 0, length).order(ByteOrder.LITTLE_ENDIAN), packetSeq);
        return raw;
    }

    static RawPacket nextPacket(InputStream is) throws IOException {
        byte[] lengthBuffer = new byte[4];
        ReadUtil.readFully(is, lengthBuffer);
        int length = (lengthBuffer[0] & 0xFF) + ((lengthBuffer[1] & 0xFF) << 8) + ((lengthBuffer[2] & 0xFF) << 16);
        byte packetSeq = lengthBuffer[3];
        byte[] rawBytes = new byte[length];
        ReadUtil.readFully(is, rawBytes);
        return new RawPacket(ByteBuffer.wrap(rawBytes).order(ByteOrder.LITTLE_ENDIAN), packetSeq);
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int getPacketSeq() {
        return this.packetSeq;
    }
}

