/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.PrepareStatementCache;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public interface Protocol {
    public PrepareResult prepare(String var1, boolean var2) throws QueryException;

    public boolean getAutocommit();

    public boolean noBackslashEscapes();

    public void connect() throws QueryException;

    public UrlParser getUrlParser();

    public boolean inTransaction();

    public FailoverProxy getProxy();

    public void setProxy(FailoverProxy var1);

    public Options getOptions();

    public boolean hasMoreResults();

    public void close();

    public void closeExplicit();

    public boolean isClosed();

    public void setCatalog(String var1) throws QueryException;

    public String getServerVersion();

    public boolean isConnected();

    public boolean getReadonly();

    public void setReadonly(boolean var1) throws QueryException;

    public boolean isMasterConnection();

    public boolean mustBeMasterConnection();

    public HostAddress getHostAddress();

    public void setHostAddress(HostAddress var1);

    public String getHost();

    public int getPort();

    public void rollback();

    public String getDatabase();

    public String getUsername();

    public String getPassword();

    public boolean ping() throws QueryException;

    public AbstractQueryResult executeQuery(String var1, boolean var2) throws QueryException;

    public AbstractQueryResult executeQuery(List<String> var1, boolean var2, boolean var3, int var4) throws QueryException;

    public AbstractQueryResult executeQueries(List<String> var1, List<ParameterHolder[]> var2, boolean var3, boolean var4) throws QueryException;

    public AbstractQueryResult getResult(boolean var1, boolean var2) throws QueryException;

    public void cancelCurrentQuery() throws QueryException, IOException;

    public AbstractQueryResult getMoreResults(boolean var1) throws QueryException;

    public boolean checkIfMaster() throws QueryException;

    public boolean hasWarnings();

    public int getDataTypeMappingFlags();

    public void setInternalMaxRows(int var1);

    public int getMaxRows();

    public void setMaxRows(int var1) throws QueryException;

    public int getMajorServerVersion();

    public int getMinorServerVersion();

    public boolean versionGreaterOrEqual(int var1, int var2, int var3);

    public void setLocalInfileInputStream(InputStream var1);

    public int getTimeout() throws SocketException;

    public void setTimeout(int var1) throws SocketException;

    public boolean getPinGlobalTxToPhysicalConnection();

    public long getServerThreadId();

    public void setTransactionIsolation(int var1) throws QueryException;

    public int getTransactionIsolationLevel();

    public boolean isExplicitClosed();

    public void closeIfActiveResult();

    public void connectWithoutProxy() throws QueryException;

    public boolean shouldReconnectWithoutProxy();

    public void setHostFailedWithoutProxy();

    public AbstractQueryResult executePreparedQuery(PrepareResult var1, String var2, ParameterHolder[] var3, MariaDbType[] var4, boolean var5) throws QueryException;

    public AbstractQueryResult executePreparedQueryAfterFailover(PrepareResult var1, String var2, ParameterHolder[] var3, MariaDbType[] var4, boolean var5) throws QueryException;

    public void releasePrepareStatement(PrepareResult var1, String var2) throws QueryException;

    public void forceReleasePrepareStatement(int var1) throws QueryException;

    public PrepareStatementCache prepareStatementCache();

    public String getServerData(String var1);

    public Calendar getCalendar();

    public void prolog(boolean var1, int var2, boolean var3, MariaDbConnection var4, Statement var5) throws SQLException;

    public void prologProxy(PrepareResult var1, boolean var2, int var3, boolean var4, MariaDbConnection var5, Statement var6) throws SQLException;
}

