/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.util.buffer.Buffer;

public class LocalInfilePacket
extends AbstractResultPacket {
    private String fileName;

    public LocalInfilePacket(Buffer buffer) {
        long fieldCount = buffer.getLengthEncodedBinary();
        if (fieldCount != -1L) {
            throw new AssertionError((Object)"field count must be -1");
        }
        this.fileName = buffer.readString(StandardCharsets.UTF_8);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return this.fileName;
    }

    @Override
    public AbstractResultPacket.ResultType getResultType() {
        return AbstractResultPacket.ResultType.LOCALINFILE;
    }

    public byte getPacketSeq() {
        return 0;
    }
}

