/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbCallableStatement;
import org.mariadb.jdbc.MariaDbClientPreparedStatement;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.MariaDbDatabaseMetaData;
import org.mariadb.jdbc.MariaDbPooledConnection;
import org.mariadb.jdbc.MariaDbSavepoint;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.DefaultOptions;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public final class MariaDbConnection
implements Connection {
    public final ReentrantLock lock;
    private final Protocol protocol;
    public Pattern requestWithoutComments = Pattern.compile("((?<![\\\\])['\"])((?:.(?!(?<![\\\\])\\1))*.?)\\1", 2);
    public MariaDbPooledConnection pooledConnection;
    boolean noBackslashEscapes;
    boolean nullCatalogMeansCurrent = true;
    int autoIncrementIncrement;
    volatile int lowercaseTableNames = -1;
    private int savepointCount = 0;
    private Options options;
    private boolean warningsCleared;

    private MariaDbConnection(Protocol protocol, ReentrantLock lock) throws SQLException {
        this.protocol = protocol;
        this.options = protocol.getOptions();
        this.noBackslashEscapes = protocol.noBackslashEscapes();
        this.nullCatalogMeansCurrent = this.options.nullCatalogMeansCurrent;
        this.lock = lock;
    }

    public static MariaDbConnection newConnection(Protocol protocol, ReentrantLock lock) throws SQLException {
        return new MariaDbConnection(protocol, lock);
    }

    public static String quoteIdentifier(String string) {
        return "`" + string.replaceAll("`", "``") + "`";
    }

    @Deprecated
    public static String unquoteIdentifier(String string) {
        if (string != null && string.startsWith("`") && string.endsWith("`") && string.length() >= 2) {
            return string.substring(1, string.length() - 1).replace("``", "`");
        }
        return string;
    }

    Protocol getProtocol() {
        return this.protocol;
    }

    int getAutoIncrementIncrement() {
        if (this.autoIncrementIncrement == 0) {
            try {
                ResultSet rs = this.createStatement().executeQuery("select @@auto_increment_increment");
                rs.next();
                this.autoIncrementIncrement = rs.getInt(1);
            }
            catch (SQLException e) {
                this.autoIncrementIncrement = 1;
            }
        }
        return this.autoIncrementIncrement;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkConnection();
        return new MariaDbStatement(this, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw ExceptionMapper.getFeatureNotSupportedException("Only read-only result sets allowed");
        }
        return this.createStatement();
    }

    private void checkConnection() throws SQLException {
        if (this.protocol.isExplicitClosed()) {
            throw new SQLException("createStatement() is called on closed connection");
        }
        if (this.protocol.isClosed() && this.protocol.getProxy() != null) {
            this.lock.lock();
            try {
                this.protocol.getProxy().reconnect();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.internalPrepareStatement(sql, this.options.alwaysAutoGeneratedKeys ? 1 : 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw ExceptionMapper.getFeatureNotSupportedException("Only read-only result sets allowed");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.internalPrepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    public PreparedStatement internalPrepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkConnection();
        if (!this.options.allowMultiQueries && !this.options.rewriteBatchedStatements && this.options.useServerPrepStmts && this.checkIfPreparable(sql)) {
            try {
                return new MariaDbServerPreparedStatement(this, sql, autoGeneratedKeys);
            }
            catch (SQLException e) {
                return new MariaDbClientPreparedStatement(this, sql, autoGeneratedKeys);
            }
        }
        return new MariaDbClientPreparedStatement(this, sql, autoGeneratedKeys);
    }

    private boolean checkIfPreparable(String sql) {
        if (sql == null) {
            return true;
        }
        if (sql.indexOf("?") == -1) {
            return false;
        }
        String cleanSql = sql.toUpperCase().trim();
        if (cleanSql.startsWith("SELECT") || cleanSql.startsWith("UPDATE") || cleanSql.startsWith("INSERT") || cleanSql.startsWith("DELETE")) {
            return (cleanSql = this.requestWithoutComments.matcher(cleanSql).replaceAll("")).indexOf("?") > 0;
        }
        return false;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkConnection();
        return new MariaDbCallableStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new MariaDbCallableStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return Utils.nativeSql(sql, this.noBackslashEscapes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.protocol.getAutocommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit == this.getAutoCommit()) {
            return;
        }
        try (Statement stmt = this.createStatement();){
            stmt.executeUpdate("set autocommit=" + (autoCommit ? "1" : "0"));
        }
    }

    @Override
    public void commit() throws SQLException {
        block6: {
            this.lock.lock();
            try {
                if (this.getAutoCommit()) break block6;
                try (Statement st = this.createStatement();){
                    st.execute("COMMIT");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (Statement st = this.createStatement();){
            st.execute("ROLLBACK");
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Statement st = this.createStatement();
        st.execute("ROLLBACK TO SAVEPOINT " + savepoint.toString());
        st.close();
    }

    @Override
    public void close() throws SQLException {
        if (this.pooledConnection != null) {
            this.lock.lock();
            try {
                if (this.protocol != null && this.protocol.inTransaction()) {
                    this.rollback();
                }
            }
            finally {
                this.lock.unlock();
            }
            this.pooledConnection.fireConnectionClosed();
            return;
        }
        this.protocol.closeExplicit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.protocol.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MariaDbDatabaseMetaData(this, this.protocol.getUsername(), "jdbc:mysql://" + this.protocol.getHost() + ":" + this.protocol.getPort() + "/" + this.protocol.getDatabase());
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.protocol.getReadonly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.protocol.setReadonly(readOnly);
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        String catalog = null;
        try (Statement st = null;){
            st = this.createStatement();
            ResultSet rs = st.executeQuery("select database()");
            rs.next();
            catalog = rs.getString(1);
        }
        return catalog;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (catalog == null) {
            throw new SQLException("The catalog name may not be null", "XAE05");
        }
        try {
            this.protocol.setCatalog(catalog);
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        try (Statement stmt = this.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT @@tx_isolation");
            rs.next();
            String response = rs.getString(1);
            if (response.equals("REPEATABLE-READ")) {
                int n = 4;
                return n;
            }
            if (response.equals("READ-UNCOMMITTED")) {
                int n = 1;
                return n;
            }
            if (response.equals("READ-COMMITTED")) {
                int n = 2;
                return n;
            }
            if (response.equals("SERIALIZABLE")) {
                int n = 8;
                return n;
            }
        }
        throw ExceptionMapper.getSqlException("Could not get transaction isolation level");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.protocol.setTransactionIsolation(level);
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.warningsCleared || this.isClosed() || !this.protocol.hasWarnings()) {
            return null;
        }
        Statement st = null;
        ResultSet rs = null;
        SQLWarning last = null;
        SQLWarning first = null;
        try {
            st = this.createStatement();
            rs = st.executeQuery("show warnings");
            while (rs.next()) {
                int code = rs.getInt(2);
                String message = rs.getString(3);
                SQLWarning warning = new SQLWarning(message, ExceptionMapper.mapCodeToSqlState(code), code);
                if (first == null) {
                    first = warning;
                    last = warning;
                    continue;
                }
                last.setNextWarning(warning);
                last = warning;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return first;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    public void reenableWarnings() {
        this.warningsCleared = false;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint("unnamed");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        MariaDbSavepoint savepoint = new MariaDbSavepoint(name, this.savepointCount++);
        Statement st = this.createStatement();
        st.execute("SAVEPOINT " + ((Object)savepoint).toString());
        return savepoint;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Statement st = this.createStatement();
        st.execute("RELEASE SAVEPOINT " + savepoint.toString());
        st.close();
    }

    @Override
    public Clob createClob() throws SQLException {
        return new MariaDbClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new MariaDbBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new MariaDbClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("the value supplied for timeout is negative");
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.protocol.ping();
        }
        catch (QueryException e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        DefaultOptions.addProperty(this.protocol.getUrlParser().getHaMode(), name, value, this.options);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        DefaultOptions.addProperty(this.protocol.getUrlParser().getHaMode(), properties, this.options);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return DefaultOptions.getProperties(name, this.options);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return DefaultOptions.getProperties(this.options);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public String getUsername() {
        return this.protocol.getUsername();
    }

    public String getPassword() {
        return this.protocol.getPassword();
    }

    public String getHostname() {
        return this.protocol.getHost();
    }

    public int getPort() {
        return this.protocol.getPort();
    }

    public String getDatabase() {
        return this.protocol.getDatabase();
    }

    protected boolean getPinGlobalTxToPhysicalConnection() {
        return this.protocol.getPinGlobalTxToPhysicalConnection();
    }

    public void setHostFailed() {
        if (this.protocol.getProxy() == null) {
            this.protocol.setHostFailedWithoutProxy();
        }
    }

    public int getLowercaseTableNames() throws SQLException {
        if (this.lowercaseTableNames == -1) {
            Statement st = this.createStatement();
            ResultSet rs = st.executeQuery("select @@lower_case_table_names");
            rs.next();
            this.lowercaseTableNames = rs.getInt(1);
        }
        return this.lowercaseTableNames;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        SQLPermission sqlPermission = new SQLPermission("callAbort");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && sqlPermission != null) {
            securityManager.checkPermission(sqlPermission);
        }
        if (executor == null) {
            throw ExceptionMapper.getSqlException("Cannot abort the connection: null executor passed");
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MariaDbConnection.this.close();
                    MariaDbConnection.this.pooledConnection = null;
                }
                catch (SQLException sqle) {
                    throw new RuntimeException(sqle);
                }
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return this.protocol.getTimeout();
        }
        catch (SocketException se) {
            throw ExceptionMapper.getSqlException("Cannot retrieve the network timeout", se);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Only catalogs are supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.isClosed()) {
            throw ExceptionMapper.getSqlException("Connection.setNetworkTimeout cannot be called on a closed connection");
        }
        if (milliseconds < 0) {
            throw ExceptionMapper.getSqlException("Connection.setNetworkTimeout cannot be called with a negative timeout");
        }
        SQLPermission sqlPermission = new SQLPermission("setNetworkTimeout");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && sqlPermission != null) {
            securityManager.checkPermission(sqlPermission);
        }
        if (executor == null) {
            throw ExceptionMapper.getSqlException("Cannot set the connection timeout: null executor passed");
        }
        try {
            this.protocol.setTimeout(milliseconds);
        }
        catch (SocketException se) {
            throw ExceptionMapper.getSqlException("Cannot set the network timeout", se);
        }
    }

    protected String getServerTimezone() {
        return this.options.serverTimezone;
    }
}

