/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mariadb.jdbc.internal.packet.read.RawPacket;

public class ReadPacketFetcher {
    public static final int AVOID_CREATE_BUFFER_LENGTH = 1024;
    private final InputStream inputStream;
    private byte[] headerBuffer = new byte[4];
    private byte[] reusableBuffer = new byte[1024];

    public ReadPacketFetcher(InputStream is) {
        this.inputStream = is;
    }

    public RawPacket getRawPacket() throws IOException {
        return RawPacket.nextPacket(this.inputStream);
    }

    public ByteBuffer getReusableBuffer() throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.reusableBuffer, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (4 - remaining) + " bytes from " + 4);
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        int length = (this.reusableBuffer[0] & 0xFF) + ((this.reusableBuffer[1] & 0xFF) << 8) + ((this.reusableBuffer[2] & 0xFF) << 16);
        byte[] rawBytes = length < 1024 ? this.reusableBuffer : new byte[length];
        remaining = length;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (length - remaining) + " bytes from " + length);
            }
            off += count;
        } while ((remaining -= count) > 0);
        return ByteBuffer.wrap(rawBytes, 0, length).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void skipNextPacket() throws IOException {
        int count;
        int length;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.reusableBuffer, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (4 - remaining) + " bytes from " + 4);
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        remaining = length = (this.reusableBuffer[0] & 0xFF) + ((this.reusableBuffer[1] & 0xFF) << 8) + ((this.reusableBuffer[2] & 0xFF) << 16);
        do {
            if ((count = this.inputStream.read(this.reusableBuffer, 0, Math.min(remaining, 1024))) > 0) continue;
            throw new EOFException("unexpected end of stream, read " + (length - remaining) + " bytes from " + length);
        } while ((remaining -= count) > 0);
    }

    public RawPacket getReusableRawPacket() throws IOException {
        return RawPacket.nextPacket(this.inputStream, this.headerBuffer, this.reusableBuffer);
    }

    public void clearInputStream() throws IOException {
        int available = this.inputStream.available();
        while (available > 0) {
            available = (int)((long)available - this.inputStream.skip(available));
        }
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

