/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.AuroraProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class AuroraListener
extends MastersSlavesListener {
    public AuroraListener(UrlParser urlParser) {
        super(urlParser);
        this.masterProtocol = null;
        this.secondaryProtocol = null;
        this.lastQueryTime = System.currentTimeMillis();
    }

    @Override
    public void initializeConnection() throws QueryException {
        if (this.urlParser.getOptions().validConnectionTimeout != 0) {
            this.scheduledPing = this.executorService.scheduleWithFixedDelay(new MastersSlavesListener.PingLoop(this, this), this.urlParser.getOptions().validConnectionTimeout, this.urlParser.getOptions().validConnectionTimeout, TimeUnit.SECONDS);
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true));
        }
        catch (QueryException e) {
            this.checkInitialConnection();
            throw e;
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
        loopAddress.removeAll(blacklist.keySet());
        Collections.shuffle(loopAddress);
        LinkedList blacklistShuffle = new LinkedList(blacklist.keySet());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
        }
        if (!this.isSecondaryHostFail()) {
            HostAddress probableMaster;
            if (this.secondaryProtocol != null) {
                loopAddress.remove(this.secondaryProtocol.getHostAddress());
            }
            if (this.isMasterHostFail() && (probableMaster = this.searchByStartName(this.secondaryProtocol, loopAddress)) != null) {
                loopAddress.remove(probableMaster);
                loopAddress.add(0, probableMaster);
            }
        }
        if (searchFilter.isSearchForMaster() && this.isMasterHostFail() || searchFilter.isSearchForSlave() && this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            AuroraProtocol.loop(this, loopAddress, (Map<HostAddress, Long>)blacklist, searchFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAddress searchByStartName(Protocol secondaryProtocol, List<HostAddress> loopAddress) {
        if (!this.isSecondaryHostFail()) {
            try (AbstractQueryResult queryResult = null;){
                this.proxy.lock.lock();
                try {
                    queryResult = (SelectQueryResult)secondaryProtocol.executeQuery(new MariaDbQuery("select server_id from information_schema.replica_host_status where session_id = 'MASTER_SESSION_ID'"));
                    ((SelectQueryResult)queryResult).next();
                }
                finally {
                    this.proxy.lock.unlock();
                }
                String masterHostName = ((SelectQueryResult)queryResult).getValueObject(0).getString();
                for (int i = 0; i < loopAddress.size(); ++i) {
                    if (!loopAddress.get((int)i).host.startsWith(masterHostName)) continue;
                    HostAddress hostAddress = loopAddress.get(i);
                    return hostAddress;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkMasterStatus(SearchFilter searchFilter) throws QueryException {
        if (!this.isMasterHostFail()) {
            try {
                if (this.masterProtocol != null && !this.masterProtocol.checkIfMaster()) {
                    this.setMasterHostFail();
                    if (this.isSecondaryHostFail()) {
                        this.foundActiveSecondary(this.masterProtocol);
                    }
                    if (searchFilter != null) {
                        searchFilter.setSearchForSlave(false);
                    }
                    this.launchFailLoopIfNotlaunched(false);
                }
            }
            catch (QueryException e) {
                block24: {
                    try {
                        this.masterProtocol.ping();
                    }
                    catch (QueryException ee) {
                        this.proxy.lock.lock();
                        try {
                            this.masterProtocol.close();
                        }
                        finally {
                            this.proxy.lock.unlock();
                        }
                        if (!this.setMasterHostFail()) break block24;
                        this.addToBlacklist(this.masterProtocol.getHostAddress());
                    }
                }
                this.launchFailLoopIfNotlaunched(false);
            }
        }
        if (!this.isSecondaryHostFail()) {
            try {
                if (this.secondaryProtocol != null && this.secondaryProtocol.checkIfMaster()) {
                    this.setSecondaryHostFail();
                    if (this.isMasterHostFail()) {
                        this.foundActiveMaster(this.secondaryProtocol);
                    }
                    if (searchFilter != null) {
                        searchFilter.setSearchForMaster(false);
                    }
                    this.launchFailLoopIfNotlaunched(false);
                }
            }
            catch (QueryException e) {
                try {
                    this.secondaryProtocol.ping();
                }
                catch (Exception ee) {
                    this.proxy.lock.lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                    this.launchFailLoopIfNotlaunched(false);
                }
            }
        }
    }
}

