/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.AbstractMastersListener;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public abstract class AbstractMastersSlavesListener
extends AbstractMastersListener {
    protected AtomicInteger queriesSinceFailover = new AtomicInteger();
    private AtomicLong secondaryHostFailTimestamp = new AtomicLong();
    private AtomicBoolean secondaryHostFail = new AtomicBoolean();

    protected AbstractMastersSlavesListener(UrlParser urlParser) {
        super(urlParser);
        this.secondaryHostFail.set(true);
    }

    @Override
    public HandleErrorResult handleFailover(Method method, Object[] args) throws Throwable {
        if (this.explicitClosed) {
            throw new QueryException("Connection has been closed !");
        }
        if (this.currentProtocol.mustBeMasterConnection()) {
            if (this.setMasterHostFail()) {
                this.addToBlacklist(this.currentProtocol.getHostAddress());
                if ("executeQuery".equals(method.getName())) {
                    this.queriesSinceFailover.incrementAndGet();
                }
            }
            return this.primaryFail(method, args);
        }
        if (this.setSecondaryHostFail()) {
            this.addToBlacklist(this.currentProtocol.getHostAddress());
            if ("executeQuery".equals(method.getName())) {
                this.queriesSinceFailover.incrementAndGet();
            }
        }
        return this.secondaryFail(method, args);
    }

    @Override
    protected void resetMasterFailoverData() {
        super.resetMasterFailoverData();
        if (!this.secondaryHostFail.get()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
            this.queriesSinceFailover.set(0);
        }
    }

    protected void resetSecondaryFailoverData() {
        if (this.secondaryHostFail.compareAndSet(true, false)) {
            this.secondaryHostFailTimestamp.set(0L);
        }
        if (!this.isMasterHostFail()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
            this.queriesSinceFailover.set(0);
        }
    }

    public long getSecondaryHostFailTimestamp() {
        return this.secondaryHostFailTimestamp.get();
    }

    public boolean setSecondaryHostFail() {
        if (this.secondaryHostFail.compareAndSet(false, true)) {
            this.secondaryHostFailTimestamp.set(System.currentTimeMillis());
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    public boolean isSecondaryHostFail() {
        return this.secondaryHostFail.get();
    }

    @Override
    public boolean hasHostFail() {
        return this.isMasterHostFail() || this.isSecondaryHostFail();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail());
    }

    public abstract HandleErrorResult secondaryFail(Method var1, Object[] var2) throws Throwable;

    public abstract void foundActiveSecondary(Protocol var1) throws QueryException;
}

