/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public abstract class AbstractMastersListener
implements Listener {
    protected static Map<HostAddress, Long> blacklist = new HashMap<HostAddress, Long>();
    public final UrlParser urlParser;
    protected AtomicInteger currentConnectionAttempts = new AtomicInteger();
    protected AtomicBoolean currentReadOnlyAsked = new AtomicBoolean();
    protected AtomicBoolean isLooping = new AtomicBoolean();
    protected ScheduledFuture scheduledFailover = null;
    protected Protocol currentProtocol = null;
    protected FailoverProxy proxy;
    protected long lastRetry = 0L;
    protected boolean explicitClosed = false;
    protected ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private AtomicLong masterHostFailTimestamp = new AtomicLong();
    private AtomicBoolean masterHostFail = new AtomicBoolean();

    protected AbstractMastersListener(UrlParser urlParser) {
        this.urlParser = urlParser;
        this.masterHostFail.set(true);
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Map<HostAddress, Long> getBlacklist() {
        return blacklist;
    }

    @Override
    public HandleErrorResult handleFailover(Method method, Object[] args) throws Throwable {
        if (this.explicitClosed) {
            throw new QueryException("Connection has been closed !");
        }
        if (this.setMasterHostFail()) {
            this.addToBlacklist(this.currentProtocol.getHostAddress());
        }
        return this.primaryFail(method, args);
    }

    public void addToBlacklist(HostAddress hostAddress) {
        if (hostAddress != null && !this.explicitClosed) {
            blacklist.put(hostAddress, System.currentTimeMillis());
        }
    }

    public void resetOldsBlackListHosts() {
        long currentTime = System.currentTimeMillis();
        HashSet<HostAddress> currentBlackListkeys = new HashSet<HostAddress>(blacklist.keySet());
        for (HostAddress blackListHost : currentBlackListkeys) {
            if (blacklist.get(blackListHost) >= currentTime - (long)(this.urlParser.getOptions().loadBalanceBlacklistTimeout * 1000)) continue;
            blacklist.remove(blackListHost);
        }
    }

    protected void resetMasterFailoverData() {
        if (this.masterHostFail.compareAndSet(true, false)) {
            this.masterHostFailTimestamp.set(0L);
        }
    }

    protected void setSessionReadOnly(boolean readOnly, Protocol protocol) throws QueryException {
        if (protocol.versionGreaterOrEqual(10, 0, 0)) {
            protocol.executeQuery(new MariaDbQuery("SET SESSION TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE")));
        }
    }

    protected void stopFailover() {
        if (this.isLooping.compareAndSet(true, false) && this.scheduledFailover != null) {
            this.scheduledFailover.cancel(false);
        }
    }

    protected void launchFailLoopIfNotlaunched(boolean now) {
        if (this.isLooping.compareAndSet(false, true) && this.urlParser.getOptions().failoverLoopRetries != 0) {
            this.scheduledFailover = Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(new FailLoop(this), now ? 0L : 250L, 250L, TimeUnit.MILLISECONDS);
        }
    }

    public Protocol getCurrentProtocol() {
        return this.currentProtocol;
    }

    public long getMasterHostFailTimestamp() {
        return this.masterHostFailTimestamp.get();
    }

    public boolean setMasterHostFail() {
        if (this.masterHostFail.compareAndSet(false, true)) {
            this.masterHostFailTimestamp.set(System.currentTimeMillis());
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    public boolean isMasterHostFail() {
        return this.masterHostFail.get();
    }

    public boolean hasHostFail() {
        return this.masterHostFail.get();
    }

    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), false);
    }

    public HandleErrorResult relaunchOperation(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        HandleErrorResult handleErrorResult = new HandleErrorResult(true);
        if (method != null) {
            if ("executeQuery".equals(method.getName())) {
                String query = ((Query)args[0]).toString().toUpperCase();
                if (!query.equals("ALTER SYSTEM CRASH") && !query.startsWith("KILL")) {
                    handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                    handleErrorResult.mustThrowError = false;
                }
            } else if ("executePreparedQuery".equals(method.getName())) {
                try {
                    Method methodFailure = this.currentProtocol.getClass().getDeclaredMethod("executePreparedQueryAfterFailover", String.class, ParameterHolder[].class, Boolean.TYPE);
                    handleErrorResult.resultObject = methodFailure.invoke((Object)this.currentProtocol, args);
                    handleErrorResult.mustThrowError = false;
                }
                catch (Exception e) {}
            } else {
                handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                handleErrorResult.mustThrowError = false;
            }
        }
        return handleErrorResult;
    }

    @Override
    public Object invoke(Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.currentProtocol, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncConnection(Protocol from, Protocol to) throws QueryException {
        if (from != null) {
            this.proxy.lock.lock();
            try {
                to.setMaxRows(from.getMaxRows());
                to.setInternalMaxRows(from.getMaxRows());
                if (from.getTransactionIsolationLevel() != 0) {
                    to.setTransactionIsolation(from.getTransactionIsolationLevel());
                }
                if (from.getDatabase() != null && !"".equals(from.getDatabase()) && !from.getDatabase().equals(to.getDatabase())) {
                    to.setCatalog(from.getDatabase());
                }
                if (from.getAutocommit() != to.getAutocommit()) {
                    to.executeQuery(new MariaDbQuery("set autocommit=" + (from.getAutocommit() ? "1" : "0")));
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.currentProtocol.isClosed();
    }

    @Override
    public boolean isReadOnly() {
        return this.currentReadOnlyAsked.get();
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed;
    }

    @Override
    public void setExplicitClosed(boolean explicitClosed) {
        this.explicitClosed = explicitClosed;
    }

    @Override
    public int getRetriesAllDown() {
        return this.urlParser.getOptions().retriesAllDown;
    }

    @Override
    public boolean isAutoReconnect() {
        return this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public abstract void initializeConnection() throws QueryException;

    @Override
    public abstract void preExecute() throws QueryException;

    @Override
    public abstract void preClose() throws SQLException;

    @Override
    public abstract boolean shouldReconnect();

    @Override
    public abstract void reconnectFailedConnection(SearchFilter var1) throws QueryException;

    @Override
    public abstract void switchReadOnlyConnection(Boolean var1) throws QueryException;

    @Override
    public abstract HandleErrorResult primaryFail(Method var1, Object[] var2) throws Throwable;

    @Override
    public abstract void throwFailoverMessage(QueryException var1, boolean var2) throws QueryException;

    @Override
    public abstract void reconnect() throws QueryException;

    public static void clearBlacklist() {
        blacklist.clear();
    }

    protected class FailLoop
    implements Runnable {
        Listener listener;

        public FailLoop(Listener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            if (!AbstractMastersListener.this.explicitClosed && AbstractMastersListener.this.hasHostFail()) {
                if (this.listener.shouldReconnect()) {
                    try {
                        if (AbstractMastersListener.this.currentConnectionAttempts.get() >= AbstractMastersListener.this.urlParser.getOptions().failoverLoopRetries) {
                            throw new QueryException("Too many reconnection attempts (" + AbstractMastersListener.this.urlParser.getOptions().retriesAllDown + ")");
                        }
                        SearchFilter filter = AbstractMastersListener.this.getFilterForFailedHost();
                        filter.setUniqueLoop(true);
                        this.listener.reconnectFailedConnection(filter);
                        AbstractMastersListener.this.stopFailover();
                    }
                    catch (Exception exception) {}
                } else if (AbstractMastersListener.this.currentConnectionAttempts.get() > AbstractMastersListener.this.urlParser.getOptions().retriesAllDown) {
                    AbstractMastersListener.this.stopFailover();
                }
            } else {
                AbstractMastersListener.this.stopFailover();
            }
        }
    }
}

