/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.zip.DeflaterOutputStream;
import org.mariadb.jdbc.internal.common.MySQLCharset;
import org.mariadb.jdbc.internal.common.packet.MaxAllowedPacketException;

public class PacketOutputStream
extends OutputStream {
    private static final int MIN_COMPRESSION_SIZE = 16384;
    private static final float MIN_COMPRESSION_RATIO = 0.9f;
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final int HEADER_LENGTH = 4;
    private float increasing = 1.5f;
    public ByteBuffer buffer;
    private OutputStream outputStream;
    int seqNo;
    int lastSeq;
    int maxAllowedPacket;
    boolean checkPacketLength;
    boolean useCompression;

    protected void increase(int newCapacity) {
        this.buffer.limit(this.buffer.position());
        this.buffer.rewind();
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        newBuffer.put(this.buffer);
        this.buffer.clear();
        this.buffer = newBuffer;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public PacketOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
        this.seqNo = -1;
        this.useCompression = false;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public void startPacket(int seqNo, boolean checkPacketLength) throws IOException {
        if (this.seqNo != -1) {
            throw new IOException("Last packet not finished");
        }
        this.seqNo = seqNo;
        this.buffer.clear();
        this.checkPacketLength = checkPacketLength;
    }

    public void startPacket(int seqNo) throws IOException {
        this.startPacket(seqNo, true);
    }

    public void writeEmptyPacket(int seqNo) throws IOException {
        byte[] buf = new byte[]{0, 0, 0, (byte)seqNo};
        this.outputStream.write(buf, 0, 4);
    }

    public void sendFile(InputStream is, int seq) throws IOException {
        int len;
        this.seqNo = seq;
        this.buffer.clear();
        this.checkPacketLength = false;
        byte[] buffer = new byte[8192];
        while ((len = is.read(buffer)) > 0) {
            this.write(buffer, 0, len);
        }
        this.finishPacket();
        this.writeEmptyPacket(this.lastSeq);
    }

    public void sendStream(InputStream is, MySQLCharset charset) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = is.read(buffer)) > 0) {
            this.write(buffer, 0, len);
        }
    }

    public void sendStream(InputStream is, long readLength, MySQLCharset charset) throws IOException {
        int len;
        byte[] buffer = new byte[(int)readLength];
        while ((len = is.read(buffer, 0, (int)readLength)) > 0) {
            this.write(buffer, 0, len);
            if ((long)len < readLength) continue;
            return;
        }
    }

    public void sendStream(Reader reader, MySQLCharset charset) throws IOException {
        int len;
        char[] buffer = new char[8192];
        while ((len = reader.read(buffer)) > 0) {
            byte[] s = new String(buffer, 0, len).getBytes(charset.javaIoCharsetName);
            this.write(s, 0, s.length);
        }
    }

    public void sendStream(Reader reader, long readLength, MySQLCharset charset) throws IOException {
        int len;
        char[] buffer = new char[8192];
        while ((len = reader.read(buffer, 0, (int)readLength)) > 0) {
            byte[] s = new String(buffer, 0, len).getBytes(charset.javaIoCharsetName);
            this.write(s, 0, s.length);
            if ((long)len < readLength) continue;
            return;
        }
    }

    public void finishPacket() throws IOException {
        if (this.seqNo == -1) {
            throw new AssertionError((Object)"Packet not started");
        }
        this.internalFlush();
        this.buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
        this.lastSeq = this.seqNo;
        this.seqNo = -1;
    }

    private int maxPacketSize() {
        if (this.maxAllowedPacket > 0) {
            return Math.min(this.maxAllowedPacket - 1, 0xFFFFFF);
        }
        return 0xFFFFFF;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.seqNo == -1) {
            throw new AssertionError((Object)"Use PacketOutputStream.startPacket() before write()");
        }
        while (len > this.buffer.remaining()) {
            int newCapacity = Math.max(len + this.buffer.position(), (int)((float)this.buffer.capacity() * this.increasing));
            this.increase(newCapacity);
        }
        this.buffer.put(b, 0, len);
    }

    @Override
    public void flush() throws IOException {
        throw new AssertionError((Object)"Do not call flush() on PacketOutputStream. use finishPacket() instead.");
    }

    private void internalFlush() throws IOException {
        this.buffer.flip();
        if (this.buffer.limit() > 0) {
            this.splitPacket();
        }
        this.buffer.clear();
    }

    private void splitPacket() throws IOException {
        int maxPacketSize = this.maxPacketSize();
        if (this.checkPacketLength && this.maxAllowedPacket > 0 && this.buffer.limit() > this.maxAllowedPacket - 1) {
            this.seqNo = -1;
            throw new MaxAllowedPacketException("max_allowed_packet exceeded. packet size " + this.buffer.limit() + " is > to max_allowed_packet = " + (this.maxAllowedPacket - 1), this.seqNo != 0);
        }
        byte[] bufferBytes = new byte[]{};
        int notCompressPosition = 0;
        int expectedPacketSize = this.buffer.limit() + 4 * (this.buffer.limit() / maxPacketSize + 1);
        if (this.useCompression) {
            bufferBytes = new byte[expectedPacketSize];
        }
        while (notCompressPosition < expectedPacketSize) {
            int length = this.buffer.remaining();
            if (this.buffer.remaining() > maxPacketSize) {
                length = maxPacketSize;
            }
            if (this.useCompression) {
                bufferBytes[notCompressPosition++] = (byte)(length & 0xFF);
                bufferBytes[notCompressPosition++] = (byte)(length >>> 8);
                bufferBytes[notCompressPosition++] = (byte)(length >>> 16);
                bufferBytes[notCompressPosition++] = (byte)this.seqNo++;
            } else {
                byte[] header = new byte[]{(byte)(length & 0xFF), (byte)(length >>> 8), (byte)(length >>> 16), (byte)this.seqNo++};
                this.outputStream.write(header);
                notCompressPosition += 4;
            }
            if (length <= 0) continue;
            if (this.useCompression) {
                this.buffer.get(bufferBytes, notCompressPosition, length);
                notCompressPosition += length;
                continue;
            }
            if (this.buffer.hasArray()) {
                this.outputStream.write(this.buffer.array(), this.buffer.position(), length);
                this.buffer.position(this.buffer.position() + length);
            } else {
                bufferBytes = new byte[length];
                this.buffer.get(bufferBytes, 0, length);
                this.outputStream.write(bufferBytes, 0, length);
            }
            notCompressPosition += length;
            this.outputStream.flush();
        }
        if (this.useCompression) {
            this.seqNo = 0;
            int position = 0;
            while (position - notCompressPosition < 0) {
                int packetLength = Math.min(notCompressPosition - position, maxPacketSize);
                boolean compressedPacketSend = false;
                if (packetLength > 16384) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DeflaterOutputStream deflater = new DeflaterOutputStream(baos);
                    deflater.write(bufferBytes, position, packetLength);
                    deflater.finish();
                    deflater.close();
                    byte[] compressedBytes = baos.toByteArray();
                    baos.close();
                    if (compressedBytes.length < (int)(0.9f * (float)packetLength)) {
                        int compressedLength = compressedBytes.length;
                        this.writeCompressedHeader(compressedLength, packetLength, this.outputStream);
                        this.outputStream.write(compressedBytes, 0, compressedLength);
                        compressedPacketSend = true;
                    }
                }
                if (!compressedPacketSend) {
                    this.writeCompressedHeader(packetLength, 0, this.outputStream);
                    this.outputStream.write(bufferBytes, position, packetLength);
                }
                position += packetLength;
                this.outputStream.flush();
            }
        }
    }

    private void writeCompressedHeader(int packetLength, int initialLength, OutputStream outputStream) throws IOException {
        byte[] header = new byte[]{(byte)(packetLength & 0xFF), (byte)(packetLength >> 8 & 0xFF), (byte)(packetLength >> 16 & 0xFF), (byte)this.seqNo++, (byte)(initialLength & 0xFF), (byte)(initialLength >> 8 & 0xFF), (byte)(initialLength >> 16 & 0xFF)};
        outputStream.write(header);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] a = new byte[]{(byte)b};
        this.write(a);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.buffer = null;
    }

    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
    }

    public PacketOutputStream assureBufferCapacity(int len) {
        while (len > this.buffer.remaining()) {
            int newCapacity = Math.max(len + this.buffer.position(), (int)((float)this.buffer.capacity() * this.increasing));
            this.increase(newCapacity);
        }
        return this;
    }

    public PacketOutputStream writeByte(byte theByte) {
        this.assureBufferCapacity(1);
        this.buffer.put(theByte);
        return this;
    }

    public PacketOutputStream writeBytes(byte theByte, int count) {
        for (int i = 0; i < count; ++i) {
            this.writeByte(theByte);
        }
        return this;
    }

    public PacketOutputStream writeByteArray(byte[] bytes) {
        this.assureBufferCapacity(bytes.length);
        this.buffer.put(bytes);
        return this;
    }

    public PacketOutputStream writeByteArrayLength(byte[] bytes) {
        this.assureBufferCapacity(bytes.length + 9);
        this.writeFieldLength(bytes.length);
        this.buffer.put(bytes);
        return this;
    }

    public PacketOutputStream writeString(String str) {
        byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
        return this.writeByteArray(strBytes);
    }

    public PacketOutputStream writeShort(short theShort) {
        this.assureBufferCapacity(2);
        this.buffer.putShort(theShort);
        return this;
    }

    public PacketOutputStream writeInt(int theInt) {
        this.assureBufferCapacity(4);
        this.buffer.putInt(theInt);
        return this;
    }

    public PacketOutputStream writeLong(long theLong) {
        this.assureBufferCapacity(8);
        this.buffer.putLong(theLong);
        return this;
    }

    public PacketOutputStream writeFieldLength(long length) {
        if (length < 251L) {
            this.buffer.put((byte)length);
        } else if (length < 65536L) {
            this.assureBufferCapacity(3);
            this.buffer.put((byte)-4);
            this.buffer.putShort((short)length);
        } else if (length < 0x1000000L) {
            this.assureBufferCapacity(4);
            this.buffer.put((byte)-3);
            this.buffer.put((byte)(length & 0xFFL));
            this.buffer.put((byte)(length >>> 8));
            this.buffer.put((byte)(length >>> 16));
        } else {
            this.assureBufferCapacity(9);
            this.buffer.put((byte)-2);
            this.buffer.putLong(length);
        }
        return this;
    }

    public PacketOutputStream writeStringLength(String str) {
        byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
        this.assureBufferCapacity(strBytes.length + 9);
        this.writeFieldLength(strBytes.length);
        this.buffer.put(strBytes);
        return this;
    }

    public PacketOutputStream writeTimestampLength(Calendar calendar, Timestamp ts) {
        this.assureBufferCapacity(12);
        this.buffer.put((byte)11);
        this.buffer.putShort((short)calendar.get(1));
        this.buffer.put((byte)(calendar.get(2) + 1 & 0xFF));
        this.buffer.put((byte)(calendar.get(5) & 0xFF));
        this.buffer.put((byte)calendar.get(11));
        this.buffer.put((byte)calendar.get(12));
        this.buffer.put((byte)calendar.get(13));
        this.buffer.putInt(ts.getNanos() / 1000);
        return this;
    }

    public PacketOutputStream writeDateLength(Calendar calendar) {
        this.assureBufferCapacity(8);
        this.buffer.put((byte)7);
        this.buffer.putShort((short)calendar.get(1));
        this.buffer.put((byte)(calendar.get(2) + 1 & 0xFF));
        this.buffer.put((byte)(calendar.get(5) & 0xFF));
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
        return this;
    }

    public PacketOutputStream writeTimeLength(Calendar calendar, boolean fractionalSeconds) {
        if (fractionalSeconds) {
            this.assureBufferCapacity(13);
            this.buffer.put((byte)12);
            this.buffer.put((byte)0);
            this.buffer.putInt(0);
            this.buffer.put((byte)calendar.get(11));
            this.buffer.put((byte)calendar.get(12));
            this.buffer.put((byte)calendar.get(13));
            this.buffer.putInt(calendar.get(14) * 1000);
        } else {
            this.assureBufferCapacity(9);
            this.buffer.put((byte)8);
            this.buffer.put((byte)0);
            this.buffer.putInt(0);
            this.buffer.put((byte)calendar.get(11));
            this.buffer.put((byte)calendar.get(12));
            this.buffer.put((byte)calendar.get(13));
        }
        return this;
    }
}

