/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLResultSet;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.queryresults.ModifyQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.mysql.Protocol;

public class MySQLStatement
implements Statement {
    private static volatile Timer timer;
    protected final Protocol protocol;
    protected MySQLConnection connection;
    protected QueryResult queryResult;
    protected TimerTask timerTask;
    protected boolean isRewriteable = true;
    protected String firstRewrite = null;
    protected ResultSet batchResultSet = null;
    protected ReentrantReadWriteLock stLock = new ReentrantReadWriteLock();
    boolean isClosed;
    boolean isTimedout;
    volatile boolean executing;
    List<Query> batchQueries;
    Queue<Object> cachedResultSets;
    private boolean warningsCleared;
    private int queryTimeout;
    private boolean escapeProcessing;
    private int fetchSize;
    private boolean wasStreaming = false;
    private int maxRows;

    public MySQLStatement(MySQLConnection connection) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.escapeProcessing = true;
        this.cachedResultSets = new LinkedList<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Timer getTimer() {
        Timer result = timer;
        if (result != null) return result;
        Class<MySQLStatement> clazz = MySQLStatement.class;
        synchronized (MySQLStatement.class) {
            result = timer;
            if (result != null) return result;
            timer = result = new Timer("MariaDB-JDBC-Timer", true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void unloadDriver() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public boolean isStreaming() {
        this.stLock.readLock().lock();
        try {
            boolean bl = this.fetchSize == Integer.MIN_VALUE;
            return bl;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    private void setTimerTask() {
        assert (this.timerTask == null);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MySQLStatement.this.isTimedout = true;
                    MySQLStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        MySQLStatement.getTimer().schedule(this.timerTask, this.queryTimeout * 1000);
    }

    void executeQueryProlog() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("execute() is called on closed statement");
        }
        if (this.protocol.isExplicitClosed()) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (this.protocol.getProxy() == null) {
            this.checkReconnectWithoutProxy();
        }
        this.protocol.closeIfActiveResult();
        if (this.wasStreaming && this.protocol.hasMoreResults()) {
            while (this.getMoreResults(true)) {
            }
        }
        this.cachedResultSets.clear();
        ((MySQLConnection)this.getConnection()).reenableWarnings();
        try {
            this.protocol.setMaxRows(this.maxRows);
        }
        catch (QueryException qe) {
            SQLExceptionMapper.throwException(qe, this.connection, this);
        }
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    protected void cacheMoreResults() {
        this.wasStreaming = this.isStreaming();
        if (this.isStreaming()) {
            return;
        }
        QueryResult saveResult = this.queryResult;
        try {
            while (this.protocol.hasMoreResults()) {
                this.getMoreResults(false);
                this.cachedResultSets.add(this.queryResult);
            }
        }
        catch (SQLException e) {
            this.cachedResultSets.add(e);
        }
        this.queryResult = saveResult;
    }

    private void executeQueryEpilog(QueryException e, Query query) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            e = new QueryException("Query timed out", 1317, "JZ0002", e);
        }
        if (e == null) {
            return;
        }
        if (this.protocol.getOptions().dumpQueriesOnException || e.getErrorCode() == 1064) {
            String queryString = query.toString();
            if (queryString.length() > 4096) {
                queryString = queryString.substring(0, 4096);
            }
            e.setMessage(e.getMessage() + "\nQuery is:\n" + queryString);
        }
        if (e.getSqlState() != null && e.getSqlState().startsWith("08")) {
            this.close();
        }
        SQLExceptionMapper.throwException(e, this.connection, this);
    }

    /*
     * Exception decompiling
     */
    protected boolean execute(Query query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean execute(List<Query> queries, boolean isRewritable, int rewriteOffset) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ResultSet executeQuery(Query query) throws SQLException {
        if (this.execute(query)) {
            return this.getResultSet();
        }
        return MySQLResultSet.EMPTY;
    }

    protected int executeUpdate(Query query) throws SQLException {
        if (this.execute(query)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    private Query stringToQuery(String queryString) throws SQLException {
        if (this.escapeProcessing) {
            queryString = Utils.nativeSQL(queryString, this.connection.noBackslashEscapes);
        }
        return new MySQLQuery(queryString);
    }

    @Override
    public boolean execute(String queryString) throws SQLException {
        return this.execute(this.stringToQuery(queryString));
    }

    @Override
    public int executeUpdate(String queryString) throws SQLException {
        return this.executeUpdate(this.stringToQuery(queryString));
    }

    @Override
    public ResultSet executeQuery(String queryString) throws SQLException {
        return this.executeQuery(this.stringToQuery(queryString));
    }

    @Override
    public void close() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
                this.queryResult = null;
            }
            this.cachedResultSets.clear();
            if (this.isStreaming()) {
                this.connection.lock.writeLock().lock();
                try {
                    while (this.getMoreResults(true)) {
                    }
                }
                finally {
                    this.connection.lock.writeLock().unlock();
                }
            }
            this.isClosed = true;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.stLock.readLock().lock();
        try {
            int n = this.maxRows;
            return n;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows is negative");
        }
        this.stLock.writeLock().lock();
        this.maxRows = max;
        this.stLock.writeLock().unlock();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stLock.writeLock().lock();
        this.escapeProcessing = enable;
        this.stLock.writeLock().unlock();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.stLock.readLock().lock();
        try {
            int n = this.queryTimeout;
            return n;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.stLock.writeLock().lock();
        this.queryTimeout = seconds;
        this.stLock.writeLock().unlock();
    }

    public void setLocalInfileInputStream(InputStream inputStream) {
        this.stLock.writeLock().lock();
        try {
            this.protocol.setLocalInfileInputStream(inputStream);
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.stLock.readLock().lock();
        try {
            if (!this.warningsCleared) {
                SQLWarning sQLWarning = this.connection.getWarnings();
                return sQLWarning;
            }
            SQLWarning sQLWarning = null;
            return sQLWarning;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stLock.writeLock().lock();
        this.warningsCleared = true;
        this.stLock.writeLock().unlock();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.stLock.readLock().lock();
        try {
            if (this.batchResultSet != null) {
                ResultSet resultSet = this.batchResultSet;
                return resultSet;
            }
            if (this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
                long insertId = ((ModifyQueryResult)this.queryResult).getInsertId();
                if (insertId == 0L) {
                    ResultSet resultSet = MySQLResultSet.createEmptyGeneratedKeysResultSet(this.connection);
                    return resultSet;
                }
                int updateCount = this.getUpdateCount();
                ResultSet resultSet = MySQLResultSet.createGeneratedKeysResultSet(insertId, updateCount, this.connection);
                return resultSet;
            }
            MySQLResultSet mySQLResultSet = MySQLResultSet.EMPTY;
            return mySQLResultSet;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.stLock.readLock().lock();
        try {
            boolean bl = this.isClosed;
            return bl;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return null;
        }
        return new MySQLResultSet(this.queryResult, this, this.protocol);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return -1;
        }
        return (int)((ModifyQueryResult)this.queryResult).getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getMoreResults(boolean streaming) throws SQLException {
        this.stLock.writeLock().lock();
        this.connection.lock.writeLock().lock();
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
            }
            this.queryResult = this.protocol.getMoreResults(streaming);
            if (this.queryResult == null) {
                boolean bl = false;
                return bl;
            }
            this.warningsCleared = false;
            this.connection.reenableWarnings();
            boolean bl = true;
            return bl;
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this.connection, this);
            boolean bl = false;
            return bl;
        }
        finally {
            this.connection.lock.writeLock().unlock();
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.stLock.writeLock().lock();
        this.stLock.writeLock().lock();
        try {
            if (!this.isStreaming()) {
                if (this.cachedResultSets.isEmpty()) {
                    this.queryResult = null;
                    boolean bl = false;
                    return bl;
                }
                Object o = this.cachedResultSets.remove();
                if (o instanceof SQLException) {
                    throw (SQLException)o;
                }
                this.queryResult = (QueryResult)o;
                boolean bl = true;
                return bl;
            }
            boolean bl = this.getMoreResults(false);
            return bl;
        }
        finally {
            this.stLock.writeLock().unlock();
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.stLock.readLock().lock();
        try {
            int n = this.fetchSize;
            return n;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        this.stLock.writeLock().lock();
        this.fetchSize = rows;
        this.stLock.writeLock().unlock();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.stLock.writeLock().lock();
        try {
            if (this.batchQueries == null) {
                this.batchQueries = new ArrayList<Query>();
            }
            this.isInsertRewriteable(sql);
            this.batchQueries.add(new MySQLQuery(sql));
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    protected void isInsertRewriteable(String sql) {
        this.stLock.writeLock().lock();
        try {
            if (!this.isRewriteable) {
                return;
            }
            int index = this.getInsertIncipit(sql);
            if (index == -1) {
                this.isRewriteable = false;
                return;
            }
            if (this.firstRewrite == null) {
                this.firstRewrite = sql.substring(0, index);
            }
            sql.startsWith(this.firstRewrite);
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    protected int getInsertIncipit(String sql) {
        String sqlUpper = sql.toUpperCase();
        if (!sqlUpper.startsWith("INSERT") && !sqlUpper.startsWith("/*CLIENT*/ INSERT")) {
            return -1;
        }
        int idx = sqlUpper.indexOf(" VALUE");
        int startBracket = sqlUpper.indexOf("(", idx);
        int endBracket = sqlUpper.indexOf(")", startBracket);
        int semicolonPos = sqlUpper.indexOf(59);
        while (semicolonPos > -1) {
            if (semicolonPos < startBracket || semicolonPos > endBracket) {
                return -1;
            }
            semicolonPos = sqlUpper.indexOf(59, semicolonPos + 1);
        }
        return startBracket;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
        this.firstRewrite = null;
        this.isRewriteable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            int i;
            if (this.batchQueries == null || this.batchQueries.size() == 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int[] ret = new int[this.batchQueries.size()];
            MySQLResultSet rs = null;
            this.connection.lock.writeLock().lock();
            try {
                if (this.getProtocol().getOptions().allowMultiQueries || this.getProtocol().getOptions().rewriteBatchedStatements) {
                    int size = this.batchQueries.size();
                    boolean rewrittenBatch = this.isRewriteable && this.getProtocol().getOptions().rewriteBatchedStatements;
                    MySQLStatement ps = (MySQLStatement)this.connection.createStatement();
                    ps.execute(this.batchQueries, rewrittenBatch, rewrittenBatch ? this.firstRewrite.length() : 0);
                    int[] nArray = rewrittenBatch ? this.getUpdateCountsForReWrittenBatch(ps, size) : this.getUpdateCounts(ps, size);
                    return nArray;
                }
                for (i = 0; i < this.batchQueries.size(); ++i) {
                    this.execute(this.batchQueries.get(i));
                    int updateCount = this.getUpdateCount();
                    ret[i] = updateCount == -1 ? -2 : updateCount;
                    rs = i == 0 ? (MySQLResultSet)this.getGeneratedKeys() : rs.joinResultSets((MySQLResultSet)this.getGeneratedKeys());
                }
            }
            catch (SQLException sqle) {
                throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, i), (Throwable)sqle);
            }
            finally {
                this.connection.lock.writeLock().unlock();
                this.clearBatch();
            }
            this.batchResultSet = rs;
            int[] nArray = ret;
            return nArray;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    protected int[] getUpdateCounts(Statement statement, int size) throws SQLException {
        int[] result = new int[size];
        for (int count = 0; count < size; ++count) {
            int updateCount = statement.getUpdateCount();
            result[count] = updateCount == -1 ? -2 : updateCount;
            statement.getMoreResults();
        }
        return result;
    }

    protected int[] getUpdateCountsForReWrittenBatch(Statement statement, int size) throws SQLException {
        int[] result = new int[size];
        int resultVal = statement.getUpdateCount() == size ? 1 : -2;
        for (int count = 0; count < size; ++count) {
            result[count] = resultVal;
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    private void checkReconnectWithoutProxy() throws SQLException {
        if (this.protocol.shouldReconnectWithoutProxy()) {
            try {
                this.protocol.connectWithoutProxy();
            }
            catch (QueryException qe) {
                SQLExceptionMapper.throwException(qe, this.connection, this);
            }
        }
    }
}

