/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.mariadb.jdbc.AbstractMySQLPrepareStatement;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLParameterMetaData;
import org.mariadb.jdbc.MySQLResultSet;
import org.mariadb.jdbc.MySQLResultSetMetaData;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.common.queryresults.PrepareResult;
import org.mariadb.jdbc.internal.mysql.MySQLType;
import org.mariadb.jdbc.internal.mysql.Protocol;

public class MySQLServerPreparedStatement
extends AbstractMySQLPrepareStatement {
    String sql;
    PrepareResult prepareResult;
    MySQLConnection connection;
    boolean returnTableAlias = false;
    int parameterCount;
    MySQLResultSetMetaData metadata;
    MySQLParameterMetaData parameterMetaData;
    ParameterHolder[] currentParameterHolder;
    List<ParameterHolder[]> queryParameters = new ArrayList<ParameterHolder[]>();
    private boolean useFractionalSeconds;

    public MySQLServerPreparedStatement(MySQLConnection connection, String sql) throws SQLException {
        super(connection);
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.connection = connection;
        this.sql = sql;
        this.prepare(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(String sql) throws SQLException {
        this.stLock.writeLock().lock();
        try {
            Protocol protocol = this.connection.getProtocol();
            this.connection.lock.writeLock().lock();
            try {
                if (protocol.hasUnreadData()) {
                    SQLExceptionMapper.throwException(new QueryException("There is an open result set on the current connection, which must be closed prior to executing a query"), this.connection, this);
                }
                this.prepareResult = protocol.prepare(sql);
                this.parameterCount = this.prepareResult.parameters.length;
                if (this.parameterCount > 0) {
                    this.currentParameterHolder = new ParameterHolder[this.prepareResult.parameters.length];
                }
            }
            finally {
                this.connection.lock.writeLock().unlock();
            }
            this.returnTableAlias = protocol.getOptions().useOldAliasMetadataBehavior;
            this.metadata = new MySQLResultSetMetaData(this.prepareResult.columns, protocol.getDatatypeMappingFlags(), this.returnTableAlias);
            this.parameterMetaData = new MySQLParameterMetaData(this.prepareResult.columns);
        }
        catch (QueryException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SQLExceptionMapper.throwException(e, this.connection, this);
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        try {
            this.stLock.writeLock().lock();
            this.currentParameterHolder[parameterIndex - 1] = holder;
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw SQLExceptionMapper.getSQLException("Could not set parameter at position " + parameterIndex + ", parameter length is " + this.parameterCount);
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        for (int i = 0; i < this.parameterCount; ++i) {
            if (this.currentParameterHolder[i] != null) continue;
            SQLExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
        }
        this.stLock.writeLock().lock();
        try {
            this.queryParameters.add((ParameterHolder[])this.currentParameterHolder.clone());
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public void clearBatch() {
        this.stLock.writeLock().lock();
        try {
            this.queryParameters = new ArrayList<ParameterHolder[]>();
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.stLock.readLock().lock();
        try {
            MySQLParameterMetaData mySQLParameterMetaData = this.parameterMetaData;
            return mySQLParameterMetaData;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.stLock.readLock().lock();
        try {
            MySQLResultSetMetaData mySQLResultSetMetaData = this.metadata;
            return mySQLResultSetMetaData;
        }
        finally {
            this.stLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            int i;
            if (this.parameterCount > 0 && this.queryParameters.size() == 0) {
                throw SQLExceptionMapper.getSQLException("No Parameters set. The command addBatch() must have been set");
            }
            int[] ret = new int[this.queryParameters.size()];
            MySQLResultSet rs = null;
            this.connection.lock.writeLock().lock();
            MySQLType[] parameterTypeHeader = new MySQLType[this.parameterCount];
            try {
                for (i = 0; i < this.queryParameters.size(); ++i) {
                    this.executeInternal(this.queryParameters.get(i), parameterTypeHeader);
                    int updateCount = this.getUpdateCount();
                    ret[i] = updateCount == -1 ? -2 : updateCount;
                    rs = i == 0 ? (MySQLResultSet)this.getGeneratedKeys() : rs.joinResultSets((MySQLResultSet)this.getGeneratedKeys());
                }
            }
            catch (SQLException sqle) {
                this.clearBatch();
                throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, i), (Throwable)sqle);
            }
            finally {
                this.connection.lock.writeLock().unlock();
                this.clearBatch();
            }
            this.batchResultSet = rs;
            int[] nArray = ret;
            return nArray;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean executeInternal(ParameterHolder[] parameters, MySQLType[] parameterTypeHeader) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeQueryEpilog(QueryException e, String sql) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            e = new QueryException("Query timed out", 1317, "JZ0002", e);
        }
        if (e == null) {
            return;
        }
        if (this.protocol.getOptions().dumpQueriesOnException || e.getErrorCode() == 1064) {
            String queryString = new String(sql);
            if (queryString.length() > 4096) {
                queryString = queryString.substring(0, 4096);
            }
            e.setMessage(e.getMessage() + "\nQuery is:\n" + queryString);
        }
        if (e.getSqlState() != null && e.getSqlState().startsWith("08")) {
            this.close();
        }
        SQLExceptionMapper.throwException(e, this.connection, this);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            this.currentParameterHolder = new ParameterHolder[this.prepareResult.parameters.length];
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder[i] != null) continue;
                SQLExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
            }
            MySQLResultSet rs = null;
            boolean result = false;
            this.connection.lock.writeLock().lock();
            try {
                result = this.executeInternal(this.currentParameterHolder, new MySQLType[this.parameterCount]);
                rs = (MySQLResultSet)this.getGeneratedKeys();
            }
            catch (SQLException sqle) {
                throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new int[]{0}, (Throwable)sqle);
            }
            finally {
                this.connection.lock.writeLock().unlock();
                this.clearBatch();
            }
            this.batchResultSet = rs;
            boolean bl = result;
            return bl;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
                this.queryResult = null;
            }
            this.cachedResultSets.clear();
            if (this.protocol.isConnected()) {
                try {
                    this.protocol.releasePrepareStatement(this.sql, this.prepareResult.statementId);
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
            }
            if (this.isStreaming()) {
                this.connection.lock.writeLock().lock();
                try {
                    while (this.getMoreResults(true)) {
                    }
                }
                finally {
                    this.connection.lock.writeLock().unlock();
                }
            }
            super.close();
            this.isClosed = true;
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sql + "'");
        if (this.parameterCount > 0) {
            sb.append(", parameters : [");
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.currentParameterHolder[i].toString());
                }
                if (i == this.parameterCount - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

