/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import org.mariadb.jdbc.AbstractMySQLPrepareStatement;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLServerPreparedStatement;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.query.IllegalParameterException;
import org.mariadb.jdbc.internal.common.query.MySQLClientParameterizedQuery;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;

public class MySQLClientPreparedStatement
extends AbstractMySQLPrepareStatement {
    private final String sqlQuery;
    boolean parametersCleared;
    private MySQLClientParameterizedQuery dQuery;
    private boolean useFractionalSeconds;
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MySQLClientPreparedStatement(MySQLConnection connection, String sql) throws SQLException {
        super(connection);
        this.sqlQuery = sql;
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.isInsertRewriteable(sql);
        this.dQuery = new MySQLClientParameterizedQuery(Utils.nativeSQL(sql, connection.noBackslashEscapes), connection.noBackslashEscapes, this.isRewriteable ? this.firstRewrite.length() : -1);
        this.parametersCleared = true;
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.dQuery);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.dQuery);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.dQuery);
    }

    @Override
    public void addBatch() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            this.checkBatchFields();
            this.batchQueries.add(this.dQuery.cloneQuery());
            this.isInsertRewriteable(this.dQuery.getQuery());
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.stLock.writeLock().lock();
        try {
            this.checkBatchFields();
            this.isInsertRewriteable(sql);
            this.batchQueries.add(new MySQLQuery(sql));
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    private void checkBatchFields() {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList();
        }
    }

    @Override
    public void clearBatch() {
        this.stLock.writeLock().lock();
        try {
            if (this.batchQueries != null) {
                this.batchQueries.clear();
            }
            this.firstRewrite = null;
            this.isRewriteable = true;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            ResultSet rs = this.getResultSet();
            if (rs != null) {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                return resultSetMetaData;
            }
            if (this.resultSetMetaData == null) {
                MySQLServerPreparedStatement ssps = new MySQLServerPreparedStatement(this.connection, this.sqlQuery);
                ssps.close();
                this.resultSetMetaData = ssps.getMetaData();
                this.parameterMetaData = ssps.getParameterMetaData();
            }
            ResultSetMetaData resultSetMetaData = this.resultSetMetaData;
            return resultSetMetaData;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        this.stLock.writeLock().lock();
        try {
            this.dQuery.setParameter(parameterIndex - 1, holder);
            this.parametersCleared = false;
        }
        catch (IllegalParameterException e) {
            throw SQLExceptionMapper.getSQLException("Could not set parameter", e);
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.stLock.writeLock().lock();
        try {
            if (this.parameterMetaData == null) {
                MySQLServerPreparedStatement ssps = new MySQLServerPreparedStatement(this.connection, this.sqlQuery);
                ssps.close();
                this.resultSetMetaData = ssps.getMetaData();
                this.parameterMetaData = ssps.getParameterMetaData();
            }
            ParameterMetaData parameterMetaData = this.parameterMetaData;
            return parameterMetaData;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public void clearParameters() {
        this.stLock.writeLock().lock();
        try {
            this.dQuery.clearParameters();
            this.parametersCleared = true;
        }
        finally {
            this.stLock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        this.stLock.writeLock().lock();
        this.connection.lock.writeLock().lock();
        try {
            super.close();
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.isClosed = false;
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.connection.lock.writeLock().unlock();
            this.stLock.writeLock().unlock();
        }
    }

    public String toString() {
        return this.dQuery.toString();
    }
}

