/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.listener.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.mysql.HandleErrorResult;
import org.mariadb.jdbc.internal.mysql.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.mysql.Protocol;
import org.mariadb.jdbc.internal.mysql.listener.AbstractMastersSlavesListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;

public class MastersSlavesListener
extends AbstractMastersSlavesListener {
    private static final Logger log = Logger.getLogger(MastersSlavesListener.class.getName());
    protected Protocol masterProtocol = null;
    protected Protocol secondaryProtocol = null;
    protected long lastQueryTime = System.currentTimeMillis();
    protected ScheduledFuture scheduledPing = null;

    public MastersSlavesListener(JDBCUrl jdbcUrl) {
        super(jdbcUrl);
    }

    @Override
    public void initializeConnection() throws QueryException {
        if (this.jdbcUrl.getOptions().validConnectionTimeout != 0) {
            this.scheduledPing = this.executorService.scheduleWithFixedDelay(new PingLoop(this), this.jdbcUrl.getOptions().validConnectionTimeout, this.jdbcUrl.getOptions().validConnectionTimeout, TimeUnit.SECONDS);
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true));
        }
        catch (QueryException e) {
            log.log(Level.FINEST, "initializeConnection failed", e);
            this.checkInitialConnection();
            this.throwFailoverMessage(e, false);
        }
    }

    protected void checkInitialConnection() {
        if (this.masterProtocol != null && !this.masterProtocol.isConnected()) {
            this.setMasterHostFail();
        }
        if (this.secondaryProtocol != null && !this.secondaryProtocol.isConnected()) {
            this.setSecondaryHostFail();
        }
        this.launchFailLoopIfNotlaunched(false);
    }

    @Override
    public void preClose() throws SQLException {
        this.setExplicitClosed(true);
        log.finest("preClose connections");
        this.proxy.lock.writeLock().lock();
        try {
            if (this.masterProtocol != null && this.masterProtocol.isConnected()) {
                this.masterProtocol.close();
            }
            if (this.secondaryProtocol != null && this.secondaryProtocol.isConnected()) {
                this.secondaryProtocol.close();
            }
        }
        finally {
            this.proxy.lock.writeLock().unlock();
            if (this.scheduledPing != null) {
                this.scheduledPing.cancel(true);
            }
            if (this.scheduledFailover != null) {
                this.scheduledFailover.cancel(true);
                this.isLooping.set(false);
            }
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.finest("executorService interrupted");
            }
        }
        log.finest("preClose connections end");
    }

    @Override
    public void preExecute() throws QueryException {
        if (this.currentProtocol != null && (this.currentProtocol.isClosed() || !this.currentReadOnlyAsked.get() && !this.currentProtocol.isMasterConnection())) {
            this.queriesSinceFailover.incrementAndGet();
            if (!this.isExplicitClosed() && this.jdbcUrl.getOptions().autoReconnect) {
                try {
                    this.reconnectFailedConnection(new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail(), !this.currentReadOnlyAsked.get(), this.currentReadOnlyAsked.get()));
                }
                catch (QueryException queryException) {}
            } else {
                throw new QueryException("Connection is closed", -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState());
            }
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            this.queriesSinceFailover.incrementAndGet();
        }
        if (this.jdbcUrl.getOptions().validConnectionTimeout != 0) {
            this.lastQueryTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean shouldReconnect() {
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            if (this.currentConnectionAttempts.get() > this.jdbcUrl.getOptions().retriesAllDown) {
                return false;
            }
            long now = System.currentTimeMillis();
            if (this.isMasterHostFail()) {
                if (this.jdbcUrl.getOptions().queriesBeforeRetryMaster > 0 && this.queriesSinceFailover.get() >= this.jdbcUrl.getOptions().queriesBeforeRetryMaster) {
                    return true;
                }
                if (this.jdbcUrl.getOptions().secondsBeforeRetryMaster > 0 && now - this.getMasterHostFailTimestamp() >= (long)(this.jdbcUrl.getOptions().secondsBeforeRetryMaster * 1000)) {
                    return true;
                }
            }
            if (this.isSecondaryHostFail() && this.jdbcUrl.getOptions().secondsBeforeRetryMaster > 0 && now - this.getSecondaryHostFailTimestamp() >= (long)(this.jdbcUrl.getOptions().secondsBeforeRetryMaster * 1000)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        if (log.isLoggable(Level.FINEST)) {
            log.fine("search connection searchFilter=" + searchFilter);
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.jdbcUrl.getHostAddresses());
        loopAddress.removeAll(blacklist.keySet());
        Collections.shuffle(loopAddress);
        LinkedList blacklistShuffle = new LinkedList(blacklist.keySet());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            loopAddress.remove(this.secondaryProtocol.getHostAddress());
        }
        if (searchFilter.isSearchForMaster() && this.isMasterHostFail() || searchFilter.isSearchForSlave() && this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            MastersSlavesProtocol.loop(this, loopAddress, (Map<HostAddress, Long>)blacklist, searchFilter);
        }
    }

    @Override
    public void foundActiveMaster(Protocol newMasterProtocol) {
        if (this.isExplicitClosed()) {
            newMasterProtocol.close();
            return;
        }
        log.finest("log $$1 " + this.proxy.lock.getReadLockCount() + " " + this.proxy.lock.getWriteHoldCount());
        this.proxy.lock.writeLock().lock();
        try {
            log.finest("log $$2 " + this.proxy.lock.getReadLockCount() + " " + this.proxy.lock.getWriteHoldCount());
            if (this.masterProtocol != null && !this.masterProtocol.isClosed()) {
                this.masterProtocol.close();
            }
            this.masterProtocol = (MastersSlavesProtocol)newMasterProtocol;
            if (!this.currentReadOnlyAsked.get() || this.isSecondaryHostFail()) {
                try {
                    this.syncConnection(this.currentProtocol, this.masterProtocol);
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Some error append during connection parameter synchronisation : ", e);
                }
                log.finest("switching current connection to master connection");
                this.currentProtocol = this.masterProtocol;
            }
            if (log.isLoggable(Level.FINE)) {
                if (this.getMasterHostFailTimestamp() > 0L) {
                    log.fine("new primary node [" + newMasterProtocol.getHostAddress().toString() + "] connection established after " + (System.currentTimeMillis() - this.getMasterHostFailTimestamp()));
                } else {
                    log.fine("new primary node [" + newMasterProtocol.getHostAddress().toString() + "] connection established");
                }
            }
            this.resetMasterFailoverData();
            if (!this.isSecondaryHostFail()) {
                this.stopFailover();
            }
        }
        finally {
            this.proxy.lock.writeLock().unlock();
            log.finest("log $$3 " + this.proxy.lock.getReadLockCount() + " " + this.proxy.lock.getWriteHoldCount());
        }
    }

    @Override
    public void foundActiveSecondary(Protocol newSecondaryProtocol) {
        if (this.isExplicitClosed()) {
            newSecondaryProtocol.close();
            return;
        }
        this.proxy.lock.writeLock().lock();
        try {
            if (this.secondaryProtocol != null && !this.secondaryProtocol.isClosed()) {
                this.secondaryProtocol.close();
            }
            log.finest("found active secondary connection");
            this.secondaryProtocol = newSecondaryProtocol;
            if (this.currentReadOnlyAsked.get() || this.jdbcUrl.getOptions().failOnReadOnly && !this.currentReadOnlyAsked.get() && this.isMasterHostFail()) {
                try {
                    this.syncConnection(this.currentProtocol, this.secondaryProtocol);
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Some error append during connection parameter synchronisation : ", e);
                }
                this.currentProtocol = this.secondaryProtocol;
            }
            if (log.isLoggable(Level.FINE)) {
                if (this.getSecondaryHostFailTimestamp() > 0L) {
                    log.fine("new active secondary node [" + newSecondaryProtocol.getHostAddress().toString() + "] connection established after " + (System.currentTimeMillis() - this.getSecondaryHostFailTimestamp()));
                } else {
                    log.fine("new active secondary node [" + newSecondaryProtocol.getHostAddress().toString() + "] connection established");
                }
            }
            this.resetSecondaryFailoverData();
            if (!this.isMasterHostFail()) {
                this.stopFailover();
            }
        }
        finally {
            this.proxy.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws QueryException {
        if (log.isLoggable(Level.FINEST)) {
            log.fine("switching to mustBeReadOnly = " + mustBeReadOnly + " mode");
        }
        if (mustBeReadOnly.booleanValue() != this.currentReadOnlyAsked.get() && this.currentProtocol.inTransaction()) {
            throw new QueryException("Trying to set to read-only mode during a transaction");
        }
        if (this.currentReadOnlyAsked.compareAndSet(mustBeReadOnly == false, mustBeReadOnly)) {
            if (this.currentReadOnlyAsked.get()) {
                if (this.currentProtocol.isMasterConnection()) {
                    if (!this.isSecondaryHostFail()) {
                        this.proxy.lock.writeLock().lock();
                        try {
                            log.finest("switching to secondary connection");
                            this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                            this.currentProtocol = this.secondaryProtocol;
                            this.setSessionReadOnly(true);
                            log.finest("current connection is now secondary");
                            return;
                        }
                        catch (QueryException e) {
                            log.log(Level.FINEST, "switching to secondary connection failed", e);
                            if (this.setSecondaryHostFail()) {
                                this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                            }
                        }
                        finally {
                            this.proxy.lock.writeLock().unlock();
                        }
                    }
                    this.launchFailLoopIfNotlaunched(false);
                    this.throwFailoverMessage(new QueryException("master " + this.masterProtocol.getHostAddress() + " connection failed"), false);
                }
            } else if (!this.currentProtocol.isMasterConnection()) {
                if (!this.isMasterHostFail()) {
                    this.proxy.lock.writeLock().lock();
                    try {
                        log.finest("switching to master connection");
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                        log.fine("current connection is now master");
                        return;
                    }
                    catch (QueryException e) {
                        log.log(Level.FINE, "switching to master connection failed", e);
                        if (this.setMasterHostFail()) {
                            this.addToBlacklist(this.masterProtocol.getHostAddress());
                        }
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                }
                if (this.jdbcUrl.getOptions().autoReconnect) {
                    this.reconnectFailedConnection(new SearchFilter(false, true, false, true));
                    log.finest("switching to master connection");
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    log.fine("current connection is now master");
                    return;
                }
                this.launchFailLoopIfNotlaunched(false);
                this.throwFailoverMessage(new QueryException("master " + this.masterProtocol.getHostAddress() + " connection failed"), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args) throws Throwable {
        boolean alreadyClosed;
        block27: {
            alreadyClosed = !this.masterProtocol.isConnected();
            try {
                if (this.masterProtocol != null && this.masterProtocol.isConnected() && this.masterProtocol.ping()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Primary node [" + this.masterProtocol.getHostAddress().toString() + "] connection re-established");
                    }
                    if (this.masterProtocol.inTransaction()) {
                        this.masterProtocol.rollback();
                    }
                    return new HandleErrorResult(true);
                }
            }
            catch (QueryException e) {
                this.proxy.lock.writeLock().lock();
                try {
                    this.masterProtocol.close();
                }
                finally {
                    this.proxy.lock.writeLock().unlock();
                }
                if (!this.setMasterHostFail()) break block27;
                this.addToBlacklist(this.masterProtocol.getHostAddress());
            }
        }
        if (this.jdbcUrl.getOptions().failOnReadOnly && !this.isSecondaryHostFail()) {
            try {
                if (this.secondaryProtocol != null && this.secondaryProtocol.ping()) {
                    log.finest("switching to secondary connection");
                    this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.currentProtocol = this.secondaryProtocol;
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    this.launchFailLoopIfNotlaunched(false);
                    try {
                        return this.relaunchOperation(method, args);
                    }
                    catch (Exception e) {
                        log.log(Level.FINEST, "relaunchOperation failed", e);
                        return new HandleErrorResult();
                    }
                }
                log.finest("ping failed on secondary");
            }
            catch (Exception e) {
                if (this.setSecondaryHostFail()) {
                    this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                }
                if (this.secondaryProtocol.isConnected()) {
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                }
                log.log(Level.FINEST, "ping on secondary failed");
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, this.jdbcUrl.getOptions().failOnReadOnly, true, this.jdbcUrl.getOptions().failOnReadOnly));
            if (this.isMasterHostFail()) {
                this.launchFailLoopIfNotlaunched(true);
            }
            if (alreadyClosed) {
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            this.launchFailLoopIfNotlaunched(true);
            return new HandleErrorResult();
        }
    }

    @Override
    public void reconnect() throws QueryException {
        SearchFilter filter = this.currentReadOnlyAsked.get() ? new SearchFilter(true, true, true, true) : new SearchFilter(true, this.jdbcUrl.getOptions().failOnReadOnly, true, this.jdbcUrl.getOptions().failOnReadOnly);
        this.reconnectFailedConnection(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult secondaryFail(Method method, Object[] args) throws Throwable {
        block26: {
            block25: {
                try {
                    if (this.secondaryProtocol != null && this.secondaryProtocol.isConnected() && this.secondaryProtocol.ping()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Secondary node [" + this.secondaryProtocol.getHostAddress().toString() + "] connection re-established");
                        }
                        return this.relaunchOperation(method, args);
                    }
                }
                catch (Exception e) {
                    log.finest("ping fail on secondary");
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    if (!this.setSecondaryHostFail()) break block25;
                    this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                }
            }
            if (!this.isMasterHostFail()) {
                try {
                    if (this.masterProtocol == null) break block26;
                    this.masterProtocol.ping();
                    log.finest("switching to master connection");
                    this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    this.launchFailLoopIfNotlaunched(true);
                    return this.relaunchOperation(method, args);
                }
                catch (Exception e) {
                    log.finest("ping fail on master");
                    if (!this.setMasterHostFail()) break block26;
                    this.addToBlacklist(this.masterProtocol.getHostAddress());
                    if (!this.masterProtocol.isConnected()) break block26;
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.masterProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true, true));
            if (!this.isSecondaryHostFail()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("SQL Secondary node [" + this.masterProtocol.getHostAddress().toString() + "] connection re-established");
                }
            } else {
                log.finest("switching to master connection");
                this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                this.proxy.lock.writeLock().lock();
                try {
                    this.currentProtocol = this.masterProtocol;
                }
                finally {
                    this.proxy.lock.writeLock().unlock();
                }
            }
            return this.relaunchOperation(method, args);
        }
        catch (Exception ee) {
            this.launchFailLoopIfNotlaunched(false);
            return new HandleErrorResult();
        }
    }

    public void checkIfTypeHaveChanged(SearchFilter searchFilter) throws QueryException {
        if (this.masterProtocol.ping()) {
            log.finest("PingLoop master ping ok");
        }
    }

    @Override
    public void throwFailoverMessage(QueryException queryException, boolean reconnected) throws QueryException {
        HostAddress hostAddress;
        boolean connectionTypeMaster = true;
        HostAddress hostAddress2 = hostAddress = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
        if (this.currentReadOnlyAsked.get()) {
            connectionTypeMaster = false;
            hostAddress = this.secondaryProtocol != null ? this.secondaryProtocol.getHostAddress() : null;
        }
        String firstPart = "Communications link failure with " + (connectionTypeMaster ? "primary" : "secondary") + (hostAddress != null ? " host " + hostAddress.host + ":" + hostAddress.port : "") + ". ";
        String error = "";
        if (this.jdbcUrl.getOptions().autoReconnect || !this.isMasterHostFail() && !this.isSecondaryHostFail()) {
            error = connectionTypeMaster && this.isMasterHostFail() || !connectionTypeMaster && this.isSecondaryHostFail() ? error + "  Driver will reconnect automatically in a few millisecond or during next query if append before" : error + " Driver as successfully reconnect connection";
        } else if (reconnected) {
            error = error + " Driver as reconnect connection";
        } else if (this.currentConnectionAttempts.get() > this.jdbcUrl.getOptions().retriesAllDown) {
            error = error + " Driver will not try to reconnect (too much failure > " + this.jdbcUrl.getOptions().retriesAllDown + ")";
        } else if (this.shouldReconnect()) {
            error = error + " Driver will try to reconnect automatically in a few millisecond or during next query if append before";
        } else {
            long longestFail = this.isMasterHostFail() ? (this.isSecondaryHostFail() ? Math.min(this.getMasterHostFailTimestamp(), this.getSecondaryHostFailTimestamp()) : this.getMasterHostFailTimestamp()) : this.getSecondaryHostFailTimestamp();
            long nextReconnectionTime = (long)(this.jdbcUrl.getOptions().secondsBeforeRetryMaster * 1000) - (System.currentTimeMillis() - longestFail);
            error = this.jdbcUrl.getOptions().secondsBeforeRetryMaster > 0 ? (this.jdbcUrl.getOptions().queriesBeforeRetryMaster > 0 ? error + " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + nextReconnectionTime + " milliseconds or after " + (this.jdbcUrl.getOptions().queriesBeforeRetryMaster - this.queriesSinceFailover.get()) + " query(s)" : error + " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + nextReconnectionTime + " milliseconds") : (this.jdbcUrl.getOptions().queriesBeforeRetryMaster > 0 ? error + " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + (this.jdbcUrl.getOptions().queriesBeforeRetryMaster - this.queriesSinceFailover.get()) + " query(s)" : error + " Driver will not try to reconnect automatically");
        }
        if (queryException == null) {
            throw new QueryException(firstPart + error, -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState());
        }
        error = queryException.getMessage() + ". " + error;
        queryException.setMessage(firstPart + error);
        throw queryException;
    }

    protected class PingLoop
    implements Runnable {
        MastersSlavesListener listener;

        public PingLoop(MastersSlavesListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            if (MastersSlavesListener.this.lastQueryTime + (long)(MastersSlavesListener.this.jdbcUrl.getOptions().validConnectionTimeout * 1000) < System.currentTimeMillis()) {
                log.finest("PingLoop run ");
                if (!MastersSlavesListener.this.isMasterHostFail()) {
                    log.finest("PingLoop run, master not seen failed");
                    boolean masterFail = false;
                    try {
                        if (MastersSlavesListener.this.masterProtocol != null && MastersSlavesListener.this.masterProtocol.isConnected()) {
                            MastersSlavesListener.this.checkIfTypeHaveChanged(null);
                        } else {
                            masterFail = true;
                        }
                    }
                    catch (QueryException e) {
                        log.log(Level.FINEST, "PingLoop ping to master error", e);
                        masterFail = true;
                    }
                    if (masterFail) {
                        log.finest("PingLoop master failed -> will loop to found it");
                        if (MastersSlavesListener.this.setMasterHostFail()) {
                            try {
                                this.listener.primaryFail(null, null);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }
}

