/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.listener.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.mysql.AuroraProtocol;
import org.mariadb.jdbc.internal.mysql.Protocol;
import org.mariadb.jdbc.internal.mysql.listener.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;

public class AuroraListener
extends MastersSlavesListener {
    private static final Logger log = Logger.getLogger(AuroraListener.class.getName());

    public AuroraListener(JDBCUrl jdbcUrl) {
        super(jdbcUrl);
        this.masterProtocol = null;
        this.secondaryProtocol = null;
        this.lastQueryTime = System.currentTimeMillis();
    }

    @Override
    public void initializeConnection() throws QueryException {
        if (this.jdbcUrl.getOptions().validConnectionTimeout != 0) {
            this.scheduledPing = this.executorService.scheduleWithFixedDelay(new MastersSlavesListener.PingLoop(this, this), this.jdbcUrl.getOptions().validConnectionTimeout, this.jdbcUrl.getOptions().validConnectionTimeout, TimeUnit.SECONDS);
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true));
        }
        catch (QueryException e) {
            log.log(Level.FINEST, "initializeConnection failed", e);
            this.checkInitialConnection();
            throw e;
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("search connection searchFilter=" + searchFilter);
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.jdbcUrl.getHostAddresses());
        loopAddress.removeAll(blacklist.keySet());
        Collections.shuffle(loopAddress);
        LinkedList blacklistShuffle = new LinkedList(blacklist.keySet());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
        }
        if (!this.isSecondaryHostFail()) {
            if (this.secondaryProtocol != null) {
                loopAddress.remove(this.secondaryProtocol.getHostAddress());
            }
            if (this.isMasterHostFail()) {
                log.fine("searching probableMaster");
                HostAddress probableMaster = this.searchByStartName(this.secondaryProtocol, loopAddress);
                if (probableMaster != null) {
                    loopAddress.remove(probableMaster);
                    loopAddress.add(0, probableMaster);
                } else if (log.isLoggable(Level.FINEST)) {
                    log.finest("probableMaster not found");
                }
            }
        }
        if (searchFilter.isSearchForMaster() && this.isMasterHostFail() || searchFilter.isSearchForSlave() && this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            AuroraProtocol.loop(this, loopAddress, (Map<HostAddress, Long>)blacklist, searchFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAddress searchByStartName(Protocol secondaryProtocol, List<HostAddress> loopAddress) {
        if (!this.isSecondaryHostFail()) {
            try (QueryResult queryResult = null;){
                this.proxy.lock.writeLock().lock();
                try {
                    queryResult = (SelectQueryResult)secondaryProtocol.executeQuery(new MySQLQuery("select server_id from information_schema.replica_host_status where session_id = 'MASTER_SESSION_ID'"));
                    ((SelectQueryResult)queryResult).next();
                }
                finally {
                    this.proxy.lock.writeLock().unlock();
                }
                String masterHostName = ((SelectQueryResult)queryResult).getValueObject(0).getString();
                for (int i = 0; i < loopAddress.size(); ++i) {
                    if (!loopAddress.get((int)i).host.startsWith(masterHostName)) continue;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("master probably " + loopAddress.get(i));
                    }
                    HostAddress hostAddress = loopAddress.get(i);
                    return hostAddress;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIfTypeHaveChanged(SearchFilter searchFilter) throws QueryException {
        if (!this.isMasterHostFail()) {
            try {
                if (this.masterProtocol != null && !this.masterProtocol.checkIfMaster()) {
                    this.setMasterHostFail();
                    if (this.isSecondaryHostFail()) {
                        this.foundActiveSecondary(this.masterProtocol);
                    }
                    if (searchFilter != null) {
                        searchFilter.setSearchForSlave(false);
                    }
                    this.launchFailLoopIfNotlaunched(false);
                }
            }
            catch (QueryException e) {
                block24: {
                    try {
                        this.masterProtocol.ping();
                    }
                    catch (QueryException ee) {
                        this.proxy.lock.writeLock().lock();
                        try {
                            this.masterProtocol.close();
                        }
                        finally {
                            this.proxy.lock.writeLock().unlock();
                        }
                        if (!this.setMasterHostFail()) break block24;
                        this.addToBlacklist(this.masterProtocol.getHostAddress());
                    }
                }
                this.launchFailLoopIfNotlaunched(false);
            }
        }
        if (!this.isSecondaryHostFail()) {
            try {
                if (this.secondaryProtocol != null && this.secondaryProtocol.checkIfMaster()) {
                    this.setSecondaryHostFail();
                    if (this.isMasterHostFail()) {
                        this.foundActiveMaster(this.secondaryProtocol);
                    }
                    if (searchFilter != null) {
                        searchFilter.setSearchForMaster(false);
                    }
                    this.launchFailLoopIfNotlaunched(false);
                }
            }
            catch (QueryException e) {
                try {
                    this.secondaryProtocol.ping();
                }
                catch (Exception ee) {
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                    this.launchFailLoopIfNotlaunched(false);
                }
            }
        }
    }
}

