/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.mysql.FailoverProxy;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;
import org.mariadb.jdbc.internal.mysql.listener.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;

public class MastersSlavesProtocol
extends MySQLProtocol {
    private static Logger log = Logger.getLogger(MastersSlavesProtocol.class.getName());
    boolean masterConnection = false;
    boolean mustBeMasterConnection = false;

    public MastersSlavesProtocol(JDBCUrl url, ReentrantReadWriteLock lock) {
        super(url, lock);
    }

    public static void loop(MastersSlavesListener listener, List<HostAddress> addresses, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("searching for master:" + searchFilter.isSearchForMaster() + " replica:" + searchFilter.isSearchForSlave() + " addresses:" + addresses);
        }
        LinkedList<HostAddress> loopAddresses = new LinkedList<HostAddress>(addresses);
        int maxConnectionTry = listener.getRetriesAllDown();
        QueryException lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isUniqueLoop() && maxConnectionTry > 0) {
            block17: {
                MastersSlavesProtocol protocol = MastersSlavesProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
                if (listener.isExplicitClosed() || !listener.isSecondaryHostFail() && !listener.isMasterHostFail()) {
                    return;
                }
                --maxConnectionTry;
                try {
                    protocol.setHostAddress((HostAddress)loopAddresses.get(0));
                    loopAddresses.remove(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("trying to connect to " + protocol.getHostAddress());
                    }
                    log.finest("log **1 " + protocol.getProxy().lock.getReadLockCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                    protocol.connect();
                    log.finest("log **2 " + protocol.getProxy().lock.getReadLockCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                    blacklist.remove(protocol.getHostAddress());
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("connected to " + (protocol.isMasterConnection() ? "primary " : "replica ") + protocol.getHostAddress());
                    }
                    log.finest("log **3 " + protocol.getProxy().lock.getReadLockCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                    if (searchFilter.isSearchForMaster() && protocol.isMasterConnection()) {
                        if (MastersSlavesProtocol.foundMaster(listener, protocol, searchFilter)) {
                            return;
                        }
                    } else if (searchFilter.isSearchForSlave() && !protocol.isMasterConnection()) {
                        if (MastersSlavesProtocol.foundSecondary(listener, protocol, searchFilter)) {
                            return;
                        }
                    } else {
                        protocol.close();
                    }
                    log.finest("log **4 " + protocol.getProxy().lock.getReadLockCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                }
                catch (QueryException e) {
                    lastQueryException = e;
                    blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
                    if (!log.isLoggable(Level.FINE)) break block17;
                    log.fine("Could not connect to " + protocol.getHostAddress() + " searching: " + searchFilter + " error: " + e.getMessage());
                }
            }
            if (!searchFilter.isSearchForMaster() && !searchFilter.isSearchForSlave()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isUniqueLoop() || maxConnectionTry <= 0) continue;
            loopAddresses = new LinkedList<HostAddress>(addresses);
            listener.checkIfTypeHaveChanged(searchFilter);
        }
        if (searchFilter.isSearchForMaster() || searchFilter.isSearchForSlave()) {
            String error = "No active connection found for replica";
            if (searchFilter.isSearchForMaster()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new QueryException(error, lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
            }
            throw new QueryException(error);
        }
    }

    private static boolean foundMaster(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) {
        protocol.setMustBeMasterConnection(true);
        searchFilter.setSearchForMaster(false);
        listener.foundActiveMaster(protocol);
        if (!searchFilter.isSearchForSlave()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() || !listener.isSecondaryHostFail();
    }

    private static boolean foundSecondary(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) {
        searchFilter.setSearchForSlave(false);
        protocol.setMustBeMasterConnection(false);
        listener.foundActiveSecondary(protocol);
        if (!searchFilter.isSearchForMaster()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlySlave() || !listener.isMasterHostFail();
    }

    public static MastersSlavesProtocol getNewProtocol(FailoverProxy proxy, JDBCUrl jdbcUrl) {
        MastersSlavesProtocol newProtocol = new MastersSlavesProtocol(jdbcUrl, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    @Override
    public boolean mustBeMasterConnection() {
        return this.mustBeMasterConnection;
    }

    public void setMustBeMasterConnection(boolean mustBeMasterConnection) {
        this.mustBeMasterConnection = mustBeMasterConnection;
    }
}

