/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLPooledConnection;
import org.mariadb.jdbc.MySQLXAConnection;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.DefaultOptions;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.UrlHAMode;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.mysql.Protocol;

public class MySQLDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource {
    private static final Logger log = Logger.getLogger(MySQLDataSource.class.getName());
    private final JDBCUrl jdbcUrl;

    public MySQLDataSource(String hostname, int port, String database) {
        ArrayList<HostAddress> hostAddresses = new ArrayList<HostAddress>();
        hostAddresses.add(new HostAddress(hostname, port));
        this.jdbcUrl = new JDBCUrl(database, hostAddresses, DefaultOptions.defaultValues(UrlHAMode.NONE), UrlHAMode.NONE);
    }

    public MySQLDataSource(String url) {
        this.jdbcUrl = JDBCUrl.parse(url);
    }

    public MySQLDataSource() {
        ArrayList<HostAddress> hostAddresses = new ArrayList<HostAddress>();
        hostAddresses.add(new HostAddress("localhost", 3306));
        this.jdbcUrl = new JDBCUrl("", hostAddresses, DefaultOptions.defaultValues(UrlHAMode.NONE), UrlHAMode.NONE);
    }

    public void setDatabaseName(String dbName) {
        this.jdbcUrl.setDatabase(dbName);
    }

    public String getDatabaseName() {
        return this.jdbcUrl.getDatabase() != null ? this.jdbcUrl.getDatabase() : "";
    }

    public void setUser(String userName) {
        this.setUserName(userName);
    }

    public String getUser() {
        return this.jdbcUrl.getUsername();
    }

    public void setUserName(String userName) {
        this.jdbcUrl.setUsername(userName);
    }

    public String getUserName() {
        return this.jdbcUrl.getUsername();
    }

    public void setPassword(String pass) {
        this.jdbcUrl.setPassword(pass);
    }

    public void setPort(int p) {
        this.jdbcUrl.getHostAddresses().get((int)0).port = p;
    }

    public int getPort() {
        return this.jdbcUrl.getHostAddresses().get((int)0).port;
    }

    public void setPortNumber(int p) {
        this.setPort(p);
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setServerName(String serverName) {
        this.jdbcUrl.getHostAddresses().get((int)0).host = serverName;
    }

    public void setProperties(String properties) {
        this.jdbcUrl.setProperties(properties);
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    public void setUrl(String s) {
        this.jdbcUrl.parseUrl(s);
    }

    public String getServerName() {
        return this.jdbcUrl.getHostAddresses().get((int)0).host != null ? this.jdbcUrl.getHostAddresses().get((int)0).host : "";
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            Protocol proxyfiedProtocol = Utils.retrieveProxy(this.jdbcUrl, lock);
            return MySQLConnection.newConnection(proxyfiedProtocol, lock);
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, null, null);
            return null;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.jdbcUrl.setUsername(username);
        this.jdbcUrl.setPassword(password);
        log.finest("connection : " + this.jdbcUrl.toString());
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new MySQLPooledConnection((MySQLConnection)this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new MySQLPooledConnection((MySQLConnection)this.getConnection(user, password));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new MySQLXAConnection((MySQLConnection)this.getConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new MySQLXAConnection((MySQLConnection)this.getConnection(user, password));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

