/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeSet;
import org.mapdb.elsa.ClassCallback;
import org.mapdb.elsa.SerializerPojo;

public final class ElsaUtil {
    private ElsaUtil() {
    }

    public static <E> E clone(SerializerPojo serializer, E data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream out2 = new DataOutputStream(out);
        serializer.serialize(out2, data);
        DataInputStream ins = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));
        return (E)serializer.deserialize((DataInput)ins, -1);
    }

    public static int unpackInt(DataInput is) throws IOException {
        byte v;
        int ret = 0;
        do {
            v = is.readByte();
            ret = ret << 7 | v & 0x7F;
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static long unpackLong(DataInput in) throws IOException {
        byte v;
        long ret = 0L;
        do {
            v = in.readByte();
            ret = ret << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static int unpackInt(InputStream in) throws IOException {
        int v;
        int ret = 0;
        do {
            if ((v = in.read()) == -1) {
                throw new EOFException();
            }
            ret = ret << 7 | v & 0x7F;
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static long unpackLong(InputStream in) throws IOException {
        int v;
        long ret = 0L;
        do {
            if ((v = in.read()) == -1) {
                throw new EOFException();
            }
            ret = ret << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static void packLong(DataOutput out, long value) throws IOException {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.writeByte((byte)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        out.writeByte((byte)(value & 0x7FL | 0x80L));
    }

    public static void packLong(OutputStream out, long value) throws IOException {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.write((int)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        out.write((int)(value & 0x7FL | 0x80L));
    }

    public static void packInt(DataOutput out, int value) throws IOException {
        int shift = value & 0xFFFFFF80;
        if (shift != 0) {
            shift = 31 - Integer.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                out.writeByte((byte)(value >>> shift & 0x7F));
                shift -= 7;
            }
        }
        out.writeByte((byte)(value & 0x7F | 0x80));
    }

    public static void packIntBigger(DataOutput out, int value) throws IOException {
        int shift = 31 - Integer.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.writeByte((byte)(value >>> shift & 0x7F));
            shift -= 7;
        }
        out.writeByte((byte)(value & 0x7F | 0x80));
    }

    public static Class[] findClasses(Iterable e) {
        final TreeSet classes = new TreeSet();
        SerializerPojo p = new SerializerPojo(null, null, null, null, new ClassCallback(){

            @Override
            public void classMissing(Class clazz) {
                classes.add(clazz);
            }
        }, null);
        for (Object o : e) {
            try {
                p.serialize(new DataOutputStream(new ByteArrayOutputStream()), o);
            }
            catch (IOException e1) {
                throw new IOError(e1);
            }
        }
        return classes.toArray(new Class[0]);
    }

    public static final class DataInputToStream
    extends InputStream {
        protected final DataInput in;

        public DataInputToStream(DataInput in) {
            this.in = in;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.in.readFully(b, off, len);
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            n = Math.min(n, Integer.MAX_VALUE);
            return this.in.skipBytes((int)n);
        }

        @Override
        public void close() throws IOException {
            if (this.in instanceof Closeable) {
                ((Closeable)((Object)this.in)).close();
            }
        }

        @Override
        public int read() throws IOException {
            return this.in.readUnsignedByte();
        }
    }
}

