/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.util.HashMap;
import java.util.Map;
import org.mapdb.elsa.SerializerPojo;

public interface ClassInfoResolver {
    public static final ClassInfoResolver VOID = new ClassInfoResolver(){

        @Override
        public SerializerPojo.ClassInfo getClassInfo(int classId) {
            return null;
        }

        @Override
        public int classToId(String className) {
            return -1;
        }
    };

    public SerializerPojo.ClassInfo getClassInfo(int var1);

    public int classToId(String var1);

    public static class ArrayBased
    implements ClassInfoResolver {
        protected final SerializerPojo.ClassInfo[] classInfos;
        protected final Map<String, Integer> reverse = new HashMap<String, Integer>();

        public ArrayBased(Class[] classes) {
            this.classInfos = new SerializerPojo.ClassInfo[classes.length];
            for (int i = 0; i < this.classInfos.length; ++i) {
                this.classInfos[i] = SerializerPojo.makeClassInfo(classes[i]);
                this.reverse.put(this.classInfos[i].name, i);
            }
        }

        public ArrayBased(SerializerPojo.ClassInfo[] classInfos) {
            this.classInfos = (SerializerPojo.ClassInfo[])classInfos.clone();
            for (int i = 0; i < this.classInfos.length; ++i) {
                this.reverse.put(this.classInfos[i].name, i);
            }
        }

        @Override
        public SerializerPojo.ClassInfo getClassInfo(int classId) {
            return this.classInfos[classId];
        }

        @Override
        public int classToId(String className) {
            Integer ret = this.reverse.get(className);
            return ret != null ? ret : -1;
        }
    }
}

