/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.mapdb.elsa.ElsaUtil;
import org.mapdb.elsa.SerializerPojo;

public final class ObjectInputStream2
extends ObjectInputStream {
    private SerializerPojo serializerPojo;
    private final SerializerPojo.ClassInfo[] classes;
    private ObjectStreamClass lastDescriptor;
    private Class lastDescriptorClass;

    protected ObjectInputStream2(SerializerPojo serializerPojo, InputStream in) throws IOException, SecurityException {
        this(serializerPojo, in, serializerPojo.getClassInfos());
    }

    protected ObjectInputStream2(SerializerPojo serializerPojo, InputStream in, SerializerPojo.ClassInfo[] classes) throws IOException, SecurityException {
        super(in);
        this.serializerPojo = serializerPojo;
        this.classes = classes;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass descriptor;
        int classId = ElsaUtil.unpackInt(this);
        String className = classId == -1 ? this.readUTF() : this.classes[classId].name;
        Class<?> clazz = SerializerPojo.loadClass(className);
        this.lastDescriptor = descriptor = ObjectStreamClass.lookup(clazz);
        this.lastDescriptorClass = clazz;
        return descriptor;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (desc == this.lastDescriptor) {
            return this.lastDescriptorClass;
        }
        Class<?> clazz = SerializerPojo.loadClass(desc.getName());
        if (clazz != null) {
            return clazz;
        }
        return super.resolveClass(desc);
    }
}

