/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.spring;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.ext.spring.ILoggingEventCache;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum EventCacheMode {
    OFF{

        @Override
        public ILoggingEventCache createCache() {
            return new ILoggingEventCache(){

                @Override
                public List<ILoggingEvent> get() {
                    return Collections.emptyList();
                }

                @Override
                public void put(ILoggingEvent event) {
                }
            };
        }
    }
    ,
    ON{

        @Override
        public ILoggingEventCache createCache() {
            return new ILoggingEventCache(){
                private List<ILoggingEvent> events = new ArrayList<ILoggingEvent>();

                @Override
                public List<ILoggingEvent> get() {
                    List<ILoggingEvent> list = Collections.unmodifiableList(this.events);
                    this.events = null;
                    return list;
                }

                @Override
                public void put(ILoggingEvent event) {
                    this.events.add(event);
                }
            };
        }
    }
    ,
    SOFT{

        @Override
        public ILoggingEventCache createCache() {
            return new ILoggingEventCache(){
                private List<SoftReference<ILoggingEvent>> references = new ArrayList<SoftReference<ILoggingEvent>>();

                @Override
                public List<ILoggingEvent> get() {
                    ArrayList<ILoggingEvent> events = new ArrayList<ILoggingEvent>(this.references.size());
                    for (SoftReference<ILoggingEvent> reference : this.references) {
                        ILoggingEvent event = reference.get();
                        if (event == null) continue;
                        events.add(event);
                    }
                    this.references = null;
                    return Collections.unmodifiableList(events);
                }

                @Override
                public void put(ILoggingEvent event) {
                    this.references.add(new SoftReference<ILoggingEvent>(event));
                }
            };
        }
    };


    public abstract ILoggingEventCache createCache();
}

