/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import com.github.jershell.kbson.BsonEncoder;
import com.github.jershell.kbson.FlexibleDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import org.bson.BsonBinary;
import org.bson.types.Binary;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/litote/kmongo/serialization/BinarySerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/bson/types/Binary;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "kmongo-serialization-mapping"})
public final class BinarySerializer
implements KSerializer<Binary> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final BinarySerializer INSTANCE;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Binary deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        BsonBinary bsonBinary = ((FlexibleDecoder)decoder).getReader().readBinaryData();
        Intrinsics.checkExpressionValueIsNotNull((Object)bsonBinary, (String)"(decoder as FlexibleDeco\u2026).reader.readBinaryData()");
        return new Binary(bsonBinary.getData());
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Binary value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        BsonEncoder bsonEncoder = (BsonEncoder)encoder;
        byte[] byArray = value.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"value.data");
        bsonEncoder.encodeByteArray(byArray);
    }

    private BinarySerializer() {
    }

    static {
        BinarySerializer binarySerializer;
        INSTANCE = binarySerializer = new BinarySerializer();
        descriptor = SerialDescriptorBuilderKt.PrimitiveDescriptor((String)"BinarySerializer", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }

    @NotNull
    public Binary patch(@NotNull Decoder decoder, @NotNull Binary old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return (Binary)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, (Object)old);
    }
}

