/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.time.Instant;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.LocalTimeKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.id.IdTransformer;
import org.litote.kmongo.id.jackson.IdKeySerializer;
import org.litote.kmongo.jackson.KMongoAnnotationIntrospector;
import org.litote.kmongo.util.KotlinxDatetimeLoader;
import org.litote.kmongo.util.PatternUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0000\u0018\u00002\u00020\u0001:\u0018\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006 "}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "<init>", "()V", "setupModule", "", "context", "Lcom/fasterxml/jackson/databind/Module$SetupContext;", "ObjectIdExtendedJsonSerializer", "BinaryExtendedJsonSerializer", "BsonTimestampExtendedJsonSerializer", "MaxKeyExtendedJsonSerializer", "MinKeyExtendedJsonSerializer", "TemporalExtendedJsonSerializer", "DateExtendedJsonSerializer", "CalendarExtendedJsonSerializer", "InstantExtendedJsonSerializer", "ZonedDateTimeExtendedJsonSerializer", "OffsetDateTimeExtendedJsonSerializer", "LocalDateExtendedJsonSerializer", "LocalDateTimeExtendedJsonSerializer", "LocalTimeExtendedJsonSerializer", "OffsetTimeExtendedJsonSerializer", "KTXInstantExtendedJsonSerializer", "KTXInstantExtendedJsonSerializer2", "KTXLocalDateExtendedJsonSerializer", "KTXLocalDateTimeExtendedJsonSerializer", "KTXLocalTimeExtendedJsonSerializer", "IdSerializer", "BigDecimalSerializer", "PatternSerializer", "RegexSerializer", "kmongo-jackson-mapping"})
public final class ExtendedJsonModule
extends SimpleModule {
    public ExtendedJsonModule() {
        this.addSerializer(ObjectId.class, ObjectIdExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Binary.class, BinaryExtendedJsonSerializer.INSTANCE);
        this.addSerializer(BsonTimestamp.class, BsonTimestampExtendedJsonSerializer.INSTANCE);
        this.addSerializer(MaxKey.class, MaxKeyExtendedJsonSerializer.INSTANCE);
        this.addSerializer(MinKey.class, MinKeyExtendedJsonSerializer.INSTANCE);
        this.addSerializer(BigDecimal.class, BigDecimalSerializer.INSTANCE);
        this.addSerializer(Id.class, IdSerializer.INSTANCE);
        this.addKeySerializer(Id.class, (JsonSerializer)new IdKeySerializer());
        this.addSerializer(Date.class, DateExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Calendar.class, CalendarExtendedJsonSerializer.INSTANCE);
        this.addSerializer(java.time.Instant.class, InstantExtendedJsonSerializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, ZonedDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(LocalDate.class, LocalDateExtendedJsonSerializer.INSTANCE);
        this.addSerializer(LocalDateTime.class, LocalDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(java.time.LocalTime.class, LocalTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeExtendedJsonSerializer.INSTANCE);
        KotlinxDatetimeLoader.INSTANCE.loadKotlinxDateTime(() -> ExtendedJsonModule._init_$lambda$0(this), ExtendedJsonModule::_init_$lambda$1);
        this.addSerializer(Pattern.class, PatternSerializer.INSTANCE);
        this.addSerializer(Regex.class, RegexSerializer.INSTANCE);
    }

    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.setupModule(context);
        context.appendAnnotationIntrospector((AnnotationIntrospector)KMongoAnnotationIntrospector.Companion.getINTROSPECTOR());
    }

    private static final Object _init_$lambda$0(ExtendedJsonModule this$0) {
        this$0.addSerializer(kotlinx.datetime.Instant.class, KTXInstantExtendedJsonSerializer.INSTANCE);
        this$0.addSerializer(kotlinx.datetime.LocalDate.class, KTXLocalDateExtendedJsonSerializer.INSTANCE);
        this$0.addSerializer(kotlinx.datetime.LocalDateTime.class, KTXLocalDateTimeExtendedJsonSerializer.INSTANCE);
        return this$0.addSerializer(LocalTime.class, KTXLocalTimeExtendedJsonSerializer.INSTANCE);
    }

    private static final Unit _init_$lambda$1() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$BigDecimalSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/math/BigDecimal;", "<init>", "()V", "serialize", "", "bigDecimal", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BigDecimalSerializer
    extends JsonSerializer<BigDecimal> {
        @NotNull
        public static final BigDecimalSerializer INSTANCE = new BigDecimalSerializer();

        private BigDecimalSerializer() {
        }

        public void serialize(@NotNull BigDecimal bigDecimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)bigDecimal, (String)"bigDecimal");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            generator.writeStartObject();
            generator.writeStringField("$numberDecimal", bigDecimal.toString());
            generator.writeEndObject();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$BinaryExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/Binary;", "<init>", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BinaryExtendedJsonSerializer
    extends JsonSerializer<Binary> {
        @NotNull
        public static final BinaryExtendedJsonSerializer INSTANCE = new BinaryExtendedJsonSerializer();

        private BinaryExtendedJsonSerializer() {
        }

        public void serialize(@NotNull Binary obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeBinaryField("$binary", obj.getData());
            String string = Integer.toHexString(obj.getType());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            jsonGenerator.writeStringField("$type", string2);
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$BsonTimestampExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/BsonTimestamp;", "<init>", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BsonTimestampExtendedJsonSerializer
    extends JsonSerializer<BsonTimestamp> {
        @NotNull
        public static final BsonTimestampExtendedJsonSerializer INSTANCE = new BsonTimestampExtendedJsonSerializer();

        private BsonTimestampExtendedJsonSerializer() {
        }

        public void serialize(@NotNull BsonTimestamp obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("$timestamp");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("t", obj.getTime());
            jsonGenerator.writeNumberField("i", obj.getInc());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$CalendarExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/util/Calendar;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class CalendarExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Calendar> {
        @NotNull
        public static final CalendarExtendedJsonSerializer INSTANCE = new CalendarExtendedJsonSerializer();

        private CalendarExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Calendar temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return temporal.getTimeInMillis();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$DateExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/util/Date;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class DateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Date> {
        @NotNull
        public static final DateExtendedJsonSerializer INSTANCE = new DateExtendedJsonSerializer();

        private DateExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Date temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return temporal.getTime();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$IdSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/litote/kmongo/Id;", "<init>", "()V", "serialize", "", "id", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class IdSerializer
    extends JsonSerializer<Id<?>> {
        @NotNull
        public static final IdSerializer INSTANCE = new IdSerializer();

        private IdSerializer() {
        }

        public void serialize(@NotNull Id<?> id, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            generator.writeObject(IdTransformer.INSTANCE.unwrapId(id));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$InstantExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/Instant;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class InstantExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<java.time.Instant> {
        @NotNull
        public static final InstantExtendedJsonSerializer INSTANCE = new InstantExtendedJsonSerializer();

        private InstantExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull java.time.Instant temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return temporal.toEpochMilli();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$KTXInstantExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/Instant;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXInstantExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<kotlinx.datetime.Instant> {
        @NotNull
        public static final KTXInstantExtendedJsonSerializer INSTANCE = new KTXInstantExtendedJsonSerializer();

        private KTXInstantExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.Instant temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return temporal.toEpochMilliseconds();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$KTXInstantExtendedJsonSerializer2;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlin/time/Instant;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXInstantExtendedJsonSerializer2
    extends TemporalExtendedJsonSerializer<Instant> {
        @NotNull
        public static final KTXInstantExtendedJsonSerializer2 INSTANCE = new KTXInstantExtendedJsonSerializer2();

        private KTXInstantExtendedJsonSerializer2() {
        }

        @Override
        public long epochMillis(@NotNull Instant temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return temporal.toEpochMilliseconds();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$KTXLocalDateExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/LocalDate;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXLocalDateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<kotlinx.datetime.LocalDate> {
        @NotNull
        public static final KTXLocalDateExtendedJsonSerializer INSTANCE = new KTXLocalDateExtendedJsonSerializer();

        private KTXLocalDateExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.LocalDate temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return KTXInstantExtendedJsonSerializer2.INSTANCE.epochMillis(TimeZoneKt.atStartOfDayIn$default((kotlinx.datetime.LocalDate)temporal, (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$KTXLocalDateTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/LocalDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXLocalDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<kotlinx.datetime.LocalDateTime> {
        @NotNull
        public static final KTXLocalDateTimeExtendedJsonSerializer INSTANCE = new KTXLocalDateTimeExtendedJsonSerializer();

        private KTXLocalDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return KTXInstantExtendedJsonSerializer2.INSTANCE.epochMillis(TimeZoneKt.toInstant$default((kotlinx.datetime.LocalDateTime)temporal, (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$KTXLocalTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/LocalTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXLocalTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalTime> {
        @NotNull
        public static final KTXLocalTimeExtendedJsonSerializer INSTANCE = new KTXLocalTimeExtendedJsonSerializer();

        private KTXLocalTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return KTXInstantExtendedJsonSerializer2.INSTANCE.epochMillis(TimeZoneKt.toInstant$default((kotlinx.datetime.LocalDateTime)LocalTimeKt.atDate((LocalTime)temporal, (kotlinx.datetime.LocalDate)kotlinx.datetime.LocalDate.Companion.fromEpochDays(0)), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$LocalDateExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalDate;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalDateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalDate> {
        @NotNull
        public static final LocalDateExtendedJsonSerializer INSTANCE = new LocalDateExtendedJsonSerializer();

        private LocalDateExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDate temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            ZonedDateTime zonedDateTime = temporal.atStartOfDay(ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atStartOfDay(...)");
            return ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(zonedDateTime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$LocalDateTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalDateTime> {
        @NotNull
        public static final LocalDateTimeExtendedJsonSerializer INSTANCE = new LocalDateTimeExtendedJsonSerializer();

        private LocalDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            ZonedDateTime zonedDateTime = temporal.atZone(ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atZone(...)");
            return ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(zonedDateTime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$LocalTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<java.time.LocalTime> {
        @NotNull
        public static final LocalTimeExtendedJsonSerializer INSTANCE = new LocalTimeExtendedJsonSerializer();

        private LocalTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull java.time.LocalTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            LocalDateTime localDateTime = temporal.atDate(LocalDate.ofEpochDay(0L));
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"atDate(...)");
            return LocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(localDateTime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$MaxKeyExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MaxKey;", "<init>", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class MaxKeyExtendedJsonSerializer
    extends JsonSerializer<MaxKey> {
        @NotNull
        public static final MaxKeyExtendedJsonSerializer INSTANCE = new MaxKeyExtendedJsonSerializer();

        private MaxKeyExtendedJsonSerializer() {
        }

        public void serialize(@NotNull MaxKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("$maxKey", 1);
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$MinKeyExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MinKey;", "<init>", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class MinKeyExtendedJsonSerializer
    extends JsonSerializer<MinKey> {
        @NotNull
        public static final MinKeyExtendedJsonSerializer INSTANCE = new MinKeyExtendedJsonSerializer();

        private MinKeyExtendedJsonSerializer() {
        }

        public void serialize(@NotNull MinKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("$minKey", 1);
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$ObjectIdExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/ObjectId;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class ObjectIdExtendedJsonSerializer
    extends JsonSerializer<ObjectId> {
        @NotNull
        public static final ObjectIdExtendedJsonSerializer INSTANCE = new ObjectIdExtendedJsonSerializer();

        private ObjectIdExtendedJsonSerializer() {
        }

        public void serialize(@NotNull ObjectId value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeStartObject();
            gen.writeStringField("$oid", value.toHexString());
            gen.writeEndObject();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$OffsetDateTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/OffsetDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class OffsetDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<OffsetDateTime> {
        @NotNull
        public static final OffsetDateTimeExtendedJsonSerializer INSTANCE = new OffsetDateTimeExtendedJsonSerializer();

        private OffsetDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            java.time.Instant instant = temporal.toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            return InstantExtendedJsonSerializer.INSTANCE.epochMillis(instant);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$OffsetTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/OffsetTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class OffsetTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<OffsetTime> {
        @NotNull
        public static final OffsetTimeExtendedJsonSerializer INSTANCE = new OffsetTimeExtendedJsonSerializer();

        private OffsetTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            OffsetDateTime offsetDateTime = temporal.atDate(LocalDate.ofEpochDay(0L));
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"atDate(...)");
            return OffsetDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(offsetDateTime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$PatternSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/util/regex/Pattern;", "<init>", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class PatternSerializer
    extends JsonSerializer<Pattern> {
        @NotNull
        public static final PatternSerializer INSTANCE = new PatternSerializer();

        private PatternSerializer() {
        }

        public void serialize(@NotNull Pattern obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            gen.writeStartObject();
            gen.writeStringField("$regex", obj.pattern());
            gen.writeStringField("$options", PatternUtil.INSTANCE.getOptionsAsString(obj));
            gen.writeEndObject();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$RegexSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lkotlin/text/Regex;", "<init>", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class RegexSerializer
    extends JsonSerializer<Regex> {
        @NotNull
        public static final RegexSerializer INSTANCE = new RegexSerializer();

        private RegexSerializer() {
        }

        public void serialize(@NotNull Regex obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            PatternSerializer.INSTANCE.serialize(obj.toPattern(), gen, serializerProvider);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "T", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "epochMillis", "", "temporal", "(Ljava/lang/Object;)J", "kmongo-jackson-mapping"})
    public static abstract class TemporalExtendedJsonSerializer<T>
    extends JsonSerializer<T> {
        public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeStartObject();
            gen.writeNumberField("$date", this.epochMillis(value));
            gen.writeEndObject();
        }

        public abstract long epochMillis(T var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$ZonedDateTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/ZonedDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class ZonedDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<ZonedDateTime> {
        @NotNull
        public static final ZonedDateTimeExtendedJsonSerializer INSTANCE = new ZonedDateTimeExtendedJsonSerializer();

        private ZonedDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull ZonedDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            java.time.Instant instant = temporal.toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            return InstantExtendedJsonSerializer.INSTANCE.epochMillis(instant);
        }
    }
}

