/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.json.JsonReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.SharedExtensionsKt;
import org.litote.kmongo.id.StringId;
import org.litote.kmongo.util.KMongoUtil;
import org.litote.kmongo.util.MongoIdUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001.B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020+2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec;", "T", "", "Lorg/bson/codecs/Codec;", "Lorg/bson/codecs/CollectibleCodec;", "bsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "notBsonObjectMapper", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "type", "Ljava/lang/Class;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/bson/codecs/configuration/CodecRegistry;Ljava/lang/Class;)V", "getBsonObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getCodecRegistry", "()Lorg/bson/codecs/configuration/CodecRegistry;", "getNotBsonObjectMapper", "rawBsonDocumentCodec", "Lorg/bson/RawBsonDocument;", "getType", "()Ljava/lang/Class;", "decode", "reader", "Lorg/bson/BsonReader;", "decoderContext", "Lorg/bson/codecs/DecoderContext;", "(Lorg/bson/BsonReader;Lorg/bson/codecs/DecoderContext;)Ljava/lang/Object;", "documentHasId", "", "document", "(Ljava/lang/Object;)Z", "encode", "", "writer", "Lorg/bson/BsonWriter;", "value", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "(Lorg/bson/BsonWriter;Ljava/lang/Object;Lorg/bson/codecs/EncoderContext;)V", "generateIdIfAbsentFromDocument", "(Ljava/lang/Object;)Ljava/lang/Object;", "getDocumentId", "Lorg/bson/BsonValue;", "(Ljava/lang/Object;)Lorg/bson/BsonValue;", "getEncoderClass", "VisitorWrapper", "kmongo-jackson-mapping"})
public final class JacksonCodec<T>
implements Codec<T>,
CollectibleCodec<T> {
    @NotNull
    private final ObjectMapper bsonObjectMapper;
    @NotNull
    private final ObjectMapper notBsonObjectMapper;
    @NotNull
    private final CodecRegistry codecRegistry;
    @NotNull
    private final Class<T> type;
    @NotNull
    private final Codec<RawBsonDocument> rawBsonDocumentCodec;

    public JacksonCodec(@NotNull ObjectMapper bsonObjectMapper, @NotNull ObjectMapper notBsonObjectMapper, @NotNull CodecRegistry codecRegistry, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)bsonObjectMapper, (String)"bsonObjectMapper");
        Intrinsics.checkNotNullParameter((Object)notBsonObjectMapper, (String)"notBsonObjectMapper");
        Intrinsics.checkNotNullParameter((Object)codecRegistry, (String)"codecRegistry");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.bsonObjectMapper = bsonObjectMapper;
        this.notBsonObjectMapper = notBsonObjectMapper;
        this.codecRegistry = codecRegistry;
        this.type = type;
        Codec codec = this.codecRegistry.get(RawBsonDocument.class);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codecRegistry.get(RawBsonDocument::class.java)");
        this.rawBsonDocumentCodec = codec;
    }

    @NotNull
    public final ObjectMapper getBsonObjectMapper() {
        return this.bsonObjectMapper;
    }

    @NotNull
    public final ObjectMapper getNotBsonObjectMapper() {
        return this.notBsonObjectMapper;
    }

    @NotNull
    public final CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @NotNull
    public final Class<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T decode(@NotNull BsonReader reader, @NotNull DecoderContext decoderContext) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)decoderContext, (String)"decoderContext");
        if (reader.getCurrentBsonType() == BsonType.STRING) {
            String s = reader.readString();
            Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
            return (T)this.notBsonObjectMapper.readValue(SharedExtensionsKt.getJson((Object)s), this.type);
        }
        BasicOutputBuffer buffer = new BasicOutputBuffer(128);
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer);
        try {
            writer.pipe(reader);
            object = this.bsonObjectMapper.readValue(buffer.getInternalBuffer(), this.type);
        }
        finally {
            writer.close();
            buffer.close();
        }
        return (T)object;
    }

    public void encode(@NotNull BsonWriter writer, @Nullable T value, @NotNull EncoderContext encoderContext) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)encoderContext, (String)"encoderContext");
        try {
            if (value == null) {
                writer.writeNull();
            } else {
                VisitorWrapper visitor = new VisitorWrapper();
                this.bsonObjectMapper.acceptJsonFormatVisitor(value.getClass(), (JsonFormatVisitorWrapper)visitor);
                VisitorWrapper.JsonType jsonType = visitor.getJsonType();
                block1 : switch (jsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonType.ordinal()]) {
                    case -1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        byte[] bytes = this.bsonObjectMapper.writeValueAsBytes(value);
                        this.rawBsonDocumentCodec.encode(writer, (Object)new RawBsonDocument(bytes), encoderContext);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: {
                        JsonReader jsonReader = new JsonReader(this.notBsonObjectMapper.writeValueAsString(value));
                        VisitorWrapper.JsonType jsonType2 = visitor.getJsonType();
                        switch (jsonType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonType2.ordinal()]) {
                            case 1: {
                                writer.writeDouble(jsonReader.readDouble());
                                break block1;
                            }
                            case 2: {
                                writer.writeInt64(jsonReader.readInt64());
                                break block1;
                            }
                            case 3: {
                                writer.writeBoolean(jsonReader.readBoolean());
                                break block1;
                            }
                            case 4: {
                                writer.writeObjectId(jsonReader.readObjectId());
                                break block1;
                            }
                            case 5: {
                                writer.writeDateTime(jsonReader.readDateTime());
                                break block1;
                            }
                        }
                        writer.writeString(jsonReader.readString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public Class<T> getEncoderClass() {
        return this.type;
    }

    @NotNull
    public BsonValue getDocumentId(@NotNull T document) {
        BsonValue idValue;
        KProperty1<?, ?> idProperty;
        Intrinsics.checkNotNullParameter(document, (String)"document");
        KProperty1<?, ?> kProperty1 = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document.getClass()));
        Object object = idProperty = kProperty1 instanceof KProperty1 ? kProperty1 : null;
        if (idProperty == null) {
            throw new IllegalStateException(this.type + " has no id field");
        }
        BsonValue bsonValue = idValue = KMongoUtil.INSTANCE.getIdBsonValue(idProperty.get(document));
        if (bsonValue == null) {
            throw new IllegalStateException(this.type + " has null id");
        }
        return bsonValue;
    }

    public boolean documentHasId(@NotNull T document) {
        Intrinsics.checkNotNullParameter(document, (String)"document");
        return MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document.getClass())) != null;
    }

    @NotNull
    public T generateIdIfAbsentFromDocument(@NotNull T document) {
        Object idValue;
        KProperty1<?, ?> idProperty;
        Intrinsics.checkNotNullParameter(document, (String)"document");
        KProperty1<?, ?> kProperty1 = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document.getClass()));
        Object object = idProperty = kProperty1 instanceof KProperty1 ? kProperty1 : null;
        if (idProperty != null && (idValue = MongoIdUtil.INSTANCE.getIdValue(idProperty, document)) == null) {
            Field field = ReflectJvmMapping.getJavaField((KProperty)((KProperty)idProperty));
            Intrinsics.checkNotNull((Object)field);
            Field javaField = field;
            Class<?> type = javaField.getType();
            javaField.setAccessible(true);
            Intrinsics.checkNotNullExpressionValue(type, (String)"type");
            javaField.set(document, KMongoUtil.INSTANCE.generateNewIdForIdClass(JvmClassMappingKt.getKotlinClass(type)));
        }
        return document;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper;", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonFormatVisitorWrapper$Base;", "()V", "dateTimeClasses", "", "Lkotlin/reflect/KClass;", "", "jsonType", "Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "getJsonType", "()Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "setJsonType", "(Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;)V", "expectAnyFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonAnyFormatVisitor;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "expectArrayFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonArrayFormatVisitor;", "expectBooleanFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonBooleanFormatVisitor;", "expectIntegerFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonIntegerFormatVisitor;", "expectMapFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonMapFormatVisitor;", "expectNullFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonNullFormatVisitor;", "expectNumberFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonNumberFormatVisitor;", "expectObjectFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "expectStringFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonStringFormatVisitor;", "JsonType", "kmongo-jackson-mapping"})
    public static final class VisitorWrapper
    extends JsonFormatVisitorWrapper.Base {
        @Nullable
        private JsonType jsonType;
        @NotNull
        private final Set<KClass<? extends Object>> dateTimeClasses;

        public VisitorWrapper() {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Instant.class), Reflection.getOrCreateKotlinClass(ZonedDateTime.class), Reflection.getOrCreateKotlinClass(OffsetDateTime.class), Reflection.getOrCreateKotlinClass(LocalDate.class), Reflection.getOrCreateKotlinClass(LocalDateTime.class), Reflection.getOrCreateKotlinClass(LocalTime.class), Reflection.getOrCreateKotlinClass(OffsetTime.class)};
            this.dateTimeClasses = SetsKt.setOf((Object[])objectArray);
        }

        @Nullable
        public final JsonType getJsonType() {
            return this.jsonType;
        }

        public final void setJsonType(@Nullable JsonType jsonType) {
            this.jsonType = jsonType;
        }

        @Nullable
        public JsonNullFormatVisitor expectNullFormat(@Nullable JavaType type) {
            return null;
        }

        @Nullable
        public JsonAnyFormatVisitor expectAnyFormat(@NotNull JavaType type) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Class clazz = type.getRawClass();
            if (clazz != null) {
                Class it = clazz;
                boolean bl2 = false;
                bl = Id.class.isAssignableFrom(it);
            } else {
                bl = false;
            }
            if (bl) {
                this.jsonType = Intrinsics.areEqual((Object)type.getRawClass(), StringId.class) ? JsonType.string : JsonType.objectId;
            } else {
                Class clazz2 = type.getRawClass();
                Intrinsics.checkNotNullExpressionValue((Object)clazz2, (String)"type.rawClass");
                this.jsonType = this.dateTimeClasses.contains(JvmClassMappingKt.getKotlinClass((Class)clazz2)) || Calendar.class.isAssignableFrom(type.getRawClass()) ? JsonType.date : JsonType.object;
            }
            return null;
        }

        @Nullable
        public JsonStringFormatVisitor expectStringFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.string;
            return null;
        }

        @Nullable
        public JsonArrayFormatVisitor expectArrayFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.array;
            return null;
        }

        @Nullable
        public JsonNumberFormatVisitor expectNumberFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.number;
            return null;
        }

        @Nullable
        public JsonMapFormatVisitor expectMapFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.map;
            return null;
        }

        @Nullable
        public JsonObjectFormatVisitor expectObjectFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.object;
            return null;
        }

        @Nullable
        public JsonIntegerFormatVisitor expectIntegerFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.integer;
            return null;
        }

        @Nullable
        public JsonBooleanFormatVisitor expectBooleanFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.boolean;
            return null;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "", "(Ljava/lang/String;I)V", "string", "array", "number", "map", "object", "integer", "boolean", "objectId", "date", "kmongo-jackson-mapping"})
        public static final class JsonType
        extends Enum<JsonType> {
            public static final /* enum */ JsonType string = new JsonType();
            public static final /* enum */ JsonType array = new JsonType();
            public static final /* enum */ JsonType number = new JsonType();
            public static final /* enum */ JsonType map = new JsonType();
            public static final /* enum */ JsonType object = new JsonType();
            public static final /* enum */ JsonType integer = new JsonType();
            public static final /* enum */ JsonType boolean = new JsonType();
            public static final /* enum */ JsonType objectId = new JsonType();
            public static final /* enum */ JsonType date = new JsonType();
            private static final /* synthetic */ JsonType[] $VALUES;

            public static JsonType[] values() {
                return (JsonType[])$VALUES.clone();
            }

            public static JsonType valueOf(String value) {
                return Enum.valueOf(JsonType.class, value);
            }

            static {
                $VALUES = jsonTypeArray = new JsonType[]{JsonType.string, JsonType.array, JsonType.number, JsonType.map, JsonType.object, JsonType.integer, JsonType.boolean, JsonType.objectId, JsonType.date};
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VisitorWrapper.JsonType.values().length];
            nArray[VisitorWrapper.JsonType.number.ordinal()] = 1;
            nArray[VisitorWrapper.JsonType.integer.ordinal()] = 2;
            nArray[VisitorWrapper.JsonType.boolean.ordinal()] = 3;
            nArray[VisitorWrapper.JsonType.objectId.ordinal()] = 4;
            nArray[VisitorWrapper.JsonType.date.ordinal()] = 5;
            nArray[VisitorWrapper.JsonType.object.ordinal()] = 6;
            nArray[VisitorWrapper.JsonType.map.ordinal()] = 7;
            nArray[VisitorWrapper.JsonType.array.ordinal()] = 8;
            nArray[VisitorWrapper.JsonType.string.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

