/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.types.Decimal128;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.ProjectionsKt;
import org.litote.kmongo.id.IdTransformer;
import org.litote.kmongo.id.StringId;
import org.litote.kmongo.id.WrappedObjectId;
import org.litote.kmongo.id.jackson.IdKeyDeserializer;
import org.litote.kmongo.id.jackson.IdKeySerializer;
import org.litote.kmongo.jackson.ExtendedJsonModule;
import org.litote.kmongo.jackson.KMongoAnnotationIntrospector;
import org.litote.kmongo.jackson.KMongoBsonFactory;
import org.litote.kmongo.jackson.StringDeserializationProblemHandler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b,\b\u0000\u0018\u00002\u00020\u0001:+\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./01B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u00062"}, d2={"Lorg/litote/kmongo/jackson/BsonModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "()V", "setupModule", "", "context", "Lcom/fasterxml/jackson/databind/Module$SetupContext;", "AbstractIdBsonDeserializer", "BigDecimalBsonDeserializer", "BigDecimalBsonSerializer", "BinaryBsonDeserializer", "BinaryBsonSerializer", "BsonDateDeserializer", "BsonObjectIdDeserializer", "BsonTimestampBsonDeserializer", "BsonTimestampBsonSerializer", "CalendarBsonDeserializer", "CalendarBsonSerializer", "Decimal128BsonDeserializer", "Decimal128BsonSerializer", "IdBsonDeserializer", "IdBsonSerializer", "InstantBsonDeserializer", "InstantBsonSerializer", "KMongoObjectId", "KPropertySerializer", "LocalDateBsonDeserializer", "LocalDateBsonSerializer", "LocalDateTimeBsonDeserializer", "LocalDateTimeBsonSerializer", "LocalTimeBsonDeserializer", "LocalTimeBsonSerializer", "MaxKeyBsonDeserializer", "MaxKeyBsonSerializer", "MinKeyBsonDeserializer", "MinKeyBsonSerializer", "ObjectIdBsonDeserializer", "ObjectIdBsonSerializer", "OffsetDateTimeBsonDeserializer", "OffsetDateTimeBsonSerializer", "OffsetTimeBsonDeserializer", "OffsetTimeBsonSerializer", "StringIdBsonDeserializer", "TemporalBsonDeserializer", "TemporalBsonSerializer", "WrappedObjectIdBsonDeserializer", "ZoneIdBsonDeserializer", "ZoneIdBsonSerializer", "ZonedDateTimeBsonDeserializer", "ZonedDateTimeBsonSerializer", "kmongo-jackson-mapping"})
public final class BsonModule
extends SimpleModule {
    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super.setupModule(context);
        context.appendAnnotationIntrospector((AnnotationIntrospector)KMongoAnnotationIntrospector.Companion.getINTROSPECTOR());
    }

    public BsonModule() {
        this.addSerializer(ObjectId.class, ObjectIdBsonSerializer.INSTANCE);
        this.addDeserializer(ObjectId.class, ObjectIdBsonDeserializer.INSTANCE);
        this.addDeserializer(de.undercouch.bson4jackson.types.ObjectId.class, BsonObjectIdDeserializer.INSTANCE);
        this.addSerializer(Binary.class, BinaryBsonSerializer.INSTANCE);
        this.addDeserializer(Binary.class, BinaryBsonDeserializer.INSTANCE);
        this.addSerializer(BsonTimestamp.class, BsonTimestampBsonSerializer.INSTANCE);
        this.addDeserializer(BsonTimestamp.class, BsonTimestampBsonDeserializer.INSTANCE);
        this.addSerializer(MaxKey.class, MaxKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MaxKey.class, MaxKeyBsonDeserializer.INSTANCE);
        this.addSerializer(MinKey.class, MinKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MinKey.class, MinKeyBsonDeserializer.INSTANCE);
        this.addSerializer(BigDecimal.class, BigDecimalBsonSerializer.INSTANCE);
        this.addDeserializer(BigDecimal.class, BigDecimalBsonDeserializer.INSTANCE);
        this.addSerializer(Decimal128.class, Decimal128BsonSerializer.INSTANCE);
        this.addDeserializer(Decimal128.class, Decimal128BsonDeserializer.INSTANCE);
        this.addSerializer(Id.class, IdBsonSerializer.INSTANCE);
        this.addDeserializer(Id.class, IdBsonDeserializer.INSTANCE);
        this.addKeySerializer(Id.class, (JsonSerializer)new IdKeySerializer());
        this.addKeyDeserializer(Id.class, (KeyDeserializer)new IdKeyDeserializer(null, 1, null));
        this.addDeserializer(StringId.class, StringIdBsonDeserializer.INSTANCE);
        this.addKeyDeserializer(StringId.class, (KeyDeserializer)new IdKeyDeserializer(null, 1, null));
        this.addDeserializer(WrappedObjectId.class, WrappedObjectIdBsonDeserializer.INSTANCE);
        this.addKeyDeserializer(WrappedObjectId.class, (KeyDeserializer)new IdKeyDeserializer(null, 1, null));
        this.addSerializer(Instant.class, InstantBsonSerializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, ZonedDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(LocalDate.class, LocalDateBsonSerializer.INSTANCE);
        this.addSerializer(LocalDateTime.class, LocalDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(LocalTime.class, LocalTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeBsonSerializer.INSTANCE);
        this.addSerializer(Calendar.class, CalendarBsonSerializer.INSTANCE);
        this.addDeserializer(Instant.class, InstantBsonDeserializer.INSTANCE);
        this.addDeserializer(ZonedDateTime.class, ZonedDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetDateTime.class, OffsetDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalDate.class, LocalDateBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalDateTime.class, LocalDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalTime.class, LocalTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetTime.class, OffsetTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(Calendar.class, CalendarBsonDeserializer.INSTANCE);
        this.addSerializer(ZoneId.class, ZoneIdBsonSerializer.INSTANCE);
        this.addDeserializer(ZoneId.class, ZoneIdBsonDeserializer.INSTANCE);
        this.addDeserializer(Date.class, BsonDateDeserializer.INSTANCE);
        this.addSerializer(KProperty.class, KPropertySerializer.INSTANCE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KMongoObjectId;", "Lde/undercouch/bson4jackson/types/ObjectId;", "time", "", "machine", "inc", "(III)V", "toString", "", "kmongo-jackson-mapping"})
    public static final class KMongoObjectId
    extends de.undercouch.bson4jackson.types.ObjectId {
        @NotNull
        public String toString() {
            String string = KMongoBsonFactory.Companion.createFromLegacyFormat(this.getTime(), this.getMachine(), this.getInc()).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"createFromLegacyFormat(t\u2026 machine, inc).toString()");
            return string;
        }

        public KMongoObjectId(int time, int machine, int inc) {
            super(time, machine, inc);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonObjectIdDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lde/undercouch/bson4jackson/types/ObjectId;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BsonObjectIdDeserializer
    extends JsonDeserializer<de.undercouch.bson4jackson.types.ObjectId> {
        public static final BsonObjectIdDeserializer INSTANCE;

        @NotNull
        public de.undercouch.bson4jackson.types.ObjectId deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            if (jp instanceof BsonParser) {
                if (((BsonParser)jp).getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || ((BsonParser)jp).getCurrentBsonType() != 7) {
                    JsonMappingException jsonMappingException = ctxt.mappingException(de.undercouch.bson4jackson.types.ObjectId.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonMappingException, (String)"ctxt.mappingException(de\u2026pes.ObjectId::class.java)");
                    throw (Throwable)jsonMappingException;
                }
                Object object = ((BsonParser)jp).getEmbeddedObject();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.undercouch.bson4jackson.types.ObjectId");
                }
                return (de.undercouch.bson4jackson.types.ObjectId)object;
            }
            TreeNode tree = jp.getCodec().readTree(jp);
            TreeNode treeNode = tree.get("$time");
            if (treeNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            }
            int time = ((ValueNode)treeNode).asInt();
            TreeNode treeNode2 = tree.get("$machine");
            if (treeNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            }
            int machine = ((ValueNode)treeNode2).asInt();
            TreeNode treeNode3 = tree.get("$inc");
            if (treeNode3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            }
            int inc = ((ValueNode)treeNode3).asInt();
            return new KMongoObjectId(time, machine, inc);
        }

        private BsonObjectIdDeserializer() {
        }

        static {
            BsonObjectIdDeserializer bsonObjectIdDeserializer;
            INSTANCE = bsonObjectIdDeserializer = new BsonObjectIdDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ObjectIdBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/ObjectId;", "()V", "serialize", "", "objectId", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class ObjectIdBsonSerializer
    extends JsonSerializer<ObjectId> {
        public static final ObjectIdBsonSerializer INSTANCE;

        public void serialize(@NotNull ObjectId objectId, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)objectId, (String)"objectId");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                gen.writeObjectId((Object)objectId);
            } else {
                ExtendedJsonModule.ObjectIdExtendedJsonSerializer.INSTANCE.serialize(objectId, gen, serializerProvider);
            }
        }

        private ObjectIdBsonSerializer() {
        }

        static {
            ObjectIdBsonSerializer objectIdBsonSerializer;
            INSTANCE = objectIdBsonSerializer = new ObjectIdBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ObjectIdBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/ObjectId;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class ObjectIdBsonDeserializer
    extends JsonDeserializer<ObjectId> {
        public static final ObjectIdBsonDeserializer INSTANCE;

        @NotNull
        public ObjectId deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            ObjectId objectId;
            Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            if (p instanceof BsonParser) {
                Object object = ((BsonParser)p).getEmbeddedObject();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.ObjectId");
                }
                objectId = (ObjectId)object;
            } else {
                TreeNode treeNode = p.getCodec().readTree(p);
                Intrinsics.checkExpressionValueIsNotNull((Object)treeNode, (String)"p.codec.readTree(p)");
                TreeNode tree = treeNode;
                if (tree instanceof POJONode) {
                    Object object = ((POJONode)tree).getPojo();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.bson.types.ObjectId");
                    }
                    objectId = (ObjectId)object;
                } else {
                    TreeNode treeNode2 = tree.get("$oid");
                    if (treeNode2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.JsonNode");
                    }
                    objectId = new ObjectId(((JsonNode)treeNode2).textValue());
                }
            }
            return objectId;
        }

        private ObjectIdBsonDeserializer() {
        }

        static {
            ObjectIdBsonDeserializer objectIdBsonDeserializer;
            INSTANCE = objectIdBsonDeserializer = new ObjectIdBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonTimestampBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/BsonTimestamp;", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BsonTimestampBsonSerializer
    extends JsonSerializer<BsonTimestamp> {
        public static final BsonTimestampBsonSerializer INSTANCE;

        public void serialize(@NotNull BsonTimestamp obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBsonTimestamp(obj);
            } else {
                ExtendedJsonModule.BsonTimestampExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }

        private BsonTimestampBsonSerializer() {
        }

        static {
            BsonTimestampBsonSerializer bsonTimestampBsonSerializer;
            INSTANCE = bsonTimestampBsonSerializer = new BsonTimestampBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonTimestampBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/BsonTimestamp;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BsonTimestampBsonDeserializer
    extends JsonDeserializer<BsonTimestamp> {
        public static final BsonTimestampBsonDeserializer INSTANCE;

        @NotNull
        public BsonTimestamp deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            TreeNode tree;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode treeNode = tree = jp.getCodec().readTree(jp);
            Intrinsics.checkExpressionValueIsNotNull((Object)treeNode, (String)"tree");
            if (treeNode.isObject()) {
                TreeNode timestamp = tree.get("$timestamp");
                TreeNode treeNode2 = timestamp.get("t");
                if (treeNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int time = ((ValueNode)treeNode2).asInt();
                TreeNode treeNode3 = timestamp.get("i");
                if (treeNode3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int inc = ((ValueNode)treeNode3).asInt();
                return new BsonTimestamp(time, inc);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonTimestamp");
                }
                return (BsonTimestamp)object;
            }
            Object object = ctxt.handleUnexpectedToken(BsonTimestamp.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonTimestamp");
            }
            return (BsonTimestamp)object;
        }

        private BsonTimestampBsonDeserializer() {
        }

        static {
            BsonTimestampBsonDeserializer bsonTimestampBsonDeserializer;
            INSTANCE = bsonTimestampBsonDeserializer = new BsonTimestampBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BinaryBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/Binary;", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BinaryBsonSerializer
    extends JsonSerializer<Binary> {
        public static final BinaryBsonSerializer INSTANCE;

        public void serialize(@NotNull Binary obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBinary(obj);
            } else {
                ExtendedJsonModule.BinaryExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }

        private BinaryBsonSerializer() {
        }

        static {
            BinaryBsonSerializer binaryBsonSerializer;
            INSTANCE = binaryBsonSerializer = new BinaryBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BinaryBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/Binary;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BinaryBsonDeserializer
    extends JsonDeserializer<Binary> {
        public static final BinaryBsonDeserializer INSTANCE;

        @NotNull
        public Binary deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            TreeNode tree;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode treeNode = tree = jp.getCodec().readTree(jp);
            Intrinsics.checkExpressionValueIsNotNull((Object)treeNode, (String)"tree");
            if (treeNode.isObject()) {
                TreeNode treeNode2 = tree.get("$binary");
                if (treeNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                byte[] binary = Base64Variants.MIME_NO_LINEFEEDS.decode(((ValueNode)treeNode2).asText());
                TreeNode treeNode3 = tree.get("$type");
                if (treeNode3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                String string = ((ValueNode)treeNode3).asText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(tree.get(\"\\$type\") as ValueNode).asText()");
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                Integer n = Integer.valueOf(string4, 16);
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                byte type = (byte)n.intValue();
                return new Binary(type, binary);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.Binary");
                }
                return (Binary)object;
            }
            if (tree instanceof BinaryNode) {
                return new Binary(((BinaryNode)tree).binaryValue());
            }
            Object object = ctxt.handleUnexpectedToken(ObjectId.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.types.Binary");
            }
            return (Binary)object;
        }

        private BinaryBsonDeserializer() {
        }

        static {
            BinaryBsonDeserializer binaryBsonDeserializer;
            INSTANCE = binaryBsonDeserializer = new BinaryBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MaxKeyBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MaxKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class MaxKeyBsonSerializer
    extends JsonSerializer<MaxKey> {
        public static final MaxKeyBsonSerializer INSTANCE;

        public void serialize(@NotNull MaxKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMaxKey();
            } else {
                ExtendedJsonModule.MaxKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }

        private MaxKeyBsonSerializer() {
        }

        static {
            MaxKeyBsonSerializer maxKeyBsonSerializer;
            INSTANCE = maxKeyBsonSerializer = new MaxKeyBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MaxKeyBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/MaxKey;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class MaxKeyBsonDeserializer
    extends JsonDeserializer<MaxKey> {
        public static final MaxKeyBsonDeserializer INSTANCE;

        @NotNull
        public MaxKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            TreeNode tree;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode treeNode = tree = jp.getCodec().readTree(jp);
            Intrinsics.checkExpressionValueIsNotNull((Object)treeNode, (String)"tree");
            if (treeNode.isObject()) {
                TreeNode treeNode2 = tree.get("$maxKey");
                if (treeNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int value = ((ValueNode)treeNode2).asInt();
                if (value == 1) {
                    return new MaxKey();
                }
                Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MaxKey");
                }
                return (MaxKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MaxKey");
                }
                return (MaxKey)object;
            }
            if (tree instanceof TextNode) {
                return new MaxKey();
            }
            Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MaxKey");
            }
            return (MaxKey)object;
        }

        private MaxKeyBsonDeserializer() {
        }

        static {
            MaxKeyBsonDeserializer maxKeyBsonDeserializer;
            INSTANCE = maxKeyBsonDeserializer = new MaxKeyBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MinKeyBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MinKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class MinKeyBsonSerializer
    extends JsonSerializer<MinKey> {
        public static final MinKeyBsonSerializer INSTANCE;

        public void serialize(@NotNull MinKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMinKey();
            } else {
                ExtendedJsonModule.MinKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }

        private MinKeyBsonSerializer() {
        }

        static {
            MinKeyBsonSerializer minKeyBsonSerializer;
            INSTANCE = minKeyBsonSerializer = new MinKeyBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MinKeyBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/MinKey;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class MinKeyBsonDeserializer
    extends JsonDeserializer<MinKey> {
        public static final MinKeyBsonDeserializer INSTANCE;

        @NotNull
        public MinKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            TreeNode tree;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode treeNode = tree = jp.getCodec().readTree(jp);
            Intrinsics.checkExpressionValueIsNotNull((Object)treeNode, (String)"tree");
            if (treeNode.isObject()) {
                TreeNode treeNode2 = tree.get("$minKey");
                if (treeNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int value = ((ValueNode)treeNode2).asInt();
                if (value == 1) {
                    return new MinKey();
                }
                Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MinKey");
                }
                return (MinKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MinKey");
                }
                return (MinKey)object;
            }
            if (tree instanceof TextNode) {
                return new MinKey();
            }
            Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MinKey");
            }
            return (MinKey)object;
        }

        private MinKeyBsonDeserializer() {
        }

        static {
            MinKeyBsonDeserializer minKeyBsonDeserializer;
            INSTANCE = minKeyBsonDeserializer = new MinKeyBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "T", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "()V", "date", "Ljava/util/Date;", "temporal", "(Ljava/lang/Object;)Ljava/util/Date;", "epochMillis", "", "(Ljava/lang/Object;)J", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "kmongo-jackson-mapping"})
    private static abstract class TemporalBsonSerializer<T>
    extends JsonSerializer<T> {
        public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeDateTime(this.date(value));
            } else {
                ExtendedJsonModule.DateExtendedJsonSerializer.INSTANCE.serialize(this.date(value), gen, serializerProvider);
            }
        }

        @NotNull
        public final Date date(T temporal) {
            return new Date(this.epochMillis(temporal));
        }

        public abstract long epochMillis(T var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$CalendarBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/util/Calendar;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class CalendarBsonSerializer
    extends TemporalBsonSerializer<Calendar> {
        public static final CalendarBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull Calendar temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.CalendarExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private CalendarBsonSerializer() {
        }

        static {
            CalendarBsonSerializer calendarBsonSerializer;
            INSTANCE = calendarBsonSerializer = new CalendarBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/ZonedDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class ZonedDateTimeBsonSerializer
    extends TemporalBsonSerializer<ZonedDateTime> {
        public static final ZonedDateTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull ZonedDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private ZonedDateTimeBsonSerializer() {
        }

        static {
            ZonedDateTimeBsonSerializer zonedDateTimeBsonSerializer;
            INSTANCE = zonedDateTimeBsonSerializer = new ZonedDateTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class OffsetDateTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetDateTime> {
        public static final OffsetDateTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull OffsetDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.OffsetDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private OffsetDateTimeBsonSerializer() {
        }

        static {
            OffsetDateTimeBsonSerializer offsetDateTimeBsonSerializer;
            INSTANCE = offsetDateTimeBsonSerializer = new OffsetDateTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDate;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalDateBsonSerializer
    extends TemporalBsonSerializer<LocalDate> {
        public static final LocalDateBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalDate temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalDateExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private LocalDateBsonSerializer() {
        }

        static {
            LocalDateBsonSerializer localDateBsonSerializer;
            INSTANCE = localDateBsonSerializer = new LocalDateBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalTimeBsonSerializer
    extends TemporalBsonSerializer<LocalTime> {
        public static final LocalTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private LocalTimeBsonSerializer() {
        }

        static {
            LocalTimeBsonSerializer localTimeBsonSerializer;
            INSTANCE = localTimeBsonSerializer = new LocalTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class OffsetTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetTime> {
        public static final OffsetTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull OffsetTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.OffsetTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private OffsetTimeBsonSerializer() {
        }

        static {
            OffsetTimeBsonSerializer offsetTimeBsonSerializer;
            INSTANCE = offsetTimeBsonSerializer = new OffsetTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$InstantBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/Instant;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class InstantBsonSerializer
    extends TemporalBsonSerializer<Instant> {
        public static final InstantBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull Instant temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.InstantExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private InstantBsonSerializer() {
        }

        static {
            InstantBsonSerializer instantBsonSerializer;
            INSTANCE = instantBsonSerializer = new InstantBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalDateTimeBsonSerializer
    extends TemporalBsonSerializer<LocalDateTime> {
        public static final LocalDateTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private LocalDateTimeBsonSerializer() {
        }

        static {
            LocalDateTimeBsonSerializer localDateTimeBsonSerializer;
            INSTANCE = localDateTimeBsonSerializer = new LocalDateTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "T", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Ljava/lang/Object;", "toObject", "date", "Ljava/util/Date;", "(Ljava/util/Date;)Ljava/lang/Object;", "kmongo-jackson-mapping"})
    private static abstract class TemporalBsonDeserializer<T>
    extends JsonDeserializer<T> {
        public T deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            Object object = jp.getEmbeddedObject();
            TemporalBsonDeserializer temporalBsonDeserializer = this;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$run = object;
            boolean bl3 = false;
            Date date = $this$run == null ? new Date(jp.getLongValue()) : (Date)$this$run;
            return temporalBsonDeserializer.toObject(date);
        }

        public abstract T toObject(@NotNull Date var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$CalendarBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/util/Calendar;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class CalendarBsonDeserializer
    extends TemporalBsonDeserializer<Calendar> {
        public static final CalendarBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public Calendar toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            boolean bl = false;
            boolean bl2 = false;
            Calendar $this$apply = calendar;
            boolean bl3 = false;
            $this$apply.setTime(date);
            Calendar calendar2 = calendar;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"Calendar.getInstance(Tim\u2026time = date\n            }");
            return calendar2;
        }

        private CalendarBsonDeserializer() {
        }

        static {
            CalendarBsonDeserializer calendarBsonDeserializer;
            INSTANCE = calendarBsonDeserializer = new CalendarBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/ZonedDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class ZonedDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<ZonedDateTime> {
        public static final ZonedDateTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public ZonedDateTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.ofInstant(date.toInstant(), UTC)");
            return zonedDateTime;
        }

        private ZonedDateTimeBsonDeserializer() {
        }

        static {
            ZonedDateTimeBsonDeserializer zonedDateTimeBsonDeserializer;
            INSTANCE = zonedDateTimeBsonDeserializer = new ZonedDateTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class OffsetDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetDateTime> {
        public static final OffsetDateTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public OffsetDateTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"OffsetDateTime.ofInstant(date.toInstant(), UTC)");
            return offsetDateTime;
        }

        private OffsetDateTimeBsonDeserializer() {
        }

        static {
            OffsetDateTimeBsonDeserializer offsetDateTimeBsonDeserializer;
            INSTANCE = offsetDateTimeBsonDeserializer = new OffsetDateTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalDateTime> {
        public static final LocalDateTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public LocalDateTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.ofInstant(date.toInstant(), UTC)");
            return localDateTime;
        }

        private LocalDateTimeBsonDeserializer() {
        }

        static {
            LocalDateTimeBsonDeserializer localDateTimeBsonDeserializer;
            INSTANCE = localDateTimeBsonDeserializer = new LocalDateTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDate;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalDateBsonDeserializer
    extends TemporalBsonDeserializer<LocalDate> {
        public static final LocalDateBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public LocalDate toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            LocalDate localDate = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDateTimeBsonDeseria\u2026bject(date).toLocalDate()");
            return localDate;
        }

        private LocalDateBsonDeserializer() {
        }

        static {
            LocalDateBsonDeserializer localDateBsonDeserializer;
            INSTANCE = localDateBsonDeserializer = new LocalDateBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalTime> {
        public static final LocalTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public LocalTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            LocalTime localTime = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"LocalDateTimeBsonDeseria\u2026bject(date).toLocalTime()");
            return localTime;
        }

        private LocalTimeBsonDeserializer() {
        }

        static {
            LocalTimeBsonDeserializer localTimeBsonDeserializer;
            INSTANCE = localTimeBsonDeserializer = new LocalTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class OffsetTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetTime> {
        public static final OffsetTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public OffsetTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            OffsetTime offsetTime = OffsetDateTimeBsonDeserializer.INSTANCE.toObject(date).toOffsetTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime, (String)"OffsetDateTimeBsonDeseri\u2026ject(date).toOffsetTime()");
            return offsetTime;
        }

        private OffsetTimeBsonDeserializer() {
        }

        static {
            OffsetTimeBsonDeserializer offsetTimeBsonDeserializer;
            INSTANCE = offsetTimeBsonDeserializer = new OffsetTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$InstantBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/Instant;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class InstantBsonDeserializer
    extends TemporalBsonDeserializer<Instant> {
        public static final InstantBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public Instant toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            Instant instant = date.toInstant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"date.toInstant()");
            return instant;
        }

        private InstantBsonDeserializer() {
        }

        static {
            InstantBsonDeserializer instantBsonDeserializer;
            INSTANCE = instantBsonDeserializer = new InstantBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$IdBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/litote/kmongo/Id;", "()V", "serialize", "", "id", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class IdBsonSerializer
    extends JsonSerializer<Id<?>> {
        public static final IdBsonSerializer INSTANCE;

        public void serialize(@NotNull Id<?> id, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull(id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            Object object = IdTransformer.INSTANCE.unwrapId(id);
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            Object object2 = it;
            if (object2 instanceof String) {
                generator.writeString((String)it);
            } else if (object2 instanceof ObjectId) {
                ObjectIdBsonSerializer.INSTANCE.serialize((ObjectId)it, generator, provider);
            } else {
                String string = "unsupported id type " + id;
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        private IdBsonSerializer() {
        }

        static {
            IdBsonSerializer idBsonSerializer;
            INSTANCE = idBsonSerializer = new IdBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$IdBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lorg/litote/kmongo/Id;", "()V", "kmongo-jackson-mapping"})
    private static final class IdBsonDeserializer
    extends AbstractIdBsonDeserializer<Id<?>> {
        public static final IdBsonDeserializer INSTANCE;

        private IdBsonDeserializer() {
        }

        static {
            IdBsonDeserializer idBsonDeserializer;
            INSTANCE = idBsonDeserializer = new IdBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$StringIdBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lorg/litote/kmongo/id/StringId;", "()V", "kmongo-jackson-mapping"})
    private static final class StringIdBsonDeserializer
    extends AbstractIdBsonDeserializer<StringId<?>> {
        public static final StringIdBsonDeserializer INSTANCE;

        private StringIdBsonDeserializer() {
        }

        static {
            StringIdBsonDeserializer stringIdBsonDeserializer;
            INSTANCE = stringIdBsonDeserializer = new StringIdBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$WrappedObjectIdBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lorg/litote/kmongo/id/WrappedObjectId;", "()V", "kmongo-jackson-mapping"})
    private static final class WrappedObjectIdBsonDeserializer
    extends AbstractIdBsonDeserializer<WrappedObjectId<?>> {
        public static final WrappedObjectIdBsonDeserializer INSTANCE;

        private WrappedObjectIdBsonDeserializer() {
        }

        static {
            WrappedObjectIdBsonDeserializer wrappedObjectIdBsonDeserializer;
            INSTANCE = wrappedObjectIdBsonDeserializer = new WrappedObjectIdBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "T", "Lorg/litote/kmongo/Id;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Lorg/litote/kmongo/Id;", "kmongo-jackson-mapping"})
    private static abstract class AbstractIdBsonDeserializer<T extends Id<?>>
    extends JsonDeserializer<T> {
        @NotNull
        public T deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Id id;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            if (jp.getCurrentToken() == JsonToken.VALUE_STRING) {
                String string = jp.getValueAsString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jp.valueAsString");
                id = IdTransformer.INSTANCE.wrapId((Object)string);
                if (id == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
            } else {
                IdTransformer idTransformer = IdTransformer.INSTANCE;
                Object object = jp.getEmbeddedObject();
                if (object == null) {
                    JsonToken jsonToken = jp.getCurrentToken();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonToken, (String)"jp.currentToken");
                    Object object2 = StringDeserializationProblemHandler.INSTANCE.handleUnexpectedToken(ctxt, String.class, jsonToken, jp, "");
                    IdTransformer idTransformer2 = idTransformer;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)DeserializationProblemHandler.NOT_HANDLED)) {
                        String string = "not valid object found when trying to deserialize Id";
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Object object3 = it;
                    idTransformer = idTransformer2;
                    object = object3;
                }
                if ((id = idTransformer.wrapId(object)) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
            }
            return (T)id;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BigDecimalBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/math/BigDecimal;", "()V", "serialize", "", "decimal", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BigDecimalBsonSerializer
    extends JsonSerializer<BigDecimal> {
        public static final BigDecimalBsonSerializer INSTANCE;

        public void serialize(@NotNull BigDecimal decimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)decimal, (String)"decimal");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeNumber(decimal);
        }

        private BigDecimalBsonSerializer() {
        }

        static {
            BigDecimalBsonSerializer bigDecimalBsonSerializer;
            INSTANCE = bigDecimalBsonSerializer = new BigDecimalBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BigDecimalBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/math/BigDecimal;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BigDecimalBsonDeserializer
    extends JsonDeserializer<BigDecimal> {
        public static final BigDecimalBsonDeserializer INSTANCE;

        @NotNull
        public BigDecimal deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            BigDecimal bigDecimal;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            if (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
                bigDecimal = new BigDecimal(jp.getDoubleValue());
            } else {
                BigDecimal bigDecimal2;
                Object v = jp.getEmbeddedObject();
                Object object = v;
                if (object instanceof Integer) {
                    bigDecimal2 = new BigDecimal(((Number)v).intValue());
                } else if (object instanceof Long) {
                    bigDecimal2 = new BigDecimal(((Number)v).longValue());
                } else if (object instanceof Float) {
                    bigDecimal2 = new BigDecimal(((Number)v).floatValue());
                } else if (object instanceof Double) {
                    bigDecimal2 = new BigDecimal(((Number)v).doubleValue());
                } else if (object instanceof Decimal128) {
                    bigDecimal2 = ((Decimal128)v).bigDecimalValue();
                } else if (object instanceof String) {
                    bigDecimal2 = new BigDecimal((String)v);
                } else {
                    throw (Throwable)new ClassCastException(v.getClass().getName() + " cannot be cast to " + BigDecimal.class.getName() + ": " + v);
                }
                bigDecimal = bigDecimal2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"when (v) {\n             \u2026      )\n                }");
            }
            return bigDecimal;
        }

        private BigDecimalBsonDeserializer() {
        }

        static {
            BigDecimalBsonDeserializer bigDecimalBsonDeserializer;
            INSTANCE = bigDecimalBsonDeserializer = new BigDecimalBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$Decimal128BsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lde/undercouch/bson4jackson/types/Decimal128;", "()V", "serialize", "", "decimal", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class Decimal128BsonSerializer
    extends JsonSerializer<Decimal128> {
        public static final Decimal128BsonSerializer INSTANCE;

        public void serialize(@NotNull Decimal128 decimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)decimal, (String)"decimal");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            BigDecimal bigDecimal = decimal.bigDecimalValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"decimal.bigDecimalValue()");
            BigDecimalBsonSerializer.INSTANCE.serialize(bigDecimal, generator, provider);
        }

        private Decimal128BsonSerializer() {
        }

        static {
            Decimal128BsonSerializer decimal128BsonSerializer;
            INSTANCE = decimal128BsonSerializer = new Decimal128BsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$Decimal128BsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lde/undercouch/bson4jackson/types/Decimal128;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class Decimal128BsonDeserializer
    extends JsonDeserializer<Decimal128> {
        public static final Decimal128BsonDeserializer INSTANCE;

        @NotNull
        public Decimal128 deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            return new Decimal128(BigDecimalBsonDeserializer.INSTANCE.deserialize(jp, ctxt));
        }

        private Decimal128BsonDeserializer() {
        }

        static {
            Decimal128BsonDeserializer decimal128BsonDeserializer;
            INSTANCE = decimal128BsonDeserializer = new Decimal128BsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u00020\u00052\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KPropertySerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lkotlin/reflect/KProperty;", "()V", "acceptJsonFormatVisitor", "", "visitor", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonFormatVisitorWrapper;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "serialize", "property", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class KPropertySerializer
    extends JsonSerializer<KProperty<?>> {
        public static final KPropertySerializer INSTANCE;

        public void serialize(@NotNull KProperty<?> property, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull(property, (String)"property");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeString(ProjectionsKt.getProjection(property));
        }

        public void acceptJsonFormatVisitor(@NotNull JsonFormatVisitorWrapper visitor, @NotNull JavaType type) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            visitor.expectStringFormat(type);
        }

        private KPropertySerializer() {
        }

        static {
            KPropertySerializer kPropertySerializer;
            INSTANCE = kPropertySerializer = new KPropertySerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZoneIdBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/time/ZoneId;", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class ZoneIdBsonSerializer
    extends JsonSerializer<ZoneId> {
        public static final ZoneIdBsonSerializer INSTANCE;

        public void serialize(@NotNull ZoneId obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            gen.writeString(obj.toString());
        }

        private ZoneIdBsonSerializer() {
        }

        static {
            ZoneIdBsonSerializer zoneIdBsonSerializer;
            INSTANCE = zoneIdBsonSerializer = new ZoneIdBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZoneIdBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/time/ZoneId;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class ZoneIdBsonDeserializer
    extends JsonDeserializer<ZoneId> {
        public static final ZoneIdBsonDeserializer INSTANCE;

        @NotNull
        public ZoneId deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            ZoneId zoneId = ZoneId.of(jp.getValueAsString());
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId, (String)"ZoneId.of(jp.valueAsString)");
            return zoneId;
        }

        private ZoneIdBsonDeserializer() {
        }

        static {
            ZoneIdBsonDeserializer zoneIdBsonDeserializer;
            INSTANCE = zoneIdBsonDeserializer = new ZoneIdBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonDateDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/util/Date;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BsonDateDeserializer
    extends JsonDeserializer<Date> {
        public static final BsonDateDeserializer INSTANCE;

        @NotNull
        public Date deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Object object;
            block9: {
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
                    Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
                    if (jp instanceof BsonParser) {
                        if (((BsonParser)jp).getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || ((BsonParser)jp).getCurrentBsonType() != 9) {
                            Object object2 = ctxt.handleUnexpectedToken(Date.class, jp);
                            if (object2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                            }
                            throw (Throwable)object2;
                        }
                        Object object3 = ((BsonParser)jp).getEmbeddedObject();
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Date");
                        }
                        return (Date)object3;
                    }
                    object = jp.getEmbeddedObject();
                    if (object == null) break block8;
                    Object object4 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object4;
                    boolean bl3 = false;
                    Object object5 = it;
                    if (object5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Date");
                    }
                    object = (Date)object5;
                    if (object != null) break block9;
                }
                object = new Date(jp.getLongValue());
            }
            return object;
        }

        private BsonDateDeserializer() {
        }

        static {
            BsonDateDeserializer bsonDateDeserializer;
            INSTANCE = bsonDateDeserializer = new BsonDateDeserializer();
        }
    }
}

