/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.common.model;

import chat.rocket.common.model.Email;
import chat.rocket.common.model.User;
import chat.rocket.common.model.UserStatus;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

public final class KotshiUserJsonAdapter
extends NamedJsonAdapter<User> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"_id", "username", "name", "status", "utcOffset", "emails", "roles"});
    private final JsonAdapter<UserStatus> adapter0;
    private final JsonAdapter<List<Email>> adapter1;
    private final JsonAdapter<List<String>> adapter2;

    public KotshiUserJsonAdapter(Moshi moshi) {
        super("KotshiJsonAdapter(User)");
        this.adapter0 = moshi.adapter(UserStatus.class);
        this.adapter1 = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{Email.class}));
        this.adapter2 = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{String.class}));
    }

    public void toJson(JsonWriter writer, User value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("_id");
        writer.value(value.getId());
        writer.name("username");
        writer.value(value.getUsername());
        writer.name("name");
        writer.value(value.getName());
        writer.name("status");
        this.adapter0.toJson(writer, (Object)value.getStatus());
        writer.name("utcOffset");
        writer.value((Number)value.getUtcOffset());
        writer.name("emails");
        this.adapter1.toJson(writer, value.getEmails());
        writer.name("roles");
        this.adapter2.toJson(writer, value.getRoles());
        writer.endObject();
    }

    public User fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (User)reader.nextNull();
        }
        reader.beginObject();
        String id = null;
        String username = null;
        String name = null;
        UserStatus status = null;
        Float utcOffset = null;
        List emails = null;
        List roles = null;
        block10: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block10;
                    }
                    id = reader.nextString();
                    continue block10;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block10;
                    }
                    username = reader.nextString();
                    continue block10;
                }
                case 2: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block10;
                    }
                    name = reader.nextString();
                    continue block10;
                }
                case 3: {
                    status = (UserStatus)this.adapter0.fromJson(reader);
                    continue block10;
                }
                case 4: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block10;
                    }
                    utcOffset = Float.valueOf(KotshiUtils.nextFloat((JsonReader)reader));
                    continue block10;
                }
                case 5: {
                    emails = (List)this.adapter1.fromJson(reader);
                    continue block10;
                }
                case 6: {
                    roles = (List)this.adapter2.fromJson(reader);
                    continue block10;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block10;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (id == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"id");
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new User(id, username, name, status, utcOffset, emails, roles);
    }
}

