/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandFailedException;
import liquibase.command.CommandScope;
import liquibase.command.core.CalculateChecksumCommandStep;
import liquibase.command.core.ChangelogSyncToTagCommandStep;
import liquibase.command.core.ChangelogSyncToTagSqlCommandStep;
import liquibase.command.core.DbDocCommandStep;
import liquibase.command.core.FutureRollbackCountSqlCommandStep;
import liquibase.command.core.FutureRollbackFromTagSqlCommandStep;
import liquibase.command.core.ProCommandsRegistry;
import liquibase.command.core.RollbackCommandStep;
import liquibase.command.core.RollbackCountCommandStep;
import liquibase.command.core.RollbackToDateCommandStep;
import liquibase.command.core.TagCommandStep;
import liquibase.command.core.TagExistsCommandStep;
import liquibase.command.core.UpdateCountCommandStep;
import liquibase.command.core.UpdateCountSqlCommandStep;
import liquibase.command.core.UpdateToTagCommandStep;
import liquibase.command.core.UpdateToTagSqlCommandStep;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.CommandValidationException;
import liquibase.exception.ExitCodeException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.IntegrationDetails;
import liquibase.integration.commandline.Banner;
import liquibase.integration.commandline.CommandLineArgumentValueProvider;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.integration.commandline.CommandRunner;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.integration.commandline.Main;
import liquibase.license.LicenseInfo;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.core.JavaLogService;
import liquibase.logging.core.LogServiceFactory;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcManager;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsUpdated;
import liquibase.logging.mdc.customobjects.Version;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import liquibase.ui.CompositeUIService;
import liquibase.ui.ConsoleUIService;
import liquibase.ui.LoggerUIService;
import liquibase.ui.UIService;
import liquibase.ui.UIServiceEnum;
import liquibase.util.BooleanUtil;
import liquibase.util.ExceptionUtil;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.LogUtil;
import liquibase.util.NetUtil;
import liquibase.util.StringUtil;
import liquibase.util.SystemUtil;
import liquibase.util.VersionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;
import picocli.CommandLine;

public class LiquibaseCommandLine {
    public static final String COMMAND_ARGUMENTS = "commandArguments";
    private final Map<String, String> legacyPositionalArguments;
    private final Set<String> legacyNoLongerGlobalArguments;
    private final Set<String> legacyNoLongerCommandArguments;
    private Level configuredLogLevel;
    private final CommandLine commandLine;
    private Handler fileHandler;
    private final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private CommandLine.IFactory defaultFactory = new CommandLine.IFactory(){

        public <K> K create(Class<K> cls) throws Exception {
            return cls.newInstance();
        }
    };

    public static void main(String[] args) {
        System.setProperty("org.fusesource.jansi.Ansi.disable", "true");
        if (args.length > 1 && LiquibaseCommandLine.azureArgumentIsPresent(args)) {
            try {
                Class.forName("liquibase.resource.azure.AzurePathHandler");
            }
            catch (ClassNotFoundException ignored) {
                System.out.println("The Liquibase Azure Extension 1.0.0 or higher is required to use Azure Storage. Visit https://docs.liquibase.com/pro-extensions to acquire the Azure Extension.");
                Scope.getCurrentScope().getLog(LiquibaseCommandLine.class).severe("The Liquibase Azure Extension 1.0.0 or higher is required to use Azure Storage. Visit https://docs.liquibase.com/pro-extensions to acquire the Azure Extension.");
                System.exit(1);
            }
        }
        LiquibaseCommandLine cli = new LiquibaseCommandLine();
        int returnCode = cli.execute(args);
        System.exit(returnCode);
    }

    private static boolean azureArgumentIsPresent(String[] args) {
        for (String arg : args) {
            if (!arg.replace("-", "").toLowerCase().contains("azurestorage")) continue;
            return true;
        }
        return false;
    }

    private void cleanup() {
        if (this.fileHandler != null) {
            this.fileHandler.flush();
        }
    }

    public LiquibaseCommandLine() {
        this.legacyPositionalArguments = new HashMap<String, String>();
        this.legacyPositionalArguments.put("calculatechecksum", CalculateChecksumCommandStep.CHANGESET_IDENTIFIER_ARG.getName());
        this.legacyPositionalArguments.put("changelogsynctotag", ChangelogSyncToTagCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("changelogsynctotagsql", ChangelogSyncToTagSqlCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("dbdoc", DbDocCommandStep.OUTPUT_DIRECTORY_ARG.getName());
        this.legacyPositionalArguments.put("futurerollbackcountsql", FutureRollbackCountSqlCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("futurerollbackfromtagsql", FutureRollbackFromTagSqlCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("tag", TagCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("tagexists", TagExistsCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("rollback", RollbackCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("rollbacksql", RollbackCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("rollbacktodate", RollbackToDateCommandStep.DATE_ARG.getName());
        this.legacyPositionalArguments.put("rollbacktodatesql", RollbackToDateCommandStep.DATE_ARG.getName());
        this.legacyPositionalArguments.put("rollbackcount", RollbackCountCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("rollbackcountsql", RollbackCountCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("updatecount", UpdateCountCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("updatecountsql", UpdateCountSqlCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("updatetotag", UpdateToTagCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("updatetotagsql", UpdateToTagSqlCommandStep.TAG_ARG.getName());
        this.legacyNoLongerGlobalArguments = Stream.of("username", "password", "url", "outputDefaultSchema", "outputDefaultCatalog", "changelogFile", "contexts", "labels", "diffTypes", "changesetAuthor", "changesetContext", "dataOutputDirectory", "referenceDriver", "referenceUrl", "referenceUsername", "referencePassword", "referenceDefaultCatalogName", "referenceDefaultSchemaName", "excludeObjects", "includeCatalog", "includeObjects", "includeSchema", "includeTablespace", "outputSchemasAs", "referenceSchemas", "schemas", "snapshotFormat", "sqlFile", "delimiter", "rollbackScript", "overwriteOutputFile", "changeExecListenerClass", "changeExecListenerPropertiesFile", "defaultSchemaName", "defaultCatalogName").collect(Collectors.toSet());
        this.legacyNoLongerCommandArguments = Stream.of("databaseClass", "liquibaseCatalogName", "liquibaseSchemaName", "databaseChangeLogTableName", "databaseChangeLogLockTableName", "classpath", "propertyProviderClass", "promptForNonLocalDatabase", "includeSystemClasspath", "defaultsFile", "currentDateTimeFunction", "logLevel", "logFile", "outputFile", "liquibaseProLicenseKey", "outputFileEncoding", "outputLineSeparator").collect(Collectors.toSet());
        this.commandLine = this.buildPicoCommandLine();
    }

    private CommandLine buildPicoCommandLine() {
        CommandLine.Model.CommandSpec rootCommandSpec = CommandLine.Model.CommandSpec.wrapWithoutInspection(null, (CommandLine.IFactory)this.defaultFactory);
        rootCommandSpec.name("liquibase");
        this.configureHelp(rootCommandSpec, true);
        rootCommandSpec.subcommandsCaseInsensitive(true);
        rootCommandSpec.usageMessage().customSynopsis(new String[]{"liquibase [GLOBAL OPTIONS] [COMMAND] [COMMAND OPTIONS]\nCommand-specific help: \"liquibase <command-name> --help\""}).optionListHeading("\nGlobal Options\n").commandListHeading("\nCommands\n");
        CommandLine cmdLine = new CommandLine((Object)rootCommandSpec, this.defaultFactory).setCaseInsensitiveEnumValuesAllowed(true).setOptionsCaseInsensitive(true).setUsageHelpAutoWidth(true);
        this.addGlobalArguments(cmdLine);
        for (CommandDefinition commandDefinition : this.getCommands()) {
            this.addSubcommand(commandDefinition, cmdLine);
        }
        cmdLine.setExecutionExceptionHandler((ex, commandLine1, parseResult) -> this.handleException(ex));
        cmdLine.setUsageHelpAutoWidth(true);
        return cmdLine;
    }

    protected int handleException(Throwable exception) {
        Integer exitCode;
        StringBuilder uiMessage = new StringBuilder();
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            String newMessage = StringUtils.trimToNull((String)this.cleanExceptionMessage(cause.getMessage()));
            if (newMessage == null || String.valueOf(uiMessage).contains(newMessage)) continue;
            if (!String.valueOf(uiMessage).isEmpty()) {
                uiMessage.append(System.lineSeparator()).append("  - Caused by: ");
            }
            uiMessage.append(newMessage);
        }
        if (StringUtils.isEmpty((CharSequence)uiMessage)) {
            uiMessage = new StringBuilder(exception.getClass().getName());
        }
        Level level = this.determineLogLevel(exception);
        if (ExceptionUtil.showExceptionInLog((Throwable)exception)) {
            Scope.getCurrentScope().getLog(this.getClass()).log(level, String.valueOf(uiMessage), exception);
        }
        boolean printUsage = false;
        try (StringWriter suggestionWriter = new StringWriter();
             PrintWriter suggestionsPrintWriter = new PrintWriter(suggestionWriter);){
            if (exception instanceof CommandLine.ParameterException) {
                if (exception instanceof CommandLine.UnmatchedArgumentException) {
                    List unmatchedArgs = ((CommandLine.UnmatchedArgumentException)exception).getUnmatched();
                    String proCommandError = this.checkForProCommandError(unmatchedArgs);
                    if (proCommandError != null) {
                        System.err.println(proCommandError);
                    } else {
                        System.err.println("Unexpected argument(s): " + StringUtil.join((Collection)unmatchedArgs, (String)", "));
                    }
                } else {
                    System.err.println("Error parsing command line: " + String.valueOf(uiMessage));
                }
                CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)((CommandLine.ParameterException)exception), (PrintWriter)suggestionsPrintWriter);
                printUsage = true;
            } else if (exception instanceof IllegalArgumentException || exception instanceof CommandValidationException || exception instanceof CommandLineParsingException) {
                System.err.println("Error parsing command line: " + String.valueOf(uiMessage));
                printUsage = true;
            } else if (exception.getCause() instanceof CommandFailedException) {
                System.err.println(uiMessage);
            } else {
                System.err.println("\nUnexpected error running Liquibase: " + String.valueOf(uiMessage));
                System.err.println();
                if (Level.OFF.equals(this.configuredLogLevel)) {
                    System.err.println("For more information, please use the --log-level flag");
                } else if (LiquibaseCommandLineConfiguration.LOG_FILE.getCurrentValue() == null && !CommandScope.isSuppressExceptionLogging()) {
                    exception.printStackTrace(System.err);
                }
            }
            if (printUsage) {
                System.err.println();
                System.err.println("For detailed help, try 'liquibase --help' or 'liquibase <command-name> --help'");
            }
            suggestionsPrintWriter.flush();
            String suggestions = suggestionWriter.toString();
            if (!suggestions.isEmpty()) {
                System.err.println();
                System.err.println(suggestions);
            }
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Error closing stream: " + e.getMessage(), (Throwable)e);
        }
        Throwable exitCodeException = ExceptionUtil.findExceptionInCauseChain((Throwable)exception, ExitCodeException.class);
        if (exitCodeException != null && (exitCode = ((ExitCodeException)exitCodeException.getCause()).getExitCode()) != null) {
            return exitCode;
        }
        return 1;
    }

    private Level determineLogLevel(Throwable throwable) {
        if (throwable == null) {
            return Level.SEVERE;
        }
        Level returnLevel = Level.SEVERE;
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!(t instanceof LiquibaseException) || ((LiquibaseException)t).getLogLevel() == null) continue;
            returnLevel = ((LiquibaseException)t).getLogLevel();
        }
        return returnLevel;
    }

    protected String cleanExceptionMessage(String message) {
        String originalMessage;
        if (message == null) {
            return null;
        }
        do {
            originalMessage = message;
            message = message.replaceFirst("^[\\w.]*Exception: ", "");
        } while (!originalMessage.equals(message = message.replaceFirst("^[\\w.]*Error: ", "")));
        message = message.replace("Unexpected error running Liquibase: ", "");
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args) {
        try {
            String[] finalArgs = this.adjustLpmArgs(this.adjustLegacyArgs(args));
            this.configureLogging(Level.OFF, null);
            Main.setRunningFromNewCli((boolean)true);
            List<ConfigurationValueProvider> valueProviders = this.registerValueProviders(finalArgs);
            LogService newLogService = (LogService)Scope.child(Collections.singletonMap("REGISTERED_VALUE_PROVIDERS", true), () -> ((LogServiceFactory)Scope.getCurrentScope().getSingleton(LogServiceFactory.class)).getDefaultLogService());
            int n = (Integer)Scope.child(Collections.singletonMap(Scope.Attr.logService.name(), newLogService), () -> {
                this.addEmptyMdcValues();
                try {
                    Integer n = (Integer)Scope.child(this.configureScope(args), () -> {
                        Boolean shouldExecuteCmd = (Boolean)LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentValue();
                        if (!Boolean.TRUE.equals(shouldExecuteCmd)) {
                            Scope.getCurrentScope().getUI().sendErrorMessage(String.format(this.coreBundle.getString("did.not.run.because.param.was.set.to.false"), LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentConfiguredValue().getProvidedValue().getActualKey()));
                            return 0;
                        }
                        this.configureVersionInfo();
                        if (!this.wasHelpOrVersionRequested()) {
                            Scope.getCurrentScope().getUI().sendMessage(CommandLineUtils.getBanner());
                            Scope.getCurrentScope().getUI().sendMessage(String.format(this.coreBundle.getString("version.number"), LiquibaseUtil.getBuildVersionInfo()));
                            LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
                            if (licenseService != null) {
                                Scope.getCurrentScope().getUI().sendMessage(licenseService.getLicenseInfo());
                            }
                        }
                        this.enableMonitoring();
                        this.logMdcData();
                        int response = this.commandLine.execute(finalArgs);
                        if (!this.wasHelpOrVersionRequested()) {
                            ConfiguredValue logFile = LiquibaseCommandLineConfiguration.LOG_FILE.getCurrentConfiguredValue();
                            if (logFile.found()) {
                                Scope.getCurrentScope().getUI().sendMessage("Logs saved to " + (String)logFile.getValue());
                            }
                            if (response == 0) {
                                ConfiguredValue outputFile = LiquibaseCommandLineConfiguration.OUTPUT_FILE.getCurrentConfiguredValue();
                                if (outputFile.found()) {
                                    Scope.getCurrentScope().getUI().sendMessage("Output saved to " + (String)outputFile.getValue());
                                }
                                List commandList = this.commandLine.getParseResult().asCommandLineList();
                                String commandName = StringUtil.join((String[])LiquibaseCommandLine.getCommandNames((CommandLine)commandList.get(commandList.size() - 1)), (String)" ");
                                Scope.getCurrentScope().getUI().sendMessage("Liquibase command '" + commandName + "' was executed successfully.");
                            }
                        }
                        return response;
                    });
                    return n;
                }
                finally {
                    LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
                    for (ConfigurationValueProvider provider : valueProviders) {
                        liquibaseConfiguration.unregisterProvider(provider);
                    }
                    LogUtil.setPersistedMdcKeysToEmptyString();
                }
            });
            return n;
        }
        catch (Throwable e) {
            this.handleException(e);
            int n = 1;
            return n;
        }
        finally {
            this.cleanup();
        }
    }

    private String[] adjustLpmArgs(String[] strings) {
        ArrayList<String> returnArgs = new ArrayList<String>();
        StringBuilder lpmArgs = null;
        Set<String> knownFlags = this.discoverLpmCommandFlags();
        for (String arg : strings) {
            if (lpmArgs == null) {
                returnArgs.add(arg);
                if (!"lpm".equals(arg.toLowerCase())) continue;
                lpmArgs = new StringBuilder();
                continue;
            }
            if (knownFlags.stream().noneMatch(arg::startsWith)) {
                lpmArgs.append(arg).append(" ");
                continue;
            }
            returnArgs.add(arg);
        }
        if (lpmArgs != null) {
            Scope.getCurrentScope().setLpmArgs(lpmArgs.toString().trim());
        }
        return returnArgs.toArray(new String[0]);
    }

    private Set<String> discoverLpmCommandFlags() {
        HashSet<String> flags = new HashSet<String>();
        try {
            CommandFactory commandFactory = (CommandFactory)Scope.getCurrentScope().getSingleton(CommandFactory.class);
            CommandDefinition lpmCommandDefinition = commandFactory.getCommandDefinition(new String[]{"lpm"});
            if (lpmCommandDefinition != null) {
                for (CommandArgumentDefinition argumentDefinition : lpmCommandDefinition.getArguments().values()) {
                    String argumentName = argumentDefinition.getName();
                    if (argumentName == null) continue;
                    flags.add("--" + argumentName);
                    if (argumentName.equals(StringUtil.toKabobCase((String)argumentName))) continue;
                    flags.add("--" + StringUtil.toKabobCase((String)argumentName));
                }
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Could not discover LPM command flags using CommandFactory: " + e.getMessage());
        }
        return flags;
    }

    private void addEmptyMdcValues() {
        Boolean addEmptyMdcValues = (Boolean)LiquibaseCommandLineConfiguration.ADD_EMPTY_MDC_VALUES.getCurrentValue();
        if (Boolean.TRUE.equals(addEmptyMdcValues)) {
            Scope.getCurrentScope().addMdcValue("deploymentId", "");
            Scope.getCurrentScope().addMdcValue("deploymentOutcome", "NOOP");
            Scope.getCurrentScope().addMdcValue("deploymentOutcomeCount", "0");
            Scope.getCurrentScope().addMdcValue("rowsAffected", "0");
            Scope.getCurrentScope().addMdcValue("changelogFile", "");
            LogUtil.setPersistedMdcKeysToEmptyString();
            Scope.getCurrentScope().addMdcValue("changesetOutcome", "NOOP");
            Scope.getCurrentScope().addMdcValue("changesetsUpdated", (CustomMdcObject)new ChangesetsUpdated());
            Scope.getCurrentScope().addMdcValue("operationStart", "");
            Scope.getCurrentScope().addMdcValue("operationStop", "");
            Scope.getCurrentScope().addMdcValue("liquibaseSystemName", "");
            Scope.getCurrentScope().addMdcValue("liquibaseSystemUser", "", false);
            Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", "");
            Scope.getCurrentScope().addMdcValue("liquibaseVersion", "");
            Scope.getCurrentScope().addMdcValue("liquibaseSchemaName", "");
            Scope.getCurrentScope().addMdcValue("liquibaseCatalogName", "");
        }
    }

    private void logMdcData() {
        MdcManager mdcManager = Scope.getCurrentScope().getMdcManager();
        String localHostName = NetUtil.getLocalHostName();
        Scope.getCurrentScope().addMdcValue("liquibaseSystemUser", SystemProperties.getUserName(), false);
        try (MdcObject version = mdcManager.put("liquibaseVersion", LiquibaseUtil.getBuildVersion());
             MdcObject systemName = mdcManager.put("liquibaseSystemName", localHostName);
             MdcObject hostName = mdcManager.put("liquibaseHostName", localHostName);){
            Scope.getCurrentScope().getLog(this.getClass()).info("Starting command execution.");
        }
    }

    String checkForProCommandError(List<String> unmatchedArgs) {
        if (unmatchedArgs == null || unmatchedArgs.isEmpty()) {
            return null;
        }
        String firstArg = unmatchedArgs.get(0);
        if (ProCommandsRegistry.isProCommand((String)firstArg)) {
            String secondArg;
            if (unmatchedArgs.size() > 1 && ProCommandsRegistry.isProSubcommand((String)firstArg, (String)(secondArg = unmatchedArgs.get(1)))) {
                return String.format(this.coreBundle.getString("pro.subcommand.requires.license"), firstArg, secondArg);
            }
            return String.format(this.coreBundle.getString("pro.command.requires.license"), firstArg);
        }
        return null;
    }

    protected void enableMonitoring() {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        try {
            String monitorPerformanceValue = (String)LiquibaseCommandLineConfiguration.MONITOR_PERFORMANCE.getCurrentValue();
            if (monitorPerformanceValue == null || monitorPerformanceValue.equalsIgnoreCase("false")) {
                log.fine("Performance monitoring disabled");
                return;
            }
            if (!SystemUtil.isAtLeastJava11()) {
                Scope.getCurrentScope().getUI().sendMessage("Performance monitoring requires Java 11 or greater. Version " + SystemUtil.getJavaVersion() + " is not supported.");
                return;
            }
            Object filename = monitorPerformanceValue;
            if (((String)filename).equalsIgnoreCase("true")) {
                filename = "liquibase-" + new ISODateFormat().format(new Date()).replaceAll("\\W", "_") + ".jfr";
            }
            if (!((String)filename).endsWith(".jfr")) {
                filename = (String)filename + ".jfr";
            }
            Class<?> configurationClass = Class.forName("jdk.jfr.Configuration");
            Class<?> recordingClass = Class.forName("jdk.jfr.Recording");
            Object configuration = configurationClass.getMethod("getConfiguration", String.class).invoke(null, "profile");
            Object recording = recordingClass.getConstructor(configurationClass).newInstance(configuration);
            recordingClass.getMethod("setMaxSize", Long.TYPE).invoke(recording, 0L);
            recordingClass.getMethod("setMaxAge", Duration.class).invoke(recording, new Object[]{null});
            recordingClass.getMethod("setDumpOnExit", Boolean.TYPE).invoke(recording, true);
            recordingClass.getMethod("setToDisk", Boolean.TYPE).invoke(recording, true);
            recordingClass.getMethod("disable", String.class).invoke(recording, "jdk.InitialEnvironmentVariable");
            recordingClass.getMethod("disable", String.class).invoke(recording, "jdk.InitialSystemProperty");
            recordingClass.getMethod("disable", String.class).invoke(recording, "jdk.SystemProcess");
            recordingClass.getMethod("disable", String.class).invoke(recording, "jdk.JVMInformation");
            File filePath = new File((String)filename).getAbsoluteFile();
            filePath.getParentFile().mkdirs();
            recordingClass.getMethod("setDestination", Path.class).invoke(recording, filePath.toPath());
            recordingClass.getMethod("start", new Class[0]).invoke(recording, new Object[0]);
            Scope.getCurrentScope().getUI().sendMessage("Saving performance data to " + filePath.getAbsolutePath());
        }
        catch (Throwable e) {
            String message = "Error enabling performance monitoring: " + e.getMessage();
            Scope.getCurrentScope().getUI().sendMessage(message);
            log.warning(message, e);
        }
    }

    private boolean wasHelpOrVersionRequested() {
        for (CommandLine.ParseResult parseResult = this.commandLine.getParseResult(); parseResult != null; parseResult = parseResult.subcommand()) {
            if (!parseResult.isUsageHelpRequested() && !parseResult.isVersionHelpRequested()) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> addJavaPropertiesToChangelogParameters() {
        CommandLine.ParseResult subcommandParseResult = this.commandLine.getParseResult();
        while (subcommandParseResult.hasSubcommand()) {
            subcommandParseResult = subcommandParseResult.subcommand();
        }
        Map changelogParameters = (Map)subcommandParseResult.matchedOptionValue("-D", new HashMap());
        if (changelogParameters.size() != 0) {
            Main.setNewCliChangelogParameters((Map)changelogParameters);
        }
        return changelogParameters;
    }

    protected String[] adjustLegacyArgs(String[] args) {
        ArrayList<Object> returnArgs = new ArrayList<Object>();
        ListIterator<String> iterator = Arrays.asList(args).listIterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            String argAsKey = arg.replace("-", "").toLowerCase();
            if (arg.startsWith("-")) {
                returnArgs.add(arg);
                continue;
            }
            String legacyTag = this.legacyPositionalArguments.get(argAsKey);
            if (legacyTag == null) {
                returnArgs.add(arg);
                continue;
            }
            returnArgs.add(arg);
            Object value = " ";
            while (iterator.hasNext()) {
                arg = iterator.next();
                if (arg.startsWith("-")) {
                    iterator.previous();
                    break;
                }
                value = (String)value + arg + " ";
            }
            if ((value = StringUtil.trimToNull((String)value)) == null) continue;
            returnArgs.add("--" + legacyTag);
            returnArgs.add(value);
        }
        return returnArgs.toArray(new String[0]);
    }

    static String[] getCommandNames(CommandLine parseResult) {
        ArrayList<String> returnList = new ArrayList<String>();
        while (!parseResult.getCommandName().equals("liquibase")) {
            returnList.add(0, parseResult.getCommandName());
            parseResult = parseResult.getParent();
        }
        return returnList.toArray(new String[0]);
    }

    /*
     * Unable to fully structure code
     */
    private List<ConfigurationValueProvider> registerValueProviders(String[] args) throws IOException {
        liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        returnList = new ArrayList<ConfigurationValueProvider>();
        argumentProvider = new CommandLineArgumentValueProvider(this.commandLine.parseArgs(args));
        liquibaseConfiguration.registerProvider((ConfigurationValueProvider)argumentProvider);
        returnList.add((ConfigurationValueProvider)argumentProvider);
        defaultsFileConfig = LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue();
        licenseServiceFactory = (LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
        if (licenseServiceFactory != null && (licenseService = licenseServiceFactory.getLicenseService()) != null) {
            licenseService.reset();
        }
        if ((resource = (pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).getResource(defaultsFileConfigValue = (String)defaultsFileConfig.getValue())).exists()) {
            defaultsStream = resource.openInputStream();
            try {
                if (defaultsStream == null) ** GOTO lbl37
                fileProvider = new DefaultsFileValueProvider(defaultsStream, "File exists at path " + defaultsFileConfigValue);
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)fileProvider);
                returnList.add((ConfigurationValueProvider)fileProvider);
            }
            finally {
                if (defaultsStream != null) {
                    defaultsStream.close();
                }
            }
        } else {
            inputStreamOnClasspath = Thread.currentThread().getContextClassLoader().getResourceAsStream(defaultsFileConfigValue);
            if (inputStreamOnClasspath == null) {
                Scope.getCurrentScope().getLog(this.getClass()).fine("Cannot find defaultsFile " + defaultsFileConfigValue);
                if (!defaultsFileConfig.wasDefaultValueUsed()) {
                    strict = (Boolean)GlobalConfiguration.STRICT.getCurrentValue();
                    if (Boolean.TRUE.equals(strict)) {
                        throw new UnexpectedLiquibaseException("ERROR: The file '" + defaultsFileConfigValue + "' was not found. The global argument 'strict' is enabled, which validates the existence of files specified in liquibase files, such as changelogs, flowfiles, checks packages files, and more. To prevent this message, check your configurations, or disable the 'strict' setting.");
                    }
                    System.err.println("Could not find defaults file " + defaultsFileConfigValue);
                }
            } else {
                fileProvider = new DefaultsFileValueProvider(inputStreamOnClasspath, "File in classpath " + defaultsFileConfigValue);
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)fileProvider);
                returnList.add((ConfigurationValueProvider)fileProvider);
            }
        }
lbl37:
        // 4 sources

        if ((localDefaultsFile = new File((defaultsFile = new File(defaultsFileConfigValue)).getAbsolutePath().replaceFirst(".properties$", ".local.properties"))).exists()) {
            fileProvider = new DefaultsFileValueProvider(localDefaultsFile){

                public int getPrecedence() {
                    return super.getPrecedence() + 1;
                }
            };
            liquibaseConfiguration.registerProvider((ConfigurationValueProvider)fileProvider);
            returnList.add((ConfigurationValueProvider)fileProvider);
        } else {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Cannot find local defaultsFile " + defaultsFile.getAbsolutePath());
        }
        return returnList;
    }

    private Map<String, Object> configureScope(String[] args) throws Exception {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(COMMAND_ARGUMENTS, args);
        IntegrationDetails integrationDetails = new IntegrationDetails();
        integrationDetails.setName((String)LiquibaseCommandLineConfiguration.INTEGRATION_NAME.getCurrentValue());
        returnMap.put(Scope.Attr.integrationDetails.name(), integrationDetails);
        returnMap.putAll(this.configureLogging());
        String configuredChannels = (String)LiquibaseCommandLineConfiguration.LOG_CHANNELS.getCurrentValue();
        returnMap.put("logChannels", configuredChannels);
        Map<String, String> javaProperties = this.addJavaPropertiesToChangelogParameters();
        Scope.child(new HashMap<String, String>(javaProperties), () -> returnMap.putAll(this.configureResourceAccessor(Thread.currentThread().getContextClassLoader())));
        UIService defaultUiService = LiquibaseCommandLine.getDefaultUiService();
        if (defaultUiService instanceof ConsoleUIService) {
            defaultUiService.setAllowPrompt(true);
            ((ConsoleUIService)defaultUiService).setOutputStream(System.err);
            ArrayList<Object> outputServices = new ArrayList<Object>();
            outputServices.add(defaultUiService);
            if (BooleanUtil.isTrue((Boolean)((Boolean)LiquibaseCommandLineConfiguration.MIRROR_CONSOLE_MESSAGES_TO_LOG.getCurrentValue()))) {
                outputServices.add(new LoggerUIService());
            }
            CompositeUIService compositeUIService = new CompositeUIService(defaultUiService, outputServices);
            returnMap.put(Scope.Attr.ui.name(), compositeUIService);
        } else {
            returnMap.put(Scope.Attr.ui.name(), defaultUiService);
        }
        returnMap.put(LiquibaseCommandLineConfiguration.ARGUMENT_CONVERTER.getKey(), argument -> "--" + StringUtil.toKabobCase((String)argument));
        returnMap.put("javaProperties", javaProperties);
        returnMap.put("SUPPRESS_SHOWING_EXCEPTION_IN_LOG", new AtomicBoolean());
        return returnMap;
    }

    private static UIService getDefaultUiService() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List uiServices = Scope.getCurrentScope().getServiceLocator().findInstances(UIService.class);
        Class configuredUiServiceClass = ((UIServiceEnum)GlobalConfiguration.UI_SERVICE.getCurrentValue()).getUiServiceClass();
        Optional<UIService> optionalDefaultUiService = uiServices.stream().filter(uiService -> configuredUiServiceClass.isAssignableFrom(uiService.getClass())).findFirst();
        if (optionalDefaultUiService.isPresent()) {
            return optionalDefaultUiService.get();
        }
        return (UIService)((UIServiceEnum)GlobalConfiguration.UI_SERVICE.getCurrentValue()).getUiServiceClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private void configureVersionInfo() {
        this.getRootCommand(this.commandLine).getCommandSpec().versionProvider((CommandLine.IVersionProvider)new LiquibaseVersionProvider());
    }

    protected Map<String, Object> configureLogging() throws IOException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(1);
        ConfiguredValue currentConfiguredValue = LiquibaseCommandLineConfiguration.LOG_LEVEL.getCurrentConfiguredValue();
        String logFile = (String)LiquibaseCommandLineConfiguration.LOG_FILE.getCurrentValue();
        Level logLevel = Level.OFF;
        if (!currentConfiguredValue.wasDefaultValueUsed()) {
            logLevel = (Level)currentConfiguredValue.getValue();
        }
        this.configureLogging(logLevel, logFile, currentConfiguredValue.wasDefaultValueUsed());
        returnMap.put("logLevel", logLevel);
        return returnMap;
    }

    private void configureLogging(Level logLevel, String logFile) throws IOException {
        this.configureLogging(logLevel, logFile, false);
    }

    private void configureLogging(Level logLevel, String logFile, boolean wasDefaultLogLevelUsed) throws IOException {
        ArrayList<String> channels;
        String configuredChannels;
        this.configuredLogLevel = logLevel;
        LogService logService = (LogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        java.util.logging.Logger liquibaseLogger = java.util.logging.Logger.getLogger("liquibase");
        if (logService instanceof JavaLogService) {
            ((JavaLogService)logService).setParent(liquibaseLogger);
        }
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        Level cliLogLevel = logLevel;
        Level fileLogLevelOverride = null;
        if (logFile != null) {
            if (this.fileHandler == null) {
                PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
                OutputStream outputStream = pathHandlerFactory.openResourceOutputStream(logFile, new OpenOptions().setAppend(true));
                if (StringUtils.endsWithIgnoreCase((CharSequence)logFile, (CharSequence)".gz")) {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                this.fileHandler = new StreamHandler(outputStream, new SimpleFormatter());
                JavaLogService.setFormatterOnHandler((LogService)logService, (Handler)this.fileHandler);
                rootLogger.addHandler(this.fileHandler);
            }
            this.fileHandler.setLevel(logLevel);
            if (logLevel == Level.OFF && wasDefaultLogLevelUsed) {
                fileLogLevelOverride = Level.SEVERE;
                this.fileHandler.setLevel(fileLogLevelOverride);
            }
            cliLogLevel = Level.OFF;
        }
        if ((configuredChannels = (String)LiquibaseCommandLineConfiguration.LOG_CHANNELS.getCurrentValue()).equalsIgnoreCase("all")) {
            channels = new ArrayList<String>(Arrays.asList("", "liquibase"));
        } else {
            channels = StringUtil.splitAndTrim((String)configuredChannels, (String)",");
            if (logLevel == Level.OFF) {
                channels.add("");
            }
        }
        for (String channel : channels) {
            if (channel.equalsIgnoreCase("all")) {
                channel = "";
            }
            if (fileLogLevelOverride != null) {
                java.util.logging.Logger.getLogger(channel).setLevel(fileLogLevelOverride);
                continue;
            }
            java.util.logging.Logger.getLogger(channel).setLevel(logLevel);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            if (handler instanceof ConsoleHandler) {
                handler.setLevel(cliLogLevel);
            }
            JavaLogService.setFormatterOnHandler((LogService)logService, (Handler)handler);
        }
    }

    private CommandLine getRootCommand(CommandLine commandLine) {
        while (commandLine.getParent() != null) {
            commandLine = commandLine.getParent();
        }
        return commandLine;
    }

    private Map<String, Object> configureResourceAccessor(ClassLoader classLoader) throws IOException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(Scope.Attr.resourceAccessor.name(), new SearchPathResourceAccessor(new ResourceAccessor[]{new DirectoryResourceAccessor(Paths.get(".", new String[0]).toAbsolutePath().toFile()), new ClassLoaderResourceAccessor(classLoader)}));
        return returnMap;
    }

    private void addSubcommand(CommandDefinition commandDefinition, CommandLine rootCommand) {
        List<String[]> commandNames = this.expandCommandNames(commandDefinition);
        Boolean showHidden = (Boolean)LiquibaseCommandLineConfiguration.SHOW_HIDDEN_ARGS.getCurrentValue();
        boolean showCommand = true;
        for (String[] commandName : commandNames) {
            CommandRunner commandRunner = new CommandRunner();
            CommandLine.Model.CommandSpec subCommandSpec = CommandLine.Model.CommandSpec.wrapWithoutInspection((Object)commandRunner, (CommandLine.IFactory)this.defaultFactory);
            commandRunner.setSpec(subCommandSpec);
            this.configureHelp(subCommandSpec, false);
            if (commandDefinition.getHelpFooter() != null) {
                String[] usageMessageFooter = subCommandSpec.usageMessage().footer();
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(usageMessageFooter));
                list.add(commandDefinition.getHelpFooter());
                subCommandSpec.usageMessage().footer(list.toArray(new String[0]));
            }
            String shortDescription = commandDefinition.getShortDescription();
            subCommandSpec.usageMessage().header(new String[]{StringUtil.trimToEmpty((String)shortDescription) + "\n"}).description(new String[]{StringUtil.trimToEmpty((String)commandDefinition.getLongDescription())});
            subCommandSpec.optionsCaseInsensitive(true);
            subCommandSpec.subcommandsCaseInsensitive(true);
            if (!showCommand) {
                subCommandSpec.usageMessage().hidden(true);
            } else {
                subCommandSpec.usageMessage().hidden(commandDefinition.getHidden());
            }
            showCommand = false;
            for (CommandArgumentDefinition def : commandDefinition.getArguments().values()) {
                String[] argNames = LiquibaseCommandLine.toArgNames(def);
                for (int i = 0; i < argNames.length; ++i) {
                    String description;
                    CommandLine.Model.OptionSpec.Builder builder = this.createArgBuilder(def, argNames[i]);
                    String argDisplaySuffix = "";
                    String argName = argNames[i];
                    if (commandDefinition.getName().length > 1) {
                        propertyStringToPresent = "\n(defaults file: 'liquibase.command." + StringUtil.join((String[])commandDefinition.getName(), (String)".") + "." + def.getName() + "'";
                        envStringToPresent = this.toEnvVariable("environment variable: 'liquibase.command." + StringUtil.join((String[])commandDefinition.getName(), (String)".") + "." + def.getName()) + "')" + argDisplaySuffix;
                        description = propertyStringToPresent + " " + envStringToPresent;
                    } else {
                        propertyStringToPresent = "\n(defaults file: 'liquibase.command." + def.getName() + "' OR 'liquibase.command." + StringUtil.join((String[])commandDefinition.getName(), (String)".") + "." + def.getName() + "'";
                        envStringToPresent = ", environment variable: '" + this.toEnvVariable("liquibase.command." + def.getName()) + "' OR '" + this.toEnvVariable("liquibase.command." + StringUtil.join((String[])commandDefinition.getName(), (String)".") + "." + def.getName()) + "')" + argDisplaySuffix;
                        description = propertyStringToPresent + " " + envStringToPresent;
                    }
                    if (def.getDefaultValue() != null) {
                        description = def.getDefaultValueDescription() == null ? "\nDEFAULT: " + String.valueOf(def.getDefaultValue()) + description : "\nDEFAULT: " + def.getDefaultValueDescription() + description;
                    }
                    if (def.getDescription() != null) {
                        description = def.getDescription() + description;
                    }
                    if (def.isRequired()) {
                        description = "[REQUIRED] " + description;
                    }
                    if (!def.getForcePrintedAliases().isEmpty()) {
                        String pluralized = def.getForcePrintedAliases().size() > 1 ? "aliases" : "alias";
                        description = pluralized + ": " + def.getForcePrintedAliases().stream().map(LiquibaseCommandLine::convertArgumentNameToKabobCase).collect(Collectors.joining("', '", "'", "'")) + "\n" + description;
                    }
                    builder.description(new String[]{description + "\n"});
                    if (def.getDataType().equals(Boolean.class)) {
                        builder.arity("0..1");
                    }
                    if (i > 0) {
                        builder.hidden(true);
                    } else {
                        builder.hidden(def.getHidden() && showHidden == false);
                    }
                    subCommandSpec.addOption(builder.build());
                    if (!argName.equals("--changelog-file")) continue;
                    CommandLine.Model.OptionSpec.Builder paramBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)"-D", (String[])new String[0]).required(false)).type(HashMap.class)).description(new String[]{"Pass a name/value pair for substitution in the changelog(s)\nPass as -D<property.name>=<property.value>\n[deprecated: set changelog properties in defaults file or environment variables]"})).mapFallbackValue("");
                    subCommandSpec.add((CommandLine.Model.ArgSpec)paramBuilder.build());
                }
            }
            for (String legacyArg : this.legacyNoLongerCommandArguments) {
                CommandLine.Model.OptionSpec.Builder builder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + legacyArg), (String[])new String[0]).required(false)).type(String.class)).description(new String[]{"Legacy CLI argument"})).hidden(true);
                subCommandSpec.addOption(builder.build());
                String kabobArg = StringUtil.toKabobCase((String)legacyArg);
                if (kabobArg.equals(legacyArg)) continue;
                CommandLine.Model.OptionSpec.Builder kabobOptionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + kabobArg), (String[])new String[0]).required(false)).type(String.class)).hidden(true)).description(new String[]{"Legacy CLI argument"});
                subCommandSpec.addOption(kabobOptionBuilder.build());
            }
            subCommandSpec.aliases(commandDefinition.getAliases().stream().map(cn -> cn[((String[])cn).length - 1]).collect(Collectors.toList()).toArray(new String[0]));
            this.getParentCommandSpec(commandDefinition, rootCommand).addSubcommand(commandName[commandName.length - 1], new CommandLine((Object)subCommandSpec, this.defaultFactory));
        }
    }

    private CommandLine.Model.OptionSpec.Builder createArgBuilder(CommandArgumentDefinition<?> def, String argName) {
        return (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)argName, (String[])new String[0]).required(false)).converters(new CommandLine.ITypeConverter[]{value -> {
            if (def.getDataType().equals(Boolean.class) && value.equals("")) {
                return "true";
            }
            return value;
        }})).type(String.class);
    }

    private List<String[]> expandCommandNames(CommandDefinition commandDefinition) {
        ArrayList<String[]> returnList = new ArrayList<String[]>();
        String[] standardName = (String[])commandDefinition.getName().clone();
        for (int i = 0; i < standardName.length; ++i) {
            standardName[i] = StringUtil.toKabobCase((String)commandDefinition.getName()[i]);
        }
        returnList.add(standardName);
        if (!StringUtil.join((String[])standardName, (String)" ").equals(StringUtil.join((String[])commandDefinition.getName(), (String)" "))) {
            returnList.add(commandDefinition.getName());
        }
        return returnList;
    }

    private CommandLine.Model.CommandSpec getParentCommandSpec(CommandDefinition commandDefinition, CommandLine rootCommand) {
        String[] commandName = commandDefinition.getName();
        CommandLine.Model.CommandSpec parent = rootCommand.getCommandSpec();
        for (int i = 0; i < commandName.length - 1; ++i) {
            CommandLine commandGroup = (CommandLine)parent.subcommands().get(commandName[i]);
            String[] groupName = Arrays.copyOfRange(commandName, 0, i + 1);
            if (commandGroup == null) {
                parent = this.addSubcommandGroup(groupName, commandDefinition, parent);
            } else {
                parent = commandGroup.getCommandSpec();
                if (commandDefinition.getGroupHelpFooter() != null) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(commandDefinition.getHelpFooter());
                    parent.usageMessage().footer(list.toArray(new String[0]));
                }
            }
            this.configureSubcommandGroup(parent, groupName, commandDefinition);
        }
        return parent;
    }

    private void configureSubcommandGroup(CommandLine.Model.CommandSpec groupSpec, String[] groupName, CommandDefinition commandDefinition) {
        String header = StringUtil.trimToEmpty((String)commandDefinition.getGroupShortDescription(groupName));
        String description = StringUtil.trimToEmpty((String)commandDefinition.getGroupLongDescription(groupName));
        if (!header.equals("")) {
            groupSpec.usageMessage().header(new String[]{"< " + header + " >\n"});
        }
        if (!description.equals("")) {
            groupSpec.usageMessage().description(new String[]{description + "\n"});
        }
    }

    private CommandLine.Model.CommandSpec addSubcommandGroup(String[] groupName, CommandDefinition commandDefinition, CommandLine.Model.CommandSpec parent) {
        CommandLine.Model.CommandSpec groupSpec = CommandLine.Model.CommandSpec.wrapWithoutInspection(null, (CommandLine.IFactory)this.defaultFactory);
        this.configureHelp(groupSpec, false);
        if (commandDefinition.getHelpFooter() != null) {
            String[] usageMessageFooter = groupSpec.usageMessage().footer();
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(usageMessageFooter));
            list.add(commandDefinition.getHelpFooter());
            groupSpec.usageMessage().footer(list.toArray(new String[0]));
        }
        groupSpec.optionsCaseInsensitive(true);
        groupSpec.subcommandsCaseInsensitive(true);
        parent.addSubcommand(groupName[groupName.length - 1], groupSpec);
        return groupSpec;
    }

    private String toEnvVariable(String property) {
        return StringUtil.toKabobCase((String)property).replace(".", "_").replace("-", "_").toUpperCase();
    }

    private SortedSet<CommandDefinition> getCommands() {
        CommandFactory commandFactory = (CommandFactory)Scope.getCurrentScope().getSingleton(CommandFactory.class);
        return commandFactory.getCommands(false);
    }

    private void addGlobalArguments(CommandLine commandLine) {
        CommandLine.Model.CommandSpec rootCommandSpec = commandLine.getCommandSpec();
        SortedSet globalConfigurations = ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getRegisteredDefinitions(false);
        for (ConfigurationDefinition def : globalConfigurations) {
            String[] argNames = LiquibaseCommandLine.toArgNames(def);
            for (int i = 0; i < argNames.length; ++i) {
                CommandLine.Model.OptionSpec.Builder optionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)argNames[i], (String[])new String[0]).required(false)).type(String.class);
                String description = "(defaults file: '" + def.getKey() + "', environment variable: '" + this.toEnvVariable(def.getKey()) + "')";
                if (def.getDefaultValue() != null) {
                    description = def.getDefaultValueDescription() == null ? "DEFAULT: " + String.valueOf(def.getDefaultValue()) + "\n" + description : "DEFAULT: " + def.getDefaultValueDescription() + "\n" + description;
                }
                if (def.getDescription() != null) {
                    description = def.getDescription() + "\n" + description;
                }
                optionBuilder.description(new String[]{description + "\n"});
                if (def.getDataType().equals(Boolean.class)) {
                    optionBuilder.arity("1");
                }
                if (i > 0 || def.isHidden() && !((Boolean)LiquibaseCommandLineConfiguration.SHOW_HIDDEN_ARGS.getCurrentValue()).booleanValue()) {
                    optionBuilder.hidden(true);
                }
                CommandLine.Model.OptionSpec optionSpec = optionBuilder.build();
                rootCommandSpec.addOption(optionSpec);
            }
        }
        for (String arg : this.legacyNoLongerGlobalArguments) {
            CommandLine.Model.OptionSpec.Builder optionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + arg), (String[])new String[0]).required(false)).type(String.class)).hidden(true)).description(new String[]{"Legacy global argument"});
            rootCommandSpec.addOption(optionBuilder.build());
            String kabobArg = StringUtil.toKabobCase((String)arg);
            if (kabobArg.equals(arg)) continue;
            CommandLine.Model.OptionSpec.Builder kabobOptionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + kabobArg), (String[])new String[0]).required(false)).type(String.class)).hidden(true)).description(new String[]{"Legacy global argument"});
            rootCommandSpec.addOption(kabobOptionBuilder.build());
        }
    }

    private void configureHelp(CommandLine.Model.CommandSpec commandSpec, boolean includeVersion) {
        String footer = "Each argument contains the corresponding 'configuration key' in parentheses. As an alternative to passing values on the command line, these keys can be used as a basis for configuration settings in other locations.\n\nAvailable configuration locations, in order of priority:\n- Command line arguments (argument name in --help)\n- Java system properties (configuration key listed above)\n- Environment values (env variable listed above)\n- Defaults file (configuration key OR argument name)\n\nFull documentation is available at\nhttps://docs.liquibase.com";
        commandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)"--help", (String[])new String[]{"-h"}).description(new String[]{"Show this help message and exit\n"})).usageHelp(true).build());
        if (includeVersion) {
            commandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)"--version", (String[])new String[]{"-v"}).description(new String[]{"Print version information and exit\n"})).versionHelp(true).build());
        }
        commandSpec.usageMessage().showDefaultValues(false).sortOptions(true).abbreviateSynopsis(true).footer(new String[]{"\n" + footer});
    }

    protected static String[] toArgNames(CommandArgumentDefinition<?> def) {
        LinkedHashSet<Object> returnList = new LinkedHashSet<Object>();
        LinkedHashSet<String> baseNames = new LinkedHashSet<String>();
        baseNames.add(def.getName());
        baseNames.addAll(def.getAliases());
        for (String baseName : baseNames) {
            returnList.add(LiquibaseCommandLine.convertArgumentNameToKabobCase(baseName));
            returnList.add("--" + baseName.replace("\\.", ""));
        }
        return returnList.toArray(new String[0]);
    }

    private static String convertArgumentNameToKabobCase(String baseName) {
        return "--" + StringUtil.toKabobCase((String)baseName).replace(".", "-");
    }

    protected static String[] toArgNames(ConfigurationDefinition<?> def) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(def.getKey());
        keys.addAll(def.getAliasKeys());
        CaseInsensitiveList returns = new CaseInsensitiveList();
        for (String key : keys) {
            LiquibaseCommandLine.insertWithoutDuplicates(returns, LiquibaseCommandLine.convertArgumentNameToKabobCase(key.replaceFirst("^liquibase.", "")));
            LiquibaseCommandLine.insertWithoutDuplicates(returns, "--" + StringUtil.toKabobCase((String)key.replace(".", "-")));
            LiquibaseCommandLine.insertWithoutDuplicates(returns, "--" + key.replaceFirst("^liquibase.", "").replaceAll("\\.", ""));
            LiquibaseCommandLine.insertWithoutDuplicates(returns, "--" + key.replaceAll("\\.", ""));
        }
        return returns.toArray(new String[0]);
    }

    private static void insertWithoutDuplicates(List<String> returnList, String key) {
        if (returnList.contains(key)) {
            return;
        }
        returnList.add(key);
    }

    public static class LiquibaseVersionProvider
    implements CommandLine.IVersionProvider {
        public String[] getVersion() throws Exception {
            Object liquibaseHome;
            Version mdcVersion = new Version();
            LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
            String licenseInfo = "";
            if (licenseService != null) {
                licenseInfo = licenseService.getLicenseInfo();
            }
            Path workingDirectory = Paths.get(".", new String[0]).toAbsolutePath();
            Path liquibaseHomePath = null;
            try {
                liquibaseHomePath = VersionUtils.getLiquibaseHomePath((Path)workingDirectory);
                liquibaseHome = liquibaseHomePath.toString();
            }
            catch (IOException e) {
                liquibaseHome = "Cannot resolve LIQUIBASE_HOME: " + e.getMessage();
            }
            Map libraryInfo = VersionUtils.getLibraryInfoMap();
            StringBuilder libraryDescription = new StringBuilder("Libraries:\n");
            if (libraryInfo.size() == 0) {
                libraryDescription.append("- UNKNOWN");
            } else {
                List libraries = VersionUtils.listLibraries((Map)libraryInfo, (Path)liquibaseHomePath, (Path)workingDirectory, (Version)mdcVersion);
                for (String library : libraries) {
                    libraryDescription.append("- ").append(library).append("\n");
                }
            }
            String javaHome = System.getProperties().getProperty("java.home");
            String javaVersion = System.getProperty("java.version");
            this.addMdc(mdcVersion, licenseService, (String)liquibaseHome, javaHome, javaVersion);
            return new String[]{CommandLineUtils.getBanner(), String.format("Liquibase Home: %s", liquibaseHome), String.format("Java Home %s (Version %s)", javaHome, javaVersion), libraryDescription.toString(), "", "Liquibase Version: " + LiquibaseUtil.getBuildVersionInfo(), licenseInfo};
        }

        private void addMdc(Version mdcVersion, LicenseService licenseService, String liquibaseHome, String javaHome, String javaVersion) {
            mdcVersion.setJavaHome(new Version.JavaHome(javaHome, javaVersion));
            Banner banner = new Banner();
            LicenseInfo licenseInfoObject = null;
            if (licenseService != null) {
                licenseInfoObject = licenseService.getLicenseInfoObject();
            }
            if (licenseInfoObject != null) {
                banner.setLicensee(licenseInfoObject.getIssuedTo());
                banner.setLicenseEndDate(licenseInfoObject.formatExpirationDate());
            }
            banner.setPath(liquibaseHome);
            mdcVersion.setLiquibaseVersion(banner);
            try (MdcObject version = Scope.getCurrentScope().addMdcValue("version", (CustomMdcObject)mdcVersion);){
                Scope.getCurrentScope().getLog(this.getClass()).info("Generated version info");
            }
        }
    }

    private static class CaseInsensitiveList
    extends ArrayList<String> {
        private CaseInsensitiveList() {
        }

        @Override
        public boolean contains(Object o) {
            String paramStr = (String)o;
            for (String s : this) {
                if (!paramStr.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }
    }
}

