/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.cdi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import liquibase.Scope;
import liquibase.integration.cdi.annotations.LiquibaseSchema;
import liquibase.integration.cdi.exceptions.CyclicDependencyException;
import liquibase.integration.cdi.exceptions.DependencyNotFoundException;
import liquibase.logging.Logger;

@ApplicationScoped
public class SchemesTreeBuilder {
    private static final Logger log = Scope.getCurrentScope().getLog(SchemesTreeBuilder.class);

    public List<LiquibaseSchema> build(String id, Collection<LiquibaseSchema> schemes) {
        log.fine(String.format("[id = %s] build(%s)", id, schemes));
        log.info(String.format("[id = %s] Sorting schemes according dependencies...", id));
        if (schemes.isEmpty()) {
            return Collections.emptyList();
        }
        SchemaNode root = null;
        schemes = new ArrayList<LiquibaseSchema>(schemes);
        ArrayList<LiquibaseSchema> availableSchemes = new ArrayList<LiquibaseSchema>(schemes);
        ArrayList<LiquibaseSchema> notDependent = new ArrayList<LiquibaseSchema>();
        for (LiquibaseSchema liquibaseSchema : schemes) {
            String depends = liquibaseSchema.depends();
            if (!depends.trim().isEmpty()) continue;
            notDependent.add(liquibaseSchema);
        }
        log.info(String.format("[id = %s] Found [%s] not dependent schemes.", id, notDependent.size()));
        if (notDependent.isEmpty()) {
            throw new CyclicDependencyException(String.format("[id = %s] Not independent schemes, possible cyclic dependencies discovered.", id));
        }
        root = new SchemaNode((LiquibaseSchema)notDependent.get(0));
        log.fine(String.format("[id = %s] Selected dependencies tree root [%s]", id, root.getItem()));
        availableSchemes.removeAll(notDependent);
        notDependent.remove(root.getItem());
        schemes.retainAll(availableSchemes);
        for (LiquibaseSchema liquibaseSchema : notDependent) {
            root.addChild(liquibaseSchema);
        }
        log.fine(String.format("[id = %s] Made other non-dependent schemes children of root. [%s] dependent schemes to resolve. Resolving...", id, availableSchemes.size()));
        int cycles = 0;
        long start = System.currentTimeMillis();
        while (!availableSchemes.isEmpty()) {
            log.fine(String.format("[id = %s] Resolution cycle [%s] started.", id, ++cycles));
            int additions = 0;
            for (LiquibaseSchema liquibaseSchema : schemes) {
                log.fine(String.format("[id = %s] LiquibaseSchema [name=%s] depends on liquibaseSchema [name=%s].", id, liquibaseSchema.name(), liquibaseSchema.depends()));
                SchemaNode parent = root.find(liquibaseSchema.depends());
                if (parent == null) {
                    log.fine(String.format("[id = %s] Dependency not found in resolved dependencies tree, skipping liquibaseSchema [name=%s] for a while.", id, liquibaseSchema.name()));
                    boolean isDependencyMissed = true;
                    for (LiquibaseSchema tmpLiquibaseSchema : availableSchemes) {
                        if (!tmpLiquibaseSchema.name().equalsIgnoreCase(liquibaseSchema.depends())) continue;
                        isDependencyMissed = false;
                        break;
                    }
                    if (!isDependencyMissed) continue;
                    throw new DependencyNotFoundException(String.format("[id = %s][name=%s] depends on [name=%s], but it is not found!", id, liquibaseSchema.name(), liquibaseSchema.depends()));
                }
                log.fine(String.format("[id = %s] Dependency found for liquibaseSchema [name=%s], moving it to resolved dependencies tree.", id, liquibaseSchema.name()));
                parent.addChild(liquibaseSchema);
                availableSchemes.remove(liquibaseSchema);
                ++additions;
            }
            log.fine(String.format("[id = %s] Resolution cycle [%s] completed", id, cycles));
            if (additions == 0) {
                throw new CyclicDependencyException(String.format("[id = %s] Cyclic dependencies discovered!", id));
            }
            schemes.retainAll(availableSchemes);
        }
        log.info(String.format("[id = %s] Dependencies resolved in [cycles=%s, millis=%s]", id, cycles, System.currentTimeMillis() - start));
        return root.toList();
    }

    private class SchemaNode {
        private final LiquibaseSchema item;
        private final Collection<SchemaNode> children = new ArrayList<SchemaNode>();

        public SchemaNode(LiquibaseSchema item) {
            this.item = item;
        }

        public LiquibaseSchema getItem() {
            return this.item;
        }

        public Collection<SchemaNode> getChildren() {
            return Collections.unmodifiableCollection(this.children);
        }

        public void addChild(LiquibaseSchema child) {
            this.children.add(new SchemaNode(child));
        }

        public SchemaNode find(String name) {
            SchemaNode result = null;
            if (this.item.name().equals(name)) {
                result = this;
            } else {
                for (SchemaNode child : this.children) {
                    SchemaNode found = child.find(name);
                    if (result == null && found != null) {
                        result = child.find(name);
                        continue;
                    }
                    if (result == null || found == null) continue;
                    throw new IllegalStateException(String.format("Duplicate schema names [%s] detected!", result.getItem().name()));
                }
            }
            return result;
        }

        public List<LiquibaseSchema> toList() {
            ArrayList<LiquibaseSchema> list = new ArrayList<LiquibaseSchema>(this.children.size() + 1);
            list.add(this.item);
            for (SchemaNode child : this.children) {
                list.addAll(child.toList());
            }
            return list;
        }
    }
}

