/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot.extension;

import liquibase.ext.hibernate.snapshot.extension.ExtendedSnapshotGenerator;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import org.hibernate.generator.Generator;
import org.hibernate.id.enhanced.TableGenerator;

public class TableGeneratorSnapshotGenerator
implements ExtendedSnapshotGenerator<Generator, Table> {
    private static final String PK_DATA_TYPE = "varchar";
    private static final String VALUE_DATA_TYPE = "bigint";

    @Override
    public Table snapshot(Generator ig) {
        TableGenerator tableGenerator = (TableGenerator)ig;
        Table table = new Table().setName(tableGenerator.getTableName());
        Column pkColumn = new Column();
        pkColumn.setName(tableGenerator.getSegmentColumnName());
        DataType pkDataType = new DataType(PK_DATA_TYPE);
        pkDataType.setColumnSize(Integer.valueOf(tableGenerator.getSegmentValueLength()));
        pkColumn.setType(pkDataType);
        pkColumn.setCertainDataType(false);
        pkColumn.setRelation((Relation)table);
        table.getColumns().add(pkColumn);
        PrimaryKey primaryKey = new PrimaryKey();
        primaryKey.setName(tableGenerator.getTableName() + "PK");
        primaryKey.addColumn(0, new Column(pkColumn.getName()).setRelation((Relation)table));
        primaryKey.setTable(table);
        table.setPrimaryKey(primaryKey);
        Column valueColumn = new Column();
        valueColumn.setName(tableGenerator.getValueColumnName());
        valueColumn.setType(new DataType(VALUE_DATA_TYPE));
        valueColumn.setNullable(Boolean.valueOf(false));
        valueColumn.setCertainDataType(false);
        valueColumn.setRelation((Relation)table);
        table.getColumns().add(valueColumn);
        return table;
    }

    @Override
    public boolean supports(Generator ig) {
        return ig instanceof TableGenerator;
    }
}

