/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.diff;

import java.util.List;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;

public class ChangedColumnChangeGenerator
extends liquibase.diff.output.changelog.core.ChangedColumnChangeGenerator {
    private static final List<String> TYPES_TO_IGNORE_SIZE = List.of("TIMESTAMP", "TIME");

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Column.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    protected void handleTypeDifferences(Column column, ObjectDifferences differences, DiffOutputControl control, List<Change> changes, Database referenceDatabase, Database comparisonDatabase) {
        if (referenceDatabase instanceof HibernateDatabase || comparisonDatabase instanceof HibernateDatabase) {
            this.handleSizeChange(column, differences, control, changes, referenceDatabase, comparisonDatabase);
        } else {
            super.handleTypeDifferences(column, differences, control, changes, referenceDatabase, comparisonDatabase);
        }
    }

    private void handleSizeChange(Column column, ObjectDifferences differences, DiffOutputControl control, List<Change> changes, Database referenceDatabase, Database comparisonDatabase) {
        if (TYPES_TO_IGNORE_SIZE.stream().anyMatch(s -> s.equalsIgnoreCase(column.getType().getTypeName()))) {
            return;
        }
        Difference difference = differences.getDifference("type");
        if (difference != null) {
            for (Difference d : differences.getDifferences()) {
                if (!(d.getReferenceValue() instanceof DataType)) {
                    differences.removeDifference(d.getField());
                    continue;
                }
                Integer originalSize = ((DataType)d.getReferenceValue()).getColumnSize();
                Integer newSize = ((DataType)d.getComparedValue()).getColumnSize();
                if (newSize != null && originalSize != null && !newSize.equals(originalSize)) continue;
                differences.removeDifference(d.getField());
            }
            super.handleTypeDifferences(column, differences, control, changes, referenceDatabase, comparisonDatabase);
        }
    }

    protected void handleDefaultValueDifferences(Column column, ObjectDifferences differences, DiffOutputControl control, List<Change> changes, Database referenceDatabase, Database comparisonDatabase) {
        if (referenceDatabase instanceof HibernateDatabase || comparisonDatabase instanceof HibernateDatabase) {
            Difference difference = differences.getDifference("defaultValue");
            if (difference != null && difference.getReferenceValue() == null && difference.getComparedValue() instanceof DatabaseFunction) {
                return;
            }
            difference = differences.getDifference("defaultValue");
            if (difference != null) {
                super.handleDefaultValueDifferences(column, differences, control, changes, referenceDatabase, comparisonDatabase);
            }
        }
        super.handleDefaultValueDifferences(column, differences, control, changes, referenceDatabase, comparisonDatabase);
    }
}

