/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.diff;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Sequence;

public class ChangedSequenceChangeGenerator
extends liquibase.diff.output.changelog.core.ChangedSequenceChangeGenerator {
    private static final Set<String> HIBERNATE_SEQUENCE_FIELDS;

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Sequence.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        if (!(referenceDatabase instanceof HibernateDatabase) && !(comparisonDatabase instanceof HibernateDatabase)) {
            return super.fixChanged(changedObject, differences, control, referenceDatabase, comparisonDatabase, chain);
        }
        Set ignoredDifferenceFields = differences.getDifferences().stream().map(Difference::getField).filter(differenceField -> !HIBERNATE_SEQUENCE_FIELDS.contains(differenceField)).collect(Collectors.toCollection(LinkedHashSet::new));
        ignoredDifferenceFields.forEach(arg_0 -> ((ObjectDifferences)differences).removeDifference(arg_0));
        return super.fixChanged(changedObject, differences, control, referenceDatabase, comparisonDatabase, chain);
    }

    static {
        HashSet<String> hibernateSequenceFields = new HashSet<String>();
        hibernateSequenceFields.add("name");
        hibernateSequenceFields.add("startValue");
        hibernateSequenceFields.add("incrementBy");
        HIBERNATE_SEQUENCE_FIELDS = Collections.unmodifiableSet(hibernateSequenceFields);
    }
}

