/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.ips.ui.element;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Optional;
import org.linkki.core.defaults.ui.element.ItemCaptionProvider;
import org.linkki.core.uiframework.UiFramework;

public class IdAndNameCaptionProvider
implements ItemCaptionProvider<Object> {
    public String getCaption(Object o) {
        return IdAndNameCaptionProvider.getName(o) + " [" + this.getId(o) + "]";
    }

    @CheckForNull
    private String getId(Object value) {
        Optional<Method> getIdMethod = IdAndNameCaptionProvider.getMethod(value, "getId", new Class[0]);
        if (getIdMethod.isPresent()) {
            return IdAndNameCaptionProvider.invokeStringMethod(getIdMethod.get(), value, new Object[0]);
        }
        throw new IllegalStateException("Cannot get id from object " + value);
    }

    @CheckForNull
    private static String getName(Object value) {
        Optional<Method> getLocalizedNameMethod = IdAndNameCaptionProvider.getMethod(value, "getName", Locale.class);
        if (getLocalizedNameMethod.isPresent()) {
            return IdAndNameCaptionProvider.invokeStringMethod(getLocalizedNameMethod.get(), value, UiFramework.getLocale());
        }
        Optional<Method> getNameMethod = IdAndNameCaptionProvider.getMethod(value, "getName", new Class[0]);
        if (getNameMethod.isPresent()) {
            return IdAndNameCaptionProvider.invokeStringMethod(getNameMethod.get(), value, new Object[0]);
        }
        Method toStringMethod = IdAndNameCaptionProvider.getMethod(value, "toString", new Class[0]).orElseThrow();
        return IdAndNameCaptionProvider.invokeStringMethod(toStringMethod, value, new Object[0]);
    }

    private static Optional<Method> getMethod(Object value, String name, Class<?> ... parameters) {
        try {
            Method method = value.getClass().getMethod(name, parameters);
            return Optional.of(method);
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    @CheckForNull
    private static String invokeStringMethod(Method method, Object value, Object ... parameters) {
        try {
            return (String)method.invoke(value, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException("Can't get value from method " + value.getClass() + "#" + method.getName() + " of " + value);
        }
    }
}

