/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.ips.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.faktorips.annotation.UtilityClass;
import org.faktorips.runtime.Message;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.validation.message.MessageListCollector;
import org.linkki.core.binding.validation.message.ObjectProperty;
import org.linkki.core.binding.validation.message.Severity;
import org.linkki.ips.messages.ValidationMarkerWrapper;
import org.linkki.util.StreamUtil;

@UtilityClass
public final class MessageConverter {
    private static final Map<org.faktorips.runtime.Severity, Severity> SEVERITY_MAP;

    private MessageConverter() {
    }

    public static MessageList convert(org.faktorips.runtime.MessageList ipsMessages) {
        if (ipsMessages == null) {
            return new MessageList(new org.linkki.core.binding.validation.message.Message[0]);
        }
        return (MessageList)StreamUtil.stream((Iterable)ipsMessages).map(MessageConverter::convert).collect(MessageListCollector.toMessageList());
    }

    public static org.linkki.core.binding.validation.message.Message convert(Message ipsMessage) {
        Objects.requireNonNull(ipsMessage, "ipsMessage must not be null");
        String text = ipsMessage.getText();
        if (text == null) {
            text = "";
        }
        Message.Builder builder = org.linkki.core.binding.validation.message.Message.builder((String)text, (Severity)SEVERITY_MAP.get(ipsMessage.getSeverity())).code(ipsMessage.getCode());
        if (ipsMessage.hasMarkers()) {
            builder.markers((Collection)ipsMessage.getMarkers().stream().map(ValidationMarkerWrapper::new).collect(Collectors.toList()));
        }
        builder.invalidObjects(ipsMessage.getInvalidObjectProperties().stream().map(o -> new ObjectProperty(o.getObject(), o.getProperty())).collect(Collectors.toList()));
        return builder.create();
    }

    static {
        HashMap<org.faktorips.runtime.Severity, Severity> map = new HashMap<org.faktorips.runtime.Severity, Severity>(5);
        map.put(org.faktorips.runtime.Severity.INFO, Severity.INFO);
        map.put(org.faktorips.runtime.Severity.WARNING, Severity.WARNING);
        map.put(org.faktorips.runtime.Severity.ERROR, Severity.ERROR);
        map.put(null, Severity.INFO);
        map.put(org.faktorips.runtime.Severity.NONE, Severity.INFO);
        SEVERITY_MAP = Collections.unmodifiableMap(map);
    }
}

